###################################################
### chunk number 1: 
###################################################
#line 247 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
options(prompt = "R> ")
options(continue = "R+ ")


###################################################
### chunk number 2: 
###################################################
#line 251 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
set.seed(42)

sim <- function(slope.multiplier = 1) {
    x <- as.matrix(runif(99))
    s <- slope.multiplier * c(-10,0,10)
    y <- c(s[1]*x[1:33], s[2]*x[34:66], s[3]*x[67:99]) + rnorm(99)
    group <- rep(1:33, rep(3,33))
    return(data.frame(x=x,y=y,group=group))
}
dat <- sim()
library("profdpm")
fitL <- profLinear(y ~ 0 + x, group=group, data=dat)


###################################################
### chunk number 3: figSim1
###################################################
#line 269 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
sfitL <- summary(fitL)
plot(dat$x, dat$y, col=grey(0.9), xlab='x', ylab='y')
for(grp in unique(dat$group)) {
    ind <- which(dat$group==grp)
    ord <- order(dat$x[ind])
    lines(dat$x[ind][ord], dat$y[ind][ord], col=grey(0.9))
}
for(cls in 1:length(sfitL)) {
    abline(a=0,b=sfitL[[cls]]$sum$est[1], col=cls, lty=2)
    abline(a=0,b=sfitL[[cls]]$sum$low[1], col=cls)
    abline(a=0,b=sfitL[[cls]]$sum$upp[1], col=cls)
}


###################################################
### chunk number 4: 
###################################################
#line 286 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
#line 269 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw#from line#286#"
sfitL <- summary(fitL)
plot(dat$x, dat$y, col=grey(0.9), xlab='x', ylab='y')
for(grp in unique(dat$group)) {
    ind <- which(dat$group==grp)
    ord <- order(dat$x[ind])
    lines(dat$x[ind][ord], dat$y[ind][ord], col=grey(0.9))
}
for(cls in 1:length(sfitL)) {
    abline(a=0,b=sfitL[[cls]]$sum$est[1], col=cls, lty=2)
    abline(a=0,b=sfitL[[cls]]$sum$low[1], col=cls)
    abline(a=0,b=sfitL[[cls]]$sum$upp[1], col=cls)
}
#line 287 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"


###################################################
### chunk number 5: 
###################################################
#line 302 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
simulatedPartL <- rep(1:3, rep(33,3))
estimatedPartL <- fitL$clust
pci(simulatedPartL, estimatedPartL)


###################################################
### chunk number 6: figSim2
###################################################
#line 314 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
mult <- rep(seq(1, 0.01, length.out=33), 10)
Rand <- sapply(mult, function(mult) {
    dat <- sim(mult)
    fit <- profLinear(y ~ 0 + x, group=group, data=dat)
    pci(rep(1:3, rep(33,3)), fit$clust)['R']
})
lws <- lowess(x=mult,y=Rand)
plot(lws$x, lws$y, type='l',
     xlab='slope multiplier', ylab='Rand index')
points(mult + rnorm(length(mult),0,1/200),
     Rand + rnorm(length(Rand),0,1/200), col=grey(0.9))


###################################################
### chunk number 7: 
###################################################
#line 332 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
#line 314 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw#from line#332#"
mult <- rep(seq(1, 0.01, length.out=33), 10)
Rand <- sapply(mult, function(mult) {
    dat <- sim(mult)
    fit <- profLinear(y ~ 0 + x, group=group, data=dat)
    pci(rep(1:3, rep(33,3)), fit$clust)['R']
})
lws <- lowess(x=mult,y=Rand)
plot(lws$x, lws$y, type='l',
     xlab='slope multiplier', ylab='Rand index')
points(mult + rnorm(length(mult),0,1/200),
     Rand + rnorm(length(Rand),0,1/200), col=grey(0.9))
#line 333 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"


###################################################
### chunk number 8: 
###################################################
#line 352 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
p <- seq(0.9,0.1,length.out=9)
y1 <- matrix(rbinom(999, 1, p), 111, 9, TRUE)
y2 <- matrix(rbinom(999, 1, rev(p)), 111, 9, TRUE)
dat <- as.data.frame(rbind(y1, y2))
fitb <- profBinary(~0+., data=dat)


###################################################
### chunk number 9: figSim3
###################################################
#line 367 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
alpha <- 10^(-seq(0, 40, length.out=33))
Rand <- sapply(alpha, function(alpha) {
    fit <- profBinary(~0+., data=dat, param=list(alpha=alpha))
    pci(rep(1:2, rep(111,2)), fit$clust)['R']
})
lws <- lowess(x=log(alpha),y=Rand)
plot(lws$x, lws$y, type='l',
     xlab=expression(paste('log', alpha)),
     ylab='Rand index')

points(log(alpha), Rand + rnorm(length(Rand),0,1/200),
     col=grey(0.9))


###################################################
### chunk number 10: 
###################################################
#line 384 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"
#line 367 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw#from line#384#"
alpha <- 10^(-seq(0, 40, length.out=33))
Rand <- sapply(alpha, function(alpha) {
    fit <- profBinary(~0+., data=dat, param=list(alpha=alpha))
    pci(rep(1:2, rep(111,2)), fit$clust)['R']
})
lws <- lowess(x=log(alpha),y=Rand)
plot(lws$x, lws$y, type='l',
     xlab=expression(paste('log', alpha)),
     ylab='Rand index')

points(log(alpha), Rand + rnorm(length(Rand),0,1/200),
     col=grey(0.9))
#line 385 "d:/Rcompile/CRANpkg/local/2.12/profdpm/inst/doc/profdpm.Rnw"


