###################################################
### chunk number 1: preliminaries
###################################################
#line 79 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
options(width = 70, prompt = "R> ", continue = "+  ")
library("psychomix")
data("VerbalAggression", package = "psychotools")
set.seed(1090)
cache <- FALSE


###################################################
### chunk number 2: data-rost2
###################################################
#line 714 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
set.seed(1)
r2 <- simRaschmix(design = "rost2")
d <- data.frame(
  x1 = rbinom(nrow(r2), prob = c(0.4, 0.6)[attr(r2, "group")], size = 1),
  x2 = rnorm(nrow(r2))
)
d$resp <- r2


###################################################
### chunk number 3: fitRost0 eval=FALSE
###################################################
## #line 730 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
## m1 <- raschmix(r2, k = 1:3)
## m1


###################################################
### chunk number 4: fitRost
###################################################
#line 734 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
if(cache & file.exists("m1.rda")) {
  load("m1.rda")
} else {
#line 730 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw#from line#737#"
m1 <- raschmix(r2, k = 1:3)
m1
#line 738 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
if(cache) {
  save(m1, file = "m1.rda")
} else {
  if(file.exists("m1.rda")) file.remove("m1.rda")
}
}


###################################################
### chunk number 5: printRost
###################################################
#line 746 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
m1


###################################################
### chunk number 6: plotRost
###################################################
#line 753 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
plot(m1)


###################################################
### chunk number 7: selectRost
###################################################
#line 778 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
BIC(m1)
m1b <- getModel(m1, which = "BIC")
summary(m1b)


###################################################
### chunk number 8: itemParaRost
###################################################
#line 814 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
parameters(m1b, "item")
worth(m1b)
attr(r2, "item")


###################################################
### chunk number 9: clustersRost
###################################################
#line 836 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
table(model = clusters(m1b), true = attr(r2, "group"))


###################################################
### chunk number 10: fitMeanVar0 eval=FALSE
###################################################
## #line 845 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
## m2 <- raschmix(data = r2, k = 1:3, scores = "meanvar")


###################################################
### chunk number 11: fitMeanVar
###################################################
#line 848 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
if(cache & file.exists("m2.rda")) {
  load("m2.rda")
} else {
#line 845 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw#from line#851#"
m2 <- raschmix(data = r2, k = 1:3, scores = "meanvar")
#line 852 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
if(cache) {
  save(m2, file = "m2.rda")
} else {
  if(file.exists("m2.rda")) file.remove("m2.rda")
}
}


###################################################
### chunk number 12: selectMeanVar
###################################################
#line 861 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
m2
m2b <- getModel(m2, which = "BIC")


###################################################
### chunk number 13: itemCompPlot
###################################################
#line 869 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
par(mfrow = c(1,2))
plot(m1b, pos = "top")
for(i in 1:2) lines(attr(r2, "item")[,i], lty = 2, type = "b")
plot(m2b, pos = "top")
for(i in 1:2) lines(attr(r2, "item")[,i], lty = 2, type = "b")


###################################################
### chunk number 14: compNPara
###################################################
#line 889 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
logLik(m2b)
logLik(m1b)


###################################################
### chunk number 15: scoreProbs:Rost2
###################################################
#line 900 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
parameters(m2b, which = "score")
scoreProbs(m2b)


###################################################
### chunk number 16: fitMeanVarConc0 eval=FALSE
###################################################
## #line 916 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
## cm2 <- raschmix(resp ~ x1 + x2, data = d, k = 2:3, scores = "meanvar")


###################################################
### chunk number 17: fitMeanVarConc
###################################################
#line 919 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
if(cache & file.exists("cm2.rda")) {
  load("cm2.rda")
} else {
#line 916 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw#from line#922#"
cm2 <- raschmix(resp ~ x1 + x2, data = d, k = 2:3, scores = "meanvar")
#line 923 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
if(cache) {
  save(cm2, file = "cm2.rda")
} else {
  if(file.exists("cm2.rda")) file.remove("cm2.rda")
}
}


###################################################
### chunk number 18: selectMeanVarConc
###################################################
#line 937 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
rbind(m2 = BIC(m2), cm2 = c(NA, BIC(cm2)))


###################################################
### chunk number 19: concPara
###################################################
#line 948 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
cm2b <- getModel(cm2, which = "BIC")
parameters(cm2b, which = "concomitant")


###################################################
### chunk number 20: concTable
###################################################
#line 964 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
table(x1 = d$x1, clusters = clusters(cm2b))


###################################################
### chunk number 21: dataVerbal
###################################################
#line 999 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
data("VerbalAggression", package = "psychotools")
VerbalAggression$resp2 <- VerbalAggression$resp2[, 1:12]
va12 <- subset(VerbalAggression,
  rowSums(resp2) > 0 & rowSums(resp2) < 12)
colnames(va12$resp2)


###################################################
### chunk number 22: vMeanVarFit0 eval=FALSE
###################################################
## #line 1011 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
## set.seed(1)
## va12_mix1 <- raschmix(resp2 ~ 1, data = va12, k = 1:4, scores = "meanvar")
## va12_mix2 <- raschmix(resp2 ~ gender + anger, data = va12, k = 2:4,
##   scores = "meanvar")


###################################################
### chunk number 23: vMeanVarFit
###################################################
#line 1017 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
if(cache & file.exists("va12_mix.rda")) {
  load("va12_mix.rda")
} else {
#line 1011 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw#from line#1020#"
set.seed(1)
va12_mix1 <- raschmix(resp2 ~ 1, data = va12, k = 1:4, scores = "meanvar")
va12_mix2 <- raschmix(resp2 ~ gender + anger, data = va12, k = 2:4,
  scores = "meanvar")
#line 1021 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
if(cache) {
  save(va12_mix1, va12_mix2, file = "va12_mix.rda")
} else {
  if(file.exists("va12_mix.rda")) file.remove("va12_mix.rda")
}
}


###################################################
### chunk number 24: selectVMeanVar
###################################################
#line 1032 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
rbind(BIC(va12_mix1), c(NA, BIC(va12_mix2)))
va12_mix3 <- getModel(va12_mix1, which = "3")


###################################################
### chunk number 25: plotVroot
###################################################
#line 1045 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
trellis.par.set(theme = standard.theme(color = FALSE))
print(histogram(va12_mix3))


###################################################
### chunk number 26: plotVMeanVar
###################################################
#line 1065 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
trellis.par.set(theme = standard.theme(color = FALSE))
print(xyplot(va12_mix3))


###################################################
### chunk number 27: concomitantsV
###################################################
#line 1110 "d:/Rcompile/CRANpkg/local/2.12/psychomix/inst/doc/raschmix.Rnw"
parameters(getModel(va12_mix2, which = "3"), which = "concomitant")


