###################################################
### chunk number 1: 
###################################################
#line 10 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
options(continue=" ")
options(SweaveHooks=list(fig=function()
par(mar=c(4.1, 4.1, 2.6, 1.6), cex=0.7, cex.main=1)))


###################################################
### chunk number 2: 
###################################################
#line 49 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
library (rrv)


###################################################
### chunk number 3: 
###################################################
#line 54 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
data = read_package_data ("rrv", "markowitz.csv", FALSE)
sample_deterministic (data)


###################################################
### chunk number 4: 
###################################################
#line 60 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
summary.table = data.frame (expected.values=apply (data [,-1], 2, mean),
	variances=apply (data [,-1], 2, var) )
summary.table = summary.table [order (summary.table [,1], decreasing=TRUE),]
round (summary.table, 3)


###################################################
### chunk number 5: 
###################################################
#line 69 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
plot (summary.table$variances, summary.table$expected.values) 


###################################################
### chunk number 6: 
###################################################
#line 75 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
correlation.matrix = cor (data [,-1])
round (correlation.matrix, 1)


###################################################
### chunk number 7: 
###################################################
#line 82 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
time = data [,1]
plot (time, data [,2], type="l", ylab="return")
lines (time, data [,3], lty=2)


###################################################
### chunk number 8: 
###################################################
#line 91 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
x = rrv (data [,2:3])
plot (x)


###################################################
### chunk number 9: 
###################################################
#line 119 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
#construct the object (also a function)
f = cpr_rrv (x)
f


###################################################
### chunk number 10: 
###################################################
#line 130 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
#construct the object (also a function)
f_expected = cpr_expected (x)
f_expected


###################################################
### chunk number 11: 
###################################################
#line 138 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
#plot of expected return as function of weight
plot (f_expected)


###################################################
### chunk number 12: 
###################################################
#line 144 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
#evaluate it, for an equally weighted portfolio
f_expected (c (0.5, 0.5) )


###################################################
### chunk number 13: 
###################################################
#line 150 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
f_variance = cpr_variance (x)
f_q0.25 = cpr_quantile (0.25, x)


###################################################
### chunk number 14: 
###################################################
#line 156 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
plot (f_variance)


###################################################
### chunk number 15: 
###################################################
#line 159 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
plot (f_q0.25)


###################################################
### chunk number 16: 
###################################################
#line 188 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
#2-source, first two variables
.textbookplot (data [,2:3])


###################################################
### chunk number 17: 
###################################################
#line 193 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
#3-source, incorrect, giving 2-source subsets
.textbookplot (data [,2:4])
#superimpose equally-weighted portfolio
m = as.matrix (data [,2:4])
w = c (1, 1, 1) / 3
x = cpr_sd (m)(w)
y = cpr_expected (m)(w)
points (x, y, cex=1.5) 


###################################################
### chunk number 18: 
###################################################
#line 220 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
r = rrv (data [,2])
plot (r)


###################################################
### chunk number 19: 
###################################################
#line 232 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
y = rprv (as.matrix (data [,2:4]), c (1, 1, 1) / 3)


###################################################
### chunk number 20: 
###################################################
#line 238 "d:/Rcompile/CRANpkg/local/2.12/rrv/inst/doc/rrv.rnw"
plot (y)


