###################################################
### chunk number 1: preliminaries
###################################################
#line 61 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
library("zoo")
library("sandwich")
library("strucchange")
library("lmtest")
options(prompt = "R> ", continue = "+   ")


###################################################
### chunk number 2: hac-kweights
###################################################
#line 384 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
curve(kweights(x, kernel = "Quadratic", normalize = TRUE),
      from = 0, to = 3.2, xlab = "x", ylab = "K(x)")
curve(kweights(x, kernel = "Bartlett", normalize = TRUE),
      from = 0, to = 3.2, col = 2, add = TRUE)
curve(kweights(x, kernel = "Parzen", normalize = TRUE),
      from = 0, to = 3.2, col = 3, add = TRUE)
curve(kweights(x, kernel = "Tukey", normalize = TRUE),
      from = 0, to = 3.2, col = 4, add = TRUE)
lines(c(0, 0.5), c(1, 1), col = 6)
lines(c(0.5, 0.5), c(1, 0), lty = 3, col = 6)
lines(c(0.5, 3.2), c(0, 0), col = 6)
curve(kweights(x, kernel = "Quadratic", normalize = TRUE),
      from = 0, to = 3.2, col = 1, add = TRUE)

text(0.5, 0.98, "Truncated", pos = 4)
text(0.8, kweights(0.8, "Bartlett", normalize = TRUE), "Bartlett", pos = 4)
text(1.35, kweights(1.4, "Quadratic", normalize = TRUE), "Quadratic Spectral", pos = 2)
text(1.15, 0.29, "Parzen", pos = 4)
arrows(1.17, 0.29, 1, kweights(1, "Parzen", normalize = TRUE), length = 0.1)
text(1.3, 0.2, "Tukey-Hanning", pos = 4)
arrows(1.32, 0.2, 1.1, kweights(1.1, "Tukey", normalize = TRUE), length = 0.1)


###################################################
### chunk number 3: loadlibs1
###################################################
#line 528 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
library("sandwich")
library("lmtest")


###################################################
### chunk number 4: hc-data
###################################################
#line 543 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
data("PublicSchools")
ps <- na.omit(PublicSchools)
ps$Income <- ps$Income * 0.0001


###################################################
### chunk number 5: hc-model
###################################################
#line 554 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
fm.ps <- lm(Expenditure ~ Income + I(Income^2), data = ps)


###################################################
### chunk number 6: hc-test1
###################################################
#line 565 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
coeftest(fm.ps, df = Inf, vcov = vcovHC(fm.ps, type = "HC0"))


###################################################
### chunk number 7: hc-test2
###################################################
#line 574 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
coeftest(fm.ps, df = Inf, vcov = vcovHC(fm.ps, type = "HC4"))


###################################################
### chunk number 8: hc-plot
###################################################
#line 586 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
plot(Expenditure ~ Income, data = ps,
  xlab = "per capita income",
  ylab = "per capita spending on public schools")
inc <- seq(0.5, 1.2, by = 0.001)
lines(inc, predict(fm.ps, data.frame(Income = inc)), col = 4, lty = 2)
fm.ps2 <- lm(Expenditure ~ Income, data = ps)
abline(fm.ps2, col = 4)
text(ps[2,2], ps[2,1], rownames(ps)[2], pos = 2)


###################################################
### chunk number 9: hac-data
###################################################
#line 611 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
data("Investment")


###################################################
### chunk number 10: hac-model
###################################################
#line 615 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
fm.inv <- lm(RealInv ~ RealGNP + RealInt, data = Investment)


###################################################
### chunk number 11: hac-test1
###################################################
#line 623 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
coeftest(fm.inv, df = Inf, vcov = NeweyWest(fm.inv, lag = 4, prewhite = FALSE))


###################################################
### chunk number 12: hac-test2
###################################################
#line 628 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
coeftest(fm.inv, df = Inf, vcov = NeweyWest)


###################################################
### chunk number 13: hac-test3
###################################################
#line 638 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
parzenHAC <- function(x, ...) kernHAC(x, kernel = "Parzen", prewhite = 2,
  adjust = FALSE, bw = bwNeweyWest, ...)
coeftest(fm.inv, df = Inf, vcov = parzenHAC)


###################################################
### chunk number 14: hac-plot
###################################################
#line 651 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
library("scatterplot3d")
s3d <- scatterplot3d(Investment[,c(5,7,6)],
  type = "b", angle = 65, scale.y = 1, pch = 16)
s3d$plane3d(fm.inv, lty.box = "solid", col = 4)


###################################################
### chunk number 15: loadlibs2
###################################################
#line 696 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
library("strucchange")
data("RealInt")


###################################################
### chunk number 16: sc-ocus
###################################################
#line 701 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
ocus <- gefp(RealInt ~ 1, fit = lm, vcov = kernHAC)


###################################################
### chunk number 17: sc-bp
###################################################
#line 719 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
bp <- breakpoints(RealInt ~ 1)
confint(bp, vcov = kernHAC)


###################################################
### chunk number 18: sc-plot
###################################################
#line 740 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
par(mfrow = c(1, 2))
plot(ocus, aggregate = FALSE, main = "")
plot(RealInt, ylab = "Real interest rate")
lines(ts(fitted(bp), start = start(RealInt), freq = 4), col = 4)
lines(confint(bp, vcov = kernHAC))


###################################################
### chunk number 19: 
###################################################
#line 786 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
options(prompt = "  ")


###################################################
### chunk number 20:  eval=FALSE
###################################################
## #line 805 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 528 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#805#"
## library("sandwich")
## library("lmtest")
## #line 806 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## library("strucchange")


###################################################
### chunk number 21:  eval=FALSE
###################################################
## #line 814 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 543 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#814#"
## data("PublicSchools")
## ps <- na.omit(PublicSchools)
## ps$Income <- ps$Income * 0.0001
## #line 815 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"


###################################################
### chunk number 22:  eval=FALSE
###################################################
## #line 819 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 554 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#819#"
## fm.ps <- lm(Expenditure ~ Income + I(Income^2), data = ps)
## #line 820 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"


###################################################
### chunk number 23:  eval=FALSE
###################################################
## #line 824 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## sqrt(diag(vcov(fm.ps)))
## sqrt(diag(vcovHC(fm.ps, type = "const")))
## sqrt(diag(vcovHC(fm.ps, type = "HC0")))
## sqrt(diag(vcovHC(fm.ps, type = "HC3")))
## sqrt(diag(vcovHC(fm.ps, type = "HC4")))


###################################################
### chunk number 24:  eval=FALSE
###################################################
## #line 833 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 565 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#833#"
## coeftest(fm.ps, df = Inf, vcov = vcovHC(fm.ps, type = "HC0"))
## #line 834 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 574 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#834#"
## coeftest(fm.ps, df = Inf, vcov = vcovHC(fm.ps, type = "HC4"))
## #line 835 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"


###################################################
### chunk number 25:  eval=FALSE
###################################################
## #line 855 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 611 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#855#"
## data("Investment")
## #line 856 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"


###################################################
### chunk number 26:  eval=FALSE
###################################################
## #line 860 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 615 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#860#"
## fm.inv <- lm(RealInv ~ RealGNP + RealInt, data = Investment)
## #line 861 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"


###################################################
### chunk number 27:  eval=FALSE
###################################################
## #line 879 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## plot(Investment[, "RealInv"], type = "b", pch = 19, ylab = "Real investment")
## lines(ts(fitted(fm.inv), start = 1964), col = 4)


###################################################
### chunk number 28:  eval=FALSE
###################################################
## #line 897 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## data("RealInt")


###################################################
### chunk number 29:  eval=FALSE
###################################################
## #line 902 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 701 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#902#"
## ocus <- gefp(RealInt ~ 1, fit = lm, vcov = kernHAC)
## #line 903 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## plot(ocus, aggregate = FALSE)
## sctest(ocus)


###################################################
### chunk number 30:  eval=FALSE
###################################################
## #line 909 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## fs <- Fstats(RealInt ~ 1, vcov = kernHAC)
## plot(fs)
## sctest(fs)


###################################################
### chunk number 31:  eval=FALSE
###################################################
## #line 917 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## #line 719 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw#from line#917#"
## bp <- breakpoints(RealInt ~ 1)
## confint(bp, vcov = kernHAC)
## #line 918 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## plot(bp)


###################################################
### chunk number 32:  eval=FALSE
###################################################
## #line 923 "d:/Rcompile/CRANpkg/local/2.12/sandwich/inst/doc/sandwich.Rnw"
## plot(RealInt, ylab = "Real interest rate")
## lines(ts(fitted(bp), start = start(RealInt), freq = 4), col = 4)
## lines(confint(bp, vcov = kernHAC))


