###################################################
### chunk number 1: preliminaries
###################################################
#line 26 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Load the spsurvey package
library(spsurvey)



###################################################
### chunk number 2: att
###################################################
#line 43 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Read the attribute table from the shapefile
att <- read.dbf("eco_l3_ut")



###################################################
### chunk number 3: att
###################################################
#line 50 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Display the initial six lines in the attribute data frame
head(att)



###################################################
### chunk number 4: att
###################################################
#line 57 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Summarize frame area by ecoregion
temp <- tapply(att$area_ha, att$level3_nam, sum)
temp <- round(addmargins(temp), 0)
temp



###################################################
### chunk number 5: figure
###################################################
#line 69 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Read the shapefile
shp <- read.shape("eco_l3_ut")
# Plot ecoregions in Utah
print(spplot(shp, zcol="level3_nam", col.regions=rainbow(7, s=0.75)))



###################################################
### chunk number 6: Equalsites
###################################################
#line 92 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Call the set.seed function so that the survey designs can be replicate
set.seed(4447864)



###################################################
### chunk number 7: Equalsites
###################################################
#line 99 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Create the design list
Equaldsgn <- list(None=list(panel=c(PanelOne=115), seltype="Equal"))



###################################################
### chunk number 8: Equalsites
###################################################
#line 115 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Select the sample
Equalsites <- grts(design=Equaldsgn,
                   DesignID="EQUAL",
                   type.frame="area",
                   src.frame="shapefile",
                   in.shape="eco_l3_ut", 
                   att.frame=att,
                   shapefile=FALSE)



###################################################
### chunk number 9: Equalsites
###################################################
#line 128 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Print the initial six lines of the survey design
head(Equalsites@data)



###################################################
### chunk number 10: Equalsites
###################################################
#line 135 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Print the survey design summary
dsgnsum(Equalsites)



###################################################
### chunk number 11: Unequalsites
###################################################
#line 159 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Create the design list
Unequaldsgn <- list(None=list(panel=c(PanelOne=115),
                              seltype="Unequal",
                              caty.n=c("Central Basin and Range"=25,
                                       "Colorado Plateaus"=25,
                                       "Mojave Basin and Range"=10,
                                       "Northern Basin and Range"=10,
                                       "Southern Rockies"=10,
                                       "Wasatch and Uinta Mountains"=25,
                                       "Wyoming Basin"=10)))



###################################################
### chunk number 12: Unequalsites
###################################################
#line 184 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Select the sample
Unequalsites <- grts(design=Unequaldsgn,
                     DesignID="UNEQUAL",
                     type.frame="area",
                     src.frame="shapefile",
                     in.shape="eco_l3_ut", 
                     att.frame=att,
                     mdcaty="level3_nam",									
                     shapefile=FALSE)



###################################################
### chunk number 13: Unequalsites
###################################################
#line 198 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Print the initial six lines of the survey design
head(Unequalsites@data)



###################################################
### chunk number 14: Unequalsites
###################################################
#line 205 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Print the survey design summary
dsgnsum(Unequalsites)



###################################################
### chunk number 15: Stratsites
###################################################
#line 234 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Create the design list
Stratdsgn <- list("Central Basin and Range"=list(panel=c(PanelOne=25),
                                                 seltype="Equal"),
                  "Colorado Plateaus"=list(panel=c(PanelOne=25),
                                           seltype="Equal"),
                  "Mojave Basin and Range"=list(panel=c(PanelOne=10),
                                                seltype="Equal"),
                  "Northern Basin and Range"=list(panel=c(PanelOne=10),
                                                  seltype="Equal"),
                  "Southern Rockies"=list(panel=c(PanelOne=10),
                                          seltype="Equal"),
                  "Wasatch and Uinta Mountains"=list(panel=c(PanelOne=25),
                                                     seltype="Equal"),
                  "Wyoming Basin"=list(panel=c(PanelOne=10),
                                       seltype="Equal"))



###################################################
### chunk number 16: Stratsites
###################################################
#line 264 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Select the sample
Stratsites <- grts(design=Stratdsgn,
                   DesignID="STRATIFIED",
                   type.frame="area",
                   src.frame="sp.object",
                   sp.object=shp,
                   att.frame=att,
                   stratum="level3_nam",									
                   shapefile=FALSE)



###################################################
### chunk number 17: Stratsites
###################################################
#line 278 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Print the initial six lines of the survey design
head(Stratsites@data)



###################################################
### chunk number 18: Stratsites
###################################################
#line 285 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Print the survey design summary
dsgnsum(Stratsites)



###################################################
### chunk number 19: Panelsites
###################################################
#line 311 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Create the design list
Paneldsgn <- list(None=list(panel=c(Panel_1=50, Panel_2=50, Panel_3=50,
                                    Panel_4=50, Panel_5=50),
                            seltype="Unequal",
                            caty.n=c("Central Basin and Range"=64,
                                     "Colorado Plateaus"=63,
                                     "Mojave Basin and Range"=15,
                                     "Northern Basin and Range"=15,
                                     "Southern Rockies"=15,
                                     "Wasatch and Uinta Mountains"=63,
                                     "Wyoming Basin"=15),
                            over=100))



###################################################
### chunk number 20: Panelsites
###################################################
#line 338 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Select the sample
Panelsites <- grts(design=Paneldsgn,
                   DesignID="UNEQUAL",
                   type.frame="area",
                   src.frame="shapefile",
                   in.shape="eco_l3_ut", 
                   att.frame=att,
                   mdcaty="level3_nam",									
                   shapefile=FALSE)



###################################################
### chunk number 21: Panelsites eval=FALSE
###################################################
## #line 352 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
## # Print the warning message
## warnings()
## 


###################################################
### chunk number 22: Panelsites
###################################################
#line 367 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Print the initial six lines of the survey design
head(Panelsites@data)



###################################################
### chunk number 23: Panelsites
###################################################
#line 374 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Area_Design.Rnw"
# Print the survey design summary
dsgnsum(Panelsites)



