###################################################
### chunk number 1: preliminaries
###################################################
#line 26 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Load the spsurvey package
library(spsurvey)



###################################################
### chunk number 2: data
###################################################
#line 42 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Read the data file and determine the number of rows in the file
FL_lakes <- read.delim("FL_lakes.tab")
nr <- nrow(FL_lakes)



###################################################
### chunk number 3: data
###################################################
#line 50 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Display the initial six lines in the data file
head(FL_lakes)



###################################################
### chunk number 4: data
###################################################
#line 57 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Display the final six lines in the data file
tail(FL_lakes)



###################################################
### chunk number 5: figure
###################################################
#line 80 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Plot small lakes in Florida
basins <- levels(FL_lakes$basin)
cols <- rainbow(6)
plot(FL_lakes$xcoord, FL_lakes$ycoord, type="n", xlab="x-coordinate",
     ylab="y-coordinate")
for(i in 1:6) {
   ind <- FL_lakes$basin == basins[i]
   points(FL_lakes$xcoord[ind], FL_lakes$ycoord[ind], pch=20, cex=0.4,
          col=cols[i])
   }
legend(x="topright", inset=0.05, legend=basins, pch=20, cex=1, col=cols)
title("Plot of Florida Small Lake Sites Color-Coded by Basin")



###################################################
### chunk number 6: Statuseval
###################################################
#line 107 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Use the table and addmargins functions to create a table displaying the count
# for each code of the status variable
cat("\nA table displaying the number of values for each level of the status
variable follows:\n")
addmargins(table(FL_lakes$status))



###################################################
### chunk number 7: Statuseval
###################################################
#line 119 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Use the table and addmargins functions to create a table displaying the count
# for each code of the TNT variable
cat("\nA table displaying the number of values for each level of the TNT
variable follows:\n")
addmargins(table(FL_lakes$TNT))



###################################################
### chunk number 8: Statuseval
###################################################
#line 135 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
#
# Conduct an analysis of site status evaluation variables
#

# Create the sites data frame, which identifies sites to use in the analysis
# Note that all sites will be used to estimate number of lakes in each category
sites <- data.frame(siteID=FL_lakes$siteID,
                    Use=rep(TRUE, nr))



###################################################
### chunk number 9: Statuseval
###################################################
#line 153 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Create the subpop data frame, which defines populations and subpopulations for
# which estimates are desired
subpop <- data.frame(siteID=FL_lakes$siteID,
                     CombinedBasins=rep("All Basins", nr), 
							       Basin=FL_lakes$basin)



###################################################
### chunk number 10: Statuseval
###################################################
#line 169 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Create the design data frame, which identifies the stratum code, weight,
#    x-coordinate, and y-coordinate for each site ID
design <- data.frame(siteID=FL_lakes$siteID,
                     wgt=FL_lakes$wgt,
                     xcoord=FL_lakes$xcoord,
                     ycoord=FL_lakes$ycoord)



###################################################
### chunk number 11: Statuseval
###################################################
#line 185 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Create the data.cat data frame, which specifies the variables to use in the
# analysis
data.cat <- data.frame(siteID=FL_lakes$siteID,
                       Status=FL_lakes$status,
                       Target_NonTarget=FL_lakes$TNT)



###################################################
### chunk number 12: Statuseval
###################################################
#line 195 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Calculate extent estimates for the site status evaluation variables
Extent_Estimates <- cat.analysis(sites, subpop, design, data.cat)



###################################################
### chunk number 13: Statuseval
###################################################
#line 202 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Print the extent estimates for all basins combined
print(Extent_Estimates[c(1:7, 45:47),])



###################################################
### chunk number 14: Statuseval
###################################################
#line 213 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Write results as a comma-separated value (csv) file
write.table(Extent_Estimates, file="Extent_Estimates.csv", sep=",",
            row.names=FALSE)



###################################################
### chunk number 15: Conditioneval
###################################################
#line 227 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Use the table and addmargins functions to create a table displaying the count
# for each code of the pH category variable
cat("\nA table displaying the number of values for each level of the pH category
variable follows:\n")
addmargins(table(FL_lakes$pH_cat))



###################################################
### chunk number 16: Conditioneval
###################################################
#line 239 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Use the table and addmargins functions to create a table displaying the count
# for each code of the fecal coliform category variable
cat("\nA table displaying the number of values for each level of the fecal
coliform category variable follows:\n")
addmargins(table(FL_lakes$coliform_cat))



###################################################
### chunk number 17: Conditioneval
###################################################
#line 256 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
#
# Conduct an analysis of lake condition variables
#

# Create the sites data frame
# Note that only sampled sites are used
sites <- data.frame(siteID=FL_lakes$siteID,
                    Use=FL_lakes$status == "Sampled")

# Note that the existing subpop and design data frames can be reused



###################################################
### chunk number 18: Conditioneval
###################################################
#line 276 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Create the data.cat data frame, which specifies the variables to use in the
# analysis
data.cat <- data.frame(siteID=FL_lakes$siteID,
                       pHCat=FL_lakes$pH_cat,
                       ColiformCat=FL_lakes$coliform_cat)



###################################################
### chunk number 19: Conditioneval
###################################################
#line 286 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Calculate estimates for the categorical variables
Condition_Estimates <- cat.analysis(sites, subpop, design, data.cat)



###################################################
### chunk number 20: Conditioneval
###################################################
#line 293 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Print the condition estimates for all basins combined
print(Condition_Estimates[c(1:4, 28:32),])



###################################################
### chunk number 21: Conditioneval
###################################################
#line 304 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Write results as a csv file
write.table(Condition_Estimates, file="Condition_Estimates.csv", sep=",", 
            row.names=FALSE)



###################################################
### chunk number 22: Conditionevalpop
###################################################
#line 320 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
#
# Conduct an analysis of lake condition variables correcting for population size
#

# Note that the existing sites, subpop, design, and data.cont data frames can be
# reused

# Assign frame size values
framesize <- c("NWFWMD-1"=451, "NWFWMD-2"=394, "SFWMD-9"=834, "SJRWMD-1"=1216,
               "SRWMD-1"=1400, "SWFWMD-4"=851)



###################################################
### chunk number 23: Conditionevalpop
###################################################
#line 340 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Calculate estimates for the lake condition variables
Condition_Estimates_popsize <- cat.analysis(sites, subpop, design, data.cat,
   popsize=list(CombinedBasins=sum(framesize),
                Basin=as.list(framesize)))



###################################################
### chunk number 24: Conditionevalpop
###################################################
#line 349 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Print the lake condition estimates for all basins combined
print(Condition_Estimates_popsize[c(1:4, 28:32),])



###################################################
### chunk number 25: Conditionevalpop
###################################################
#line 360 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Write results as a csv file
write.table(Condition_Estimates_popsize, file="Condition_Estimates_popsize.csv",
            sep=",", row.names=FALSE)



###################################################
### chunk number 26: Quanteval
###################################################
#line 374 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Use the summary function to summarize the data structure of the dissolved
# oxygen variable
cat("\nSummarize the data structure of the dissolved oxygen variable:\n")
summary(FL_lakes$oxygen)



###################################################
### chunk number 27: Quanteval
###################################################
#line 385 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Use the summary function to summarize the data structure of the turbidity
# variable
cat("\nSummarize the data structure of the turbidity variable:\n")
summary(FL_lakes$turbidity)



###################################################
### chunk number 28: Quanteval
###################################################
#line 401 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
#
# Conduct an analysis of lake condition variables
#

# Note that the existing sites, subpop, and design data frames can be reused

# Create the data.cat data frame, which specifies the variables to use in the
# analysis
data.cont <- data.frame(siteID=FL_lakes$siteID,
                        DissolvedOxygen=FL_lakes$oxygen,
                        Turbidity=FL_lakes$turbidity)



###################################################
### chunk number 29: Quanteval
###################################################
#line 423 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Calculate CDF estimates for the quantitative variables
CDF_Estimates <- cont.analysis(sites, subpop, design, data.cont,
   popsize=list(CombinedBasins=sum(framesize),
                Basin=as.list(framesize)))



###################################################
### chunk number 30: Quanteval
###################################################
#line 439 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Write CDF estimates as a csv file
write.table(CDF_Estimates$CDF, file="CDF_Estimates.csv", sep=",",
            row.names=FALSE)



###################################################
### chunk number 31: Quanteval
###################################################
#line 449 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
cont.cdfplot("CDF_Estimates.pdf", CDF_Estimates$CDF, logx=c("","x"))



###################################################
### chunk number 32: Quanteval
###################################################
#line 455 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Print the percentile estimates for dissolved oxygen for all basins combined
print(CDF_Estimates$Pct[1:10,])



###################################################
### chunk number 33: Quanteval
###################################################
#line 467 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Write percentile estimates as a csv file
write.table(CDF_Estimates$Pct, file="Percentile_Estimates.csv", sep=",",
            row.names=FALSE)



###################################################
### chunk number 34: Quanteval
###################################################
#line 480 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Test for statistical difference between CDFs for basins
CDF_Tests <- cont.cdftest(sites, subpop[,c(1,3)], design, data.cont,
   popsize=list(Basin=as.list(framesize)))



###################################################
### chunk number 35: Quanteval
###################################################
#line 488 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Print results of the statistical tests for difference between CDFs from
# basins for dissolved oxygen
print(CDF_Tests[1:15,])



###################################################
### chunk number 36: Quanteval
###################################################
#line 496 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Analysis.Rnw"
# Write CDF test results as a csv file
write.table(CDF_Tests, file="CDF_Tests.csv", sep=",", row.names=FALSE)



