###################################################
### chunk number 1: preliminaries
###################################################
#line 26 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Load the spsurvey package
library(spsurvey)



###################################################
### chunk number 2: att
###################################################
#line 43 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Read the attribute table from the shapefile
att <- read.dbf("reg1_lakes")



###################################################
### chunk number 3: att
###################################################
#line 50 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Display the initial six lines in the attribute data frame
head(att)



###################################################
### chunk number 4: att
###################################################
#line 57 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Display number of lakes cross-classified by the  strata and multidensity
# category variables
addmargins(table("State"=att$state, "Lake Area Category"=att$area_cat))



###################################################
### chunk number 5: figure
###################################################
#line 72 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Plot lakes in the New England region
plot(att$xcoord, att$ycoord, xlab="x-coordinate", ylab="y-coordinate", pch=20,
     cex=0.1, col="red")



###################################################
### chunk number 6: Equalsites
###################################################
#line 94 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Call the set.seed function so that the survey designs can be replicate
set.seed(4447864)



###################################################
### chunk number 7: Equalsites
###################################################
#line 101 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Create the design list
Equaldsgn <- list(None=list(panel=c(PanelOne=300), seltype="Equal"))



###################################################
### chunk number 8: Equalsites
###################################################
#line 117 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Select the sample
Equalsites <- grts(design=Equaldsgn,
                   DesignID="EQUAL",
                   type.frame="finite",
                   src.frame="shapefile",
                   in.shape="reg1_lakes", 
                   att.frame=att,
                   shapefile=FALSE)



###################################################
### chunk number 9: Equalsites
###################################################
#line 130 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Print the initial six lines of the survey design
head(Equalsites@data)



###################################################
### chunk number 10: Equalsites
###################################################
#line 137 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Print the survey design summary
dsgnsum(Equalsites)



###################################################
### chunk number 11: Stratsites
###################################################
#line 158 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Create the design list
Stratdsgn <- list(CT=list(panel=c(PanelOne=50), seltype="Equal"),
                  MA=list(panel=c(PanelOne=50), seltype="Equal"),
                  ME=list(panel=c(PanelOne=50), seltype="Equal"),
                  NH=list(panel=c(PanelOne=50), seltype="Equal"),
                  RI=list(panel=c(PanelOne=50), seltype="Equal"),
                  VT=list(panel=c(PanelOne=50), seltype="Equal"))



###################################################
### chunk number 12: Stratsites
###################################################
#line 181 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Select the sample
Stratsites <- grts(design=Stratdsgn,
                   DesignID="STRATIFIED",
                   type.frame="finite",
                   src.frame="att.frame",
                   att.frame=att,
                   xcoord="xcoord",
                   ycoord="ycoord",
                   stratum="state",
                   shapefile=FALSE)



###################################################
### chunk number 13: Stratsites
###################################################
#line 196 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Print the initial six lines of the survey design
head(Stratsites@data)



###################################################
### chunk number 14: Stratsites
###################################################
#line 203 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Print the survey design summary
dsgnsum(Stratsites)



###################################################
### chunk number 15: Unequalsites
###################################################
#line 224 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Create the design list
Unequaldsgn <- list(None=list(panel=c(PanelOne=300),
                              seltype="Unequal",
                              caty.n=c("[0,1]"=50, "(1,5]"=50, "(5,10]"=50,
                                       "(10,50]"=50, "(50,500]"=50,
                                       "(500,7e+04]"=50),
                              over=120))



###################################################
### chunk number 16: Unequalsites
###################################################
#line 236 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Read the shapefile
shp <- read.shape("reg1_lakes")



###################################################
### chunk number 17: Unequalsites
###################################################
#line 253 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Select the sample
Unequalsites <- grts(design=Unequaldsgn,
                     DesignID="UNEQUAL",
                     type.frame="finite",
                     src.frame="sp.object",
                     sp.object=shp,
                     att.frame=att,
                     mdcaty="area_cat",
                     shapefile=FALSE)



###################################################
### chunk number 18: Unequalsites
###################################################
#line 267 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Print the initial six lines of the survey design
head(Unequalsites@data)



###################################################
### chunk number 19: Unequalsites
###################################################
#line 274 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Print the survey design summary
dsgnsum(Unequalsites)



###################################################
### chunk number 20: Panelsites
###################################################
#line 296 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Create the design list
Paneldsgn <- list(None=list(panel=c(Annual=50, Year1=50, Year2=50, Year3=50,
                                    Year4=50, Year5=50),
                            seltype="Unequal",
                            caty.n=c("[0,1]"=50, "(1,5]"=50, "(5,10]"=50,
                                     "(10,50]"=50, "(50,500]"=50,
                                     "(500,7e+04]"=50),
                            over=100))



###################################################
### chunk number 21: Panelsites
###################################################
#line 319 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Select the sample
Panelsites <- grts(design=Paneldsgn,
                   DesignID="UNEQUAL",
                   type.frame="finite",
                   src.frame="shapefile",
                   in.shape="reg1_lakes",
                   att.frame=att,
                   mdcaty="area_cat",
                   shapefile=FALSE)



###################################################
### chunk number 22: Panelsites eval=FALSE
###################################################
## #line 333 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
## # Print the warning message
## warnings()
## 


###################################################
### chunk number 23: Panelsites
###################################################
#line 348 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Print the initial six lines of the survey design
head(Panelsites@data)



###################################################
### chunk number 24: Panelsites
###################################################
#line 355 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Finite_Design.Rnw"
# Print the survey design summary
dsgnsum(Panelsites)



