###################################################
### chunk number 1: preliminaries
###################################################
#line 26 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Load the spsurvey package
library(spsurvey)



###################################################
### chunk number 2: att
###################################################
#line 45 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Read the attribute table from the shapefile
att <- read.dbf("luck_ash")



###################################################
### chunk number 3: att
###################################################
#line 52 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Display the initial six lines in the attribute data frame
head(att)



###################################################
### chunk number 4: att
###################################################
#line 59 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Display number of stream segments cross-classified by the  strata and
# multidensity category variables

addmargins(table("Stream Type"=att$perint, "Strahler Order"=att$strahcat))



###################################################
### chunk number 5: att
###################################################
#line 68 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Summarize frame stream length by stratum and multidensity category
temp <- tapply(att$length_km, list(att$perint, att$strahcat), sum)
temp <- round(addmargins(temp), 2)
names(dimnames(temp)) <- list("Stream Type", "Strahler Order")
temp



###################################################
### chunk number 6: figure1
###################################################
#line 96 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Read the shapefile
shp <- read.shape("luck_ash")
# Plot streams in the Luckiamute watershed classified by stream type
print(spplot(shp, zcol="perint", col.regions=c("red", "blue")))



###################################################
### chunk number 7: figure2
###################################################
#line 110 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Plot streams in the Luckiamute watershed classified by Strahler stream order
# category
print(spplot(shp, zcol="strahcat", col.regions=c("red", "green", "blue")))



###################################################
### chunk number 8: Equalsites
###################################################
#line 132 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Call the set.seed function so that the survey designs can be replicate
set.seed(19742003)



###################################################
### chunk number 9: Equalsites
###################################################
#line 139 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Create the design list
Equaldsgn <- list(None=list(panel=c(PanelOne=50), seltype="Equal"))



###################################################
### chunk number 10: Equalsites
###################################################
#line 155 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Select the sample
Equalsites <- grts(design=Equaldsgn,
                   DesignID="EQUAL",
                   type.frame="linear",
                   src.frame="shapefile",
                   in.shape="luck_ash",
                   att.frame=att,
                   shapefile=FALSE)



###################################################
### chunk number 11: Equalsites
###################################################
#line 168 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Print the initial six lines of the survey design
head(Equalsites@data)



###################################################
### chunk number 12: Equalsites
###################################################
#line 175 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Print the survey design summary
dsgnsum(Equalsites)



###################################################
### chunk number 13: Stratsites
###################################################
#line 196 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Create the design list
Stratdsgn <- list(Perennial=list(panel=c(PanelOne=50),
                                 seltype="Equal",
                                 over=50),
                  Intermittent=list(panel=c(PanelOne=50),
                                    seltype="Equal",
                                    over=50))



###################################################
### chunk number 14: Stratsites
###################################################
#line 218 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Select the sample
Stratsites <- grts(design=Stratdsgn,
                   DesignID="STRATIFIED",
                   type.frame="linear",
                   src.frame="shapefile",
                   in.shape="luck_ash",
                   att.frame=att,
                   stratum="perint",
                   shapefile=FALSE)



###################################################
### chunk number 15: Stratsites
###################################################
#line 232 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Print the initial six lines of the survey design
head(Stratsites@data)



###################################################
### chunk number 16: Stratsites
###################################################
#line 239 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Print the survey design summary
dsgnsum(Stratsites)



###################################################
### chunk number 17: Unequalsites
###################################################
#line 262 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Create the design list
Unequaldsgn <- list(Perennial=list(panel=c(PanelOne=75),
                                   seltype="Unequal",
                                   caty.n=c("1st"=25, "2nd"=25, "3rd+"=25),
                                   over=36),
                    Intermittent=list(panel=c(PanelOne=32),
                                      seltype="Unequal",
                                      caty.n=c("1st"=25, "2nd"=5, "3rd+"=2),
                                      over=0))



###################################################
### chunk number 18: Unequalsites
###################################################
#line 287 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Select the sample
Unequalsites <- grts(design=Unequaldsgn,
                     DesignID="UNEQUAL",
                     type.frame="linear",
                     src.frame="sp.object",
                     sp.object=shp,
                     att.frame=att,
                     stratum="perint",
                     mdcaty="strahcat",
                     shapefile=FALSE)



###################################################
### chunk number 19: Unequalsites
###################################################
#line 302 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Print the initial six lines of the survey design
head(Unequalsites@data)



###################################################
### chunk number 20: Unequalsites
###################################################
#line 309 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Print the survey design summary
dsgnsum(Unequalsites)



###################################################
### chunk number 21: Panelsites
###################################################
#line 331 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Create the design list
Paneldsgn <- list(Perennial=list(panel=c(Year1=17, Year2=17, YearAll=16),
                                 seltype="Unequal",
                                 caty.n=c("1st"=15, "2nd"=15, "3rd+"=20),
                                 over=50),
                  Intermittent=list(panel=c(YearOnce=27),
                                    seltype="Unequal",
                                    caty.n=c("1st"=20, "2nd"=5, "3rd+"=2)))



###################################################
### chunk number 22: Panelsites
###################################################
#line 355 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Select the sample
Panelsites <- grts(design=Paneldsgn,
                   DesignID="UNEQUAL",
                   type.frame="linear",
                   src.frame="shapefile",
                   in.shape="luck_ash",
                   att.frame=att,
                   stratum="perint",
                   mdcaty="strahcat",
                   shapefile=FALSE)



###################################################
### chunk number 23: Panelsites eval=FALSE
###################################################
## #line 370 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
## # Print the warning message
## warnings()
## 


###################################################
### chunk number 24: Panelsites
###################################################
#line 385 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Print the initial six lines of the survey design
head(Panelsites@data)



###################################################
### chunk number 25: Panelsites
###################################################
#line 392 "d:/Rcompile/CRANpkg/local/2.12/spsurvey/inst/doc/Linear_Design.Rnw"
# Print the survey design summary
dsgnsum(Panelsites)



