### R code from vignette source 'amelia.Rnw'

###################################################
### code chunk number 1: amelia.Rnw:482-486
###################################################
options("digits"=4)
options("width"=70)
options("show.signif.stars" = FALSE)
set.seed(12345)


###################################################
### code chunk number 2: amelia.Rnw:491-493
###################################################
require(Amelia)
data(freetrade)


###################################################
### code chunk number 3: amelia.Rnw:499-500
###################################################
summary(freetrade)


###################################################
### code chunk number 4: amelia.Rnw:507-509
###################################################
summary(lm(tariff ~ polity + pop + gdp.pc + year + country, 
          data = freetrade)) 


###################################################
### code chunk number 5: amelia.Rnw:545-547
###################################################
a.out <- amelia(freetrade, m = 5, ts = "year", cs = "country")
a.out


###################################################
### code chunk number 6: hist1plot
###################################################
hist(a.out$imputations[[3]]$tariff, col="grey", border="white")


###################################################
### code chunk number 7: amelia.Rnw:569-570
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### code chunk number 8: hist1
###################################################
hist(a.out$imputations[[3]]$tariff, col="grey", border="white")


###################################################
### code chunk number 9: amelia.Rnw:630-632
###################################################
a.out.more <- amelia(freetrade, m = 10, ts = "year", cs = "country", p2s=0)
a.out.more


###################################################
### code chunk number 10: amelia.Rnw:636-638
###################################################
a.out.more <- ameliabind(a.out, a.out.more)
a.out.more


###################################################
### code chunk number 11: amelia.Rnw:690-691
###################################################
amelia(freetrade, m = 1, ts = "year", cs = "country", p2s = 2)


###################################################
### code chunk number 12: amelia.Rnw:749-750
###################################################
table(a.out$imputations[[3]]$polity)


###################################################
### code chunk number 13: amelia.Rnw:766-769
###################################################
a.out1 <- amelia(freetrade, m = 5, ts = "year", cs = "country", ords =
                 "polity", p2s = 0)
table(a.out1$imputations[[3]]$polity)


###################################################
### code chunk number 14: amelia.Rnw:786-787
###################################################
table(a.out1$imputations[[3]]$signed)


###################################################
### code chunk number 15: amelia.Rnw:804-807
###################################################
a.out2 <- amelia(freetrade, m = 5, ts = "year", cs = "country", noms =
                 "signed", p2s = 0)
table(a.out2$imputations[[3]]$signed)


###################################################
### code chunk number 16: logshist
###################################################
hist(freetrade$tariff, col="grey", border="white")
hist(log(freetrade$tariff), col="grey", border="white")


###################################################
### code chunk number 17: amelia.Rnw:841-842
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### code chunk number 18: hist2
###################################################
hist(freetrade$tariff, col="grey", border="white")
hist(log(freetrade$tariff), col="grey", border="white")


###################################################
### code chunk number 19: amelia.Rnw:856-857
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### code chunk number 20: amelia.Rnw:892-893
###################################################
amelia(freetrade, idvars = c("year", "country"))


###################################################
### code chunk number 21: amelia.Rnw:900-901
###################################################
a.out2 <- amelia(freetrade, idvars = c("year"))


###################################################
### code chunk number 22: amelia.Rnw:937-938
###################################################
a.out2 <- amelia(freetrade, ts = "year", cs = "country", polytime = 2)


###################################################
### code chunk number 23: amelia.Rnw:958-960
###################################################
a.out.time <- amelia(freetrade, ts = "year", cs = "country", polytime = 2,
                 intercs = TRUE, p2s = 2)


###################################################
### code chunk number 24: tcomp1
###################################################
tscsPlot(a.out, cs = "Malaysia", main = "Malaysia (no time settings)", 
         var = "tariff", ylim = c(-10, 60))

tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (with time settings)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### code chunk number 25: amelia.Rnw:980-981
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### code chunk number 26: timecompare
###################################################
tscsPlot(a.out, cs = "Malaysia", main = "Malaysia (no time settings)", 
         var = "tariff", ylim = c(-10, 60))

tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (with time settings)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### code chunk number 27: amelia.Rnw:1013-1015
###################################################
a.out2 <- amelia(freetrade, ts = "year", cs = "country", lags = "tariff",
                 leads = "tariff")


###################################################
### code chunk number 28: amelia.Rnw:1042-1043
###################################################
a.out.time


###################################################
### code chunk number 29: amelia.Rnw:1066-1069
###################################################
a.out.time2 <- amelia(freetrade, ts = "year", cs = "country", polytime = 2,
                 intercs = TRUE, p2s = 0, empri = .01*nrow(freetrade))
a.out.time2


###################################################
### code chunk number 30: tcomp2
###################################################
tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (no ridge prior)", 
         var = "tariff", ylim = c(-10, 60))

tscsPlot(a.out.time2, cs = "Malaysia", main = "Malaysia (with ridge prior)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### code chunk number 31: amelia.Rnw:1082-1083
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### code chunk number 32: timecomp2
###################################################
tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (no ridge prior)", 
         var = "tariff", ylim = c(-10, 60))

tscsPlot(a.out.time2, cs = "Malaysia", main = "Malaysia (with ridge prior)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### code chunk number 33: amelia.Rnw:1137-1138
###################################################
freetrade[freetrade$country == "Thailand", c("year","country","tariff")]


###################################################
### code chunk number 34: amelia.Rnw:1142-1143 (eval = FALSE)
###################################################
## #$


###################################################
### code chunk number 35: amelia.Rnw:1151-1153
###################################################
pr <- matrix(c(158,159,160,3,3,3,40,40,40,3,3,3), nrow=3, ncol=4) 
pr


###################################################
### code chunk number 36: amelia.Rnw:1160-1161
###################################################
a.out.pr <- amelia(freetrade, ts = "year", cs = "country", priors = pr)


###################################################
### code chunk number 37: amelia.Rnw:1170-1172
###################################################
pr.2 <- matrix(c(158,159,160,3,3,3,34,34,34,46,46,46,.95,.95,.95), nrow=3, ncol=5)
pr.2


###################################################
### code chunk number 38: amelia.Rnw:1183-1185
###################################################
pr.3 <- matrix(c(158,159,160,0,3,3,3,3,40,40,40,20,3,3,3,5), nrow=4, ncol=4)
pr.3


###################################################
### code chunk number 39: amelia.Rnw:1229-1231
###################################################
bds <- matrix(c(3, 30, 40), nrow = 1, ncol = 3)
bds


###################################################
### code chunk number 40: amelia.Rnw:1236-1238
###################################################
a.out.bds <- amelia(freetrade, ts = "year", cs = "country", bounds = bds,
                    max.resample = 1000)


###################################################
### code chunk number 41: bounds
###################################################
tscsPlot(a.out, cs = "Malaysia", main = "No logical bounds", var =
         "tariff", ylim = c(-10,60))

tscsPlot(a.out.bds, cs = "Malaysia", main = "Bounded between 30 and 40", var =
         "tariff", ylim = c(-10,60))


###################################################
### code chunk number 42: amelia.Rnw:1261-1262
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### code chunk number 43: boundscomp
###################################################
tscsPlot(a.out, cs = "Malaysia", main = "No logical bounds", var =
         "tariff", ylim = c(-10,60))

tscsPlot(a.out.bds, cs = "Malaysia", main = "Bounded between 30 and 40", var =
         "tariff", ylim = c(-10,60))


###################################################
### code chunk number 44: plotmeth
###################################################
plot(a.out, which.vars = 3:6)


###################################################
### code chunk number 45: plot1
###################################################
plot(a.out, which.vars = 3:6)


###################################################
### code chunk number 46: amelia.Rnw:1336-1337
###################################################
compare.density(a.out, var = "signed")


###################################################
### code chunk number 47: amelia.Rnw:1340-1341
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### code chunk number 48: overimp
###################################################
overimpute(a.out, var = "tariff")


###################################################
### code chunk number 49: amelia.Rnw:1374-1375
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### code chunk number 50: oi2
###################################################
overimpute(a.out, var = "tariff")


###################################################
### code chunk number 51: overimp-bad
###################################################
dd <- Amelia:::rmvnorm(50, mu = c(0.5,0.5), vcv =
                       matrix(c(0.25^2,.06, .06,0.25^2),2,2))
ddmiss <- sample(1:50, replace = FALSE, size = 10)
is.na(dd) <- ddmiss
aa.out <- amelia(dd, m= 5)
overimpute(aa.out, var = 2, main = "Observed versus Imputed Values")


###################################################
### code chunk number 52: oi
###################################################
dd <- Amelia:::rmvnorm(50, mu = c(0.5,0.5), vcv =
                       matrix(c(0.25^2,.06, .06,0.25^2),2,2))
ddmiss <- sample(1:50, replace = FALSE, size = 10)
is.na(dd) <- ddmiss
aa.out <- amelia(dd, m= 5)
overimpute(aa.out, var = 2, main = "Observed versus Imputed Values")


###################################################
### code chunk number 53: disp1d
###################################################
disperse(a.out, dims = 1, m = 5)
disperse(a.out, dims = 2, m = 5)


###################################################
### code chunk number 54: amelia.Rnw:1500-1501
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### code chunk number 55: disp1dfig
###################################################
disperse(a.out, dims = 1, m = 5)
disperse(a.out, dims = 2, m = 5)


###################################################
### code chunk number 56: amelia.Rnw:1536-1537
###################################################
set.seed(02138)


###################################################
### code chunk number 57: amelia.Rnw:1539-1541
###################################################
freetrade2 <- freetrade
freetrade2$tariff2 <- freetrade2$tariff*2+3


###################################################
### code chunk number 58: amelia.Rnw:1543-1546
###################################################
## We add a little bit of noise here to avoid numeric problems
freetrade2$tariff2 <- freetrade2$tariff*2+3 +
  rnorm(nrow(freetrade), 0, 0.000001)


###################################################
### code chunk number 59: amelia.Rnw:1552-1554
###################################################
a.out.bad <- amelia(freetrade2, ts = "year", cs = "country")
a.out.bad


###################################################
### code chunk number 60: dispbad
###################################################
disperse(a.out.bad, dims = 1, m = 10)


###################################################
### code chunk number 61: amelia.Rnw:1571-1572
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### code chunk number 62: dispbadfig
###################################################
disperse(a.out.bad, dims = 1, m = 10)


###################################################
### code chunk number 63: tsplot1
###################################################
tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (with time settings)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### code chunk number 64: tsplot2
###################################################
tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (with time settings)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### code chunk number 65: mmap1
###################################################
missmap(a.out) 


###################################################
### code chunk number 66: mmap2
###################################################
missmap(a.out) 


###################################################
### code chunk number 67: amelia.Rnw:1715-1717
###################################################
require(Zelig)
z.out <- zelig(tariff ~ polity + pop + gdp.pc + year +country, data = freetrade, model = "ls")


###################################################
### code chunk number 68: amelia.Rnw:1720-1721
###################################################
summary(z.out)


###################################################
### code chunk number 69: amelia.Rnw:1729-1731
###################################################
z.out.imp <- zelig(tariff ~ polity + pop + gdp.pc + year +country, data =
                   a.out$imputations, model = "ls")


###################################################
### code chunk number 70: amelia.Rnw:1734-1735
###################################################
summary(z.out.imp)


