### R code from vignette source 'anintro.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: anintro.Rnw:53-54
###################################################
options(width=90)


###################################################
### code chunk number 2: install_CHNOSZ (eval = FALSE)
###################################################
## install.packages("CHNOSZ")


###################################################
### code chunk number 3: library_CHNOSZ
###################################################
library(CHNOSZ)


###################################################
### code chunk number 4: thermo_opt_online
###################################################
thermo$opt$online <- TRUE


###################################################
### code chunk number 5: info_ethylene
###################################################
info("ethylene")


###################################################
### code chunk number 6: info_88
###################################################
info(88)


###################################################
### code chunk number 7: info_ethylene_gas
###################################################
info("ethylene","gas")


###################################################
### code chunk number 8: info_acetic
###################################################
aadata <- info(info("acetic acid"))
print(aadata)


###################################################
### code chunk number 9: summary_thermo
###################################################
summary(thermo)


###################################################
### code chunk number 10: browse.refs (eval = FALSE)
###################################################
## browse.refs(88)


###################################################
### code chunk number 11: info_acid
###################################################
info("acid")


###################################################
### code chunk number 12: info_spaceacid
###################################################
info(" acid")


###################################################
### code chunk number 13: info_OH
###################################################
info("(OH)")


###################################################
### code chunk number 14: protein_LYSC
###################################################
protein("LYSC_CHICK")
protein(6)


###################################################
### code chunk number 15: info_LYSC
###################################################
si <- info("LYSC_CHICK")
info(si)


###################################################
### code chunk number 16: subcrt_water
###################################################
subcrt("water")


###################################################
### code chunk number 17: subcrt_C2H5OH
###################################################
subcrt(c("C2H5OH","O2","CO2","H2O"),c(-1,-3,2,3),T=37)


###################################################
### code chunk number 18: subcrt_C2H5OH_O2aq
###################################################
subcrt(c("C2H5OH","O2","CO2","H2O"),c(-1,-3,2,3),c("aq","aq","aq","liq"),T=37)


###################################################
### code chunk number 19: subcrt_C2H5OH_unbal
###################################################
subcrt(c("C2H5OH","CO2","H2O"),c(-1,2,3),T=37)


###################################################
### code chunk number 20: basis_not (eval = FALSE)
###################################################
## basis(c("CO2","H2O","NH3","H2S","H+"))


###################################################
### code chunk number 21: basis
###################################################
basis(c("CO2","H2O","NH3","O2","H2S","H+"))


###################################################
### code chunk number 22: subcrt_C2H5OH_auto
###################################################
subcrt(c("C2H5OH","CO2","H2O"),c(-1,2,3),T=37)


###################################################
### code chunk number 23: subcrt_C2H5OH
###################################################
subcrt(c("C2H5OH"),c(-1),T=37)


###################################################
### code chunk number 24: subcrt_ethanol
###################################################
subcrt(c("ethanol","acetaldehyde"),c(-1,1),T=37)


###################################################
### code chunk number 25: subcrt_acetaldehyde
###################################################
data(thermo)
basis(c("glutamic acid","methionine","isoleucine","lysine","tyrosine","H+"))
subcrt(c("ethanol","acetaldehyde"),c(-1,1),T=37)


###################################################
### code chunk number 26: subcrt_LYSC
###################################################
data(thermo)

basis("CHNOS+")

subcrt("LYSC_CHICK",1,T=25)



###################################################
### code chunk number 27: subcrt_ALAT1 (eval = FALSE)
###################################################
## 
## subcrt("ALAT1_HUMAN",1,T=25)
## 


###################################################
### code chunk number 28: CSG_species
###################################################
species(c("CSG_METJA","CSG_METVO","CSG_HALJP"))



###################################################
### code chunk number 29: CSG_affinity
###################################################
a <- affinity(O2=c(-80,-65))


###################################################
### code chunk number 30: CSG_diagram
###################################################
diagram(a,legend.x="bottomleft")


###################################################
### code chunk number 31: PredominanceDiagram
###################################################

species(c("SLAP_ACEKI","SLAP_BACST","SLAP_BACLI","SLAP_AERSA"))

basis(c("NH3","H2S"),c(-1,-10))

a <- affinity(O2=c(-90,-70),H2O=c(-15,0))

diagram(a)



###################################################
### code chunk number 32: residue.info
###################################################

residue.info()



###################################################
### code chunk number 33: Bowers
###################################################
basis(c("HCl","H2O","Ca+2","CO2","Mg+2","SiO2","O2","H+"),

  c(999,0,999,999,999,999,999,-7))

species(c("quartz","talc","forsterite","tremolite","diopside",

  "wollastonite","monticellite","merwinite"))

a <- affinity("Mg+2"=c(-12,-4),"Ca+2"=c(-8,0),T=300,P=1000)

diagram(a)



###################################################
### code chunk number 34: example_diagram (eval = FALSE)
###################################################
## 
## example(diagram)
## 


###################################################
### code chunk number 35: examples (eval = FALSE)
###################################################
## 
## examples()
## 


###################################################
### code chunk number 36: helpthermo (eval = FALSE)
###################################################
## 
## help(thermo)
## 


###################################################
### code chunk number 37: session_info
###################################################

sessionInfo()



