### R code from vignette source 'protactiv.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: ProteinFormation
###################################################

library(CHNOSZ)

basis("CHNOS+")

species("CSG",c("METVO","METJA"))



###################################################
### code chunk number 2: ProteinInfo
###################################################

protein.info()



###################################################
### code chunk number 3: ProteinAffinity
###################################################

a <- affinity()

a$values



###################################################
### code chunk number 4: ProteinActivities
###################################################

d <- diagram(a,residue=FALSE,do.plot=FALSE)

d$logact



###################################################
### code chunk number 5: ResidueInfo
###################################################

residue.info()



###################################################
### code chunk number 6: ResidueActivities1
###################################################

d <- diagram(a,do.plot=FALSE)

as.numeric(d$logact)



###################################################
### code chunk number 7: ResidueActivities2
###################################################

d <- diagram(a,as.residue=TRUE,do.plot=FALSE)

10^as.numeric(d$logact)



###################################################
### code chunk number 8: ProteinSpeciation
###################################################

organisms <- c("METSC","METJA","METFE","HALJP","METVO","METBU","ACEKI","BACST","BACLI","AERSA")

proteins <- c(rep("CSG",6),rep("SLAP",4))

basis("CHNOS+")

species(proteins,organisms)

a <- affinity(O2=c(-100,-65))

par(mfrow=c(2,1))

diagram(a,ylim=c(-5,-1),legend.x=NULL,residue=FALSE)

title(main="Equilibrium activities of proteins, whole formulas")

diagram(a,ylim=c(-5,-1),legend.x=NULL)

title(main="Equilibrium activities of proteins, residue equivalents")



###################################################
### code chunk number 9: SulfurSpeciation
###################################################

basis('CHNOS+')

basis('pH',5)

species(c('H2S','S2-2','S3-2','S2O3-2','S2O4-2','S3O6-2','S5O6-2','S2O6-2','HSO3-','SO2','HSO4-'))

a <- affinity(O2=c(-50,-15),T=325,P=350)

par(mfrow=c(2,1))

diagram(a,logact=-2,ylim=c(-30,0),legend.x="topleft",cex.names=0.8)

title(main="Aqueous sulfur speciation, whole formulas")

diagram(a,logact=-2,ylim=c(-30,0),legend.x="topleft",cex.names=0.8,residue=TRUE)

title(main="Aqueous sulfur speciation, 'residue' equivalents")



###################################################
### code chunk number 10: PlasmaExpt
###################################################

f <- system.file("extdata/abundance/AA03.csv",package="CHNOSZ")

pdata <- read.csv(f)

pdrop <- which(pdata$name == "INS.C")

pname <- pdata$name[-pdrop]

iip <- info(paste(pname,"HUMAN",sep="_"),quiet=TRUE)

pmass <- element(thermo$obigt$formula[iip])$mass

loga.expt <- logm <- log10( 10^pdata$log10.pg.ml.[-pdrop] / 10^9 / pmass )



###################################################
### code chunk number 11: PlasmaAct
###################################################

pl <- protein.length(paste(pname,"HUMAN",sep="_"))

logares.tot <- sum(10^loga.expt * pl)



###################################################
### code chunk number 12: PlasmaComparisonRed
###################################################

basis("CHNOS+")

species(as.character(pname),"HUMAN",quiet=TRUE)

a <- affinity()

d <- diagram(a,logact=logares.tot,do.plot=FALSE)

pch <- as.numeric(pdata$type)

revisit(d,"rmsd",loga.ref=loga.expt,pch=pch)

legend("bottomright",pch=unique(pch),legend=unique(pdata$type))



###################################################
### code chunk number 13: PlasmaComparisonOxid
###################################################

basis("O2",-60)

a <- affinity()

d <- diagram(a,logact=logares.tot,do.plot=FALSE)

revisit(d,"rmsd",loga.ref=loga.expt,pch=pch)

legend("topleft",pch=unique(pch),legend=unique(pdata$type))



###################################################
### code chunk number 14: EcoliAbundances
###################################################

data(thermo)

file <- system.file("extdata/abundance/ISR+08.csv",package="CHNOSZ")

expr <- get.expr(file,"ID","emPAI","ECO",list(description="kinase"))

range(expr$loga.ref)



###################################################
### code chunk number 15: EcoliComparison1
###################################################

basis("CHNOS+")

a <- affinity(iprotein=expr$iprotein)

d <- diagram(a,logact=0,do.plot=FALSE)

tp <- thermo$protein[expr$iprotein,]

z <- ZC(protein.formula(tp))

col <- rgb(max(z)-z, 0, z-min(z), max=diff(range(z)))

revisit(d,"rmsd",loga.ref=expr$loga.ref,pch=16,col=col)



###################################################
### code chunk number 16: Ecoli2D
###################################################

a <- affinity(O2=c(-90,-60),NH3=c(-35,0),iprotein=expr$iprotein)

d <- diagram(a,logact=0,do.plot=FALSE,mam=FALSE)

r <- revisit(d,"rmsd",loga.ref=expr$loga.ref)



###################################################
### code chunk number 17: EcoliComparison2
###################################################

basis(c("O2","NH3"),c(r$x,r$y))

a <- affinity(iprotein=expr$iprotein)

d <- diagram(a,logact=0,do.plot=FALSE)

revisit(d,"rmsd",loga.ref=expr$loga.ref,pch=16,col=col)



###################################################
### code chunk number 18: SessionInfo
###################################################

sessionInfo()



