/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class DJList
extends JList
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    protected static ArrayListTransferHandler arrayListHandler;
    protected int dragIndex = -1;
    protected boolean isAtEnd = false;
    Object dropTargetCell;
    static /* synthetic */ Class class$java$util$ArrayList;

    public DJList() {
        if (arrayListHandler == null) {
            arrayListHandler = new ArrayListTransferHandler();
        }
        this.setTransferHandler(arrayListHandler);
        this.setDragEnabled(true);
        this.setCellRenderer(new DListCellRenderer());
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        DropTarget dropTarget = new DropTarget(this, this);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dragIndex = -1;
        this.isAtEnd = false;
        this.repaint();
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.dragIndex = -1;
        this.isAtEnd = false;
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        this.dragIndex = this.locationToIndex(point);
        Rectangle rectangle = this.getCellBounds(0, this.getModel().getSize() - 1);
        boolean bl = this.isAtEnd = rectangle != null && !rectangle.contains(point);
        if (!this.isAtEnd) {
            this.setSelectedIndex(this.dragIndex);
        } else {
            this.getSelectionModel().clearSelection();
        }
        this.repaint();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            dropTargetDropEvent.acceptDrop(2);
            boolean bl = arrayListHandler.importData(this, dropTargetDropEvent.getTransferable());
            int[] nArray = this.getSelectedIndices();
            if (nArray.length > 0) {
                this.getSelectionModel().removeSelectionInterval(nArray[nArray.length - 1], nArray[nArray.length - 1]);
            }
            dropTargetDropEvent.dropComplete(bl);
            this.dragIndex = -1;
            this.isAtEnd = false;
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
    }

    class DListCellRenderer
    extends DefaultListCellRenderer {
        boolean isLastItem;
        int thisIndex;
        Insets normalInsets = super.getInsets();
        Insets lastItemInsets;
        int BOTTOM_PAD = 30;

        public DListCellRenderer() {
            this.lastItemInsets = new Insets(this.normalInsets.top, this.normalInsets.left, this.normalInsets.bottom + this.BOTTOM_PAD, this.normalInsets.right);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.thisIndex = n;
            this.isLastItem = n == jList.getModel().getSize() - 1;
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.thisIndex == DJList.this.dragIndex && !DJList.this.isAtEnd) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.getSize().width, 0);
            } else if (DJList.this.isAtEnd && this.isLastItem) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
            }
        }
    }

    protected class ArrayListTransferHandler
    extends TransferHandler {
        DataFlavor localArrayListFlavor;
        DataFlavor serialArrayListFlavor;
        String localArrayListType = "application/x-java-jvm-local-objectref;class=java.util.ArrayList";
        JList source = null;
        JList target = null;
        int[] indices = null;
        int addIndex = -1;
        int addCount = 0;

        public ArrayListTransferHandler() {
            try {
                this.localArrayListFlavor = new DataFlavor(this.localArrayListType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.serialArrayListFlavor = new DataFlavor(class$java$util$ArrayList == null ? (class$java$util$ArrayList = DJList.class$("java.util.ArrayList")) : class$java$util$ArrayList, "ArrayList");
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            ArrayList arrayList;
            block11: {
                this.target = null;
                arrayList = null;
                if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                    return false;
                }
                try {
                    this.target = (JList)jComponent;
                    if (this.hasLocalArrayListFlavor(transferable.getTransferDataFlavors())) {
                        arrayList = (ArrayList)transferable.getTransferData(this.localArrayListFlavor);
                        break block11;
                    }
                    if (this.hasSerialArrayListFlavor(transferable.getTransferDataFlavors())) {
                        arrayList = (ArrayList)transferable.getTransferData(this.serialArrayListFlavor);
                        break block11;
                    }
                    return false;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            int n = this.target.getSelectedIndex();
            DefaultListModel defaultListModel = (DefaultListModel)this.target.getModel();
            int n2 = defaultListModel.getSize();
            if (n < 0) {
                n = n2;
            } else if (n > n2) {
                n = n2;
            }
            if (this.source.equals(this.target) && this.indices != null && n >= this.indices[0] - 1 && n <= this.indices[this.indices.length - 1]) {
                this.indices = null;
                return true;
            }
            this.addIndex = n;
            this.addCount = arrayList.size();
            for (int i = 0; i < arrayList.size(); ++i) {
                defaultListModel.add(n++, arrayList.get(i));
            }
            return true;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2 && this.indices != null) {
                int n2;
                DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
                if (this.source.equals(this.target) && this.addCount > 0) {
                    for (n2 = 0; n2 < this.indices.length; ++n2) {
                        if (this.indices[n2] <= this.addIndex) continue;
                        int n3 = n2;
                        this.indices[n3] = this.indices[n3] + this.addCount;
                    }
                }
                for (n2 = this.indices.length - 1; n2 >= 0; --n2) {
                    defaultListModel.remove(this.indices[n2]);
                }
            }
            this.indices = null;
            this.target = null;
            this.addIndex = -1;
            this.addCount = 0;
        }

        private boolean hasLocalArrayListFlavor(DataFlavor[] dataFlavorArray) {
            if (this.localArrayListFlavor == null) {
                return false;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(this.localArrayListFlavor)) continue;
                return true;
            }
            return false;
        }

        private boolean hasSerialArrayListFlavor(DataFlavor[] dataFlavorArray) {
            if (this.serialArrayListFlavor == null) {
                return false;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(this.serialArrayListFlavor)) continue;
                return true;
            }
            return false;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            if (this.hasLocalArrayListFlavor(dataFlavorArray)) {
                return true;
            }
            return this.hasSerialArrayListFlavor(dataFlavorArray);
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JList) {
                this.source = (JList)jComponent;
                this.indices = this.source.getSelectedIndices();
                Object[] objectArray = this.source.getSelectedValues();
                if (objectArray == null || objectArray.length == 0) {
                    return null;
                }
                ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    String string = object.toString();
                    if (string == null) {
                        string = "";
                    }
                    arrayList.add(string);
                }
                return new ArrayListTransferable(arrayList);
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        public class ArrayListTransferable
        implements Transferable {
            ArrayList data;

            public ArrayListTransferable(ArrayList arrayList) {
                this.data = arrayList;
            }

            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return this.data;
            }

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{ArrayListTransferHandler.this.localArrayListFlavor, ArrayListTransferHandler.this.serialArrayListFlavor};
            }

            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                if (ArrayListTransferHandler.this.localArrayListFlavor.equals(dataFlavor)) {
                    return true;
                }
                return ArrayListTransferHandler.this.serialArrayListFlavor.equals(dataFlavor);
            }
        }
    }
}

