### R code from vignette source 'GMD-vignette.Rnw'

###################################################
### code chunk number 1: GMD-vignette.Rnw:70-71
###################################################
  cat(sprintf("\\begin{center}{\\Large \\textbf{(Version: %s)}}\\end{center}",packageVersion("GMD")))


###################################################
### code chunk number 2: GMD-vignette.Rnw:122-132
###################################################
## ------------------------------------------------------------------------
## chunk1: Load library and simulate data 
## ------------------------------------------------------------------------
require("GMD") # load library
 
## create two normally-distributed samples
## with unequal means and unequal variances
set.seed(2012)
x1 <- rnorm(1000,mean=-5, sd=10)
x2 <- rnorm(1000,mean=10, sd=5)


###################################################
### code chunk number 3: GMD-vignette.Rnw:135-145
###################################################
## ------------------------------------------------------------------------
## chunk2: Construct histograms
## ------------------------------------------------------------------------
## create common bins
n <- 20 # desired number of bins
breaks <- gbreaks(c(x1,x2),n) # bin boundaries

## make two histograms
v1 <- ghist(x1,breaks=breaks,digits=0)
v2 <- ghist(x2,breaks=breaks,digits=0)


###################################################
### code chunk number 4: GMD-vignette.Rnw:148-153
###################################################
## ------------------------------------------------------------------------
## chunk3: Save histograms as multiple-histogram (`mhist') object
## ------------------------------------------------------------------------
x <- list(v1,v2)
mhist.obj <- as.mhist(x)


###################################################
### code chunk number 5: GMD-vignette.Rnw:156-161
###################################################
## ------------------------------------------------------------------------
## chunk4: Visualize an `mhist' object
## ------------------------------------------------------------------------
## plot histograms side-by-side
plot(mhist.obj,mar=c(1.5,1,1,0),main="Histograms of simulated normal distributions")


###################################################
### code chunk number 6: GMD-vignette.Rnw:164-167
###################################################
## plot histograms as subplots, with corresponding bins aligned
plot(mhist.obj,beside=FALSE,mar=c(1.5,1,1,0),
     main="Histograms of simulated normal distributions")


###################################################
### code chunk number 7: GMD-vignette.Rnw:175-182
###################################################
## ------------------------------------------------------------------------
## chunk5: Measure the pairwise distance between two histograms by GMD
## ------------------------------------------------------------------------
gmdp.obj <- gmdp(v1,v2,sliding=TRUE)
print(gmdp.obj)                       # print a brief version by default
print(gmdp.obj,mode="detailed") # print a detailed version
print(gmdp.obj,mode="full")     # print a full version


###################################################
### code chunk number 8: GMD-vignette.Rnw:189-193
###################################################
## ------------------------------------------------------------------------
## chunk6: Show alignment
## ------------------------------------------------------------------------
plot(gmdp.obj,beside=FALSE)


###################################################
### code chunk number 9: GMD-vignette.Rnw:328-329 (eval = FALSE)
###################################################
## data(package="GMD")


###################################################
### code chunk number 10: GMD-vignette.Rnw:346-347 (eval = FALSE)
###################################################
## help(cage)


###################################################
### code chunk number 11: GMD-vignette.Rnw:350-357
###################################################
data(cage)
class(cage)
length(cage)
names(cage)

data(cagel)
names(cagel)


###################################################
### code chunk number 12: GMD-vignette.Rnw:362-363 (eval = FALSE)
###################################################
## help(chipseq)


###################################################
### code chunk number 13: GMD-vignette.Rnw:366-373
###################################################
data(chipseq_mES)
class(chipseq_mES)
length(chipseq_mES)
names(chipseq_mES)

data(chipseq_hCD4T)
names(chipseq_hCD4T)


