### R code from vignette source 'MFSAS.Rnw'

###################################################
### code chunk number 1: MFSAS.Rnw:373-374
###################################################
options(prompt = "R> ", continue = "+  ", width = 70, useFancyQuotes = FALSE)


###################################################
### code chunk number 2: MFSAS.Rnw:377-380
###################################################
library("MFSAS")
plan.mf <- Ocmult(rn=c(2,4,3), n=30)
plan.mf


###################################################
### code chunk number 3: MFSAS.Rnw:387-391
###################################################
rn <- c(2,4,3)
names(rn) <- c("Critical","Major","Minor")
plan.mf <- Ocmult(rn=rn, n=30)
plan.mf


###################################################
### code chunk number 4: MFSAS.Rnw:401-403
###################################################
plan.hf<- Ocmult(rn=c(2,3), n=15, N=100, type="hyper")
plan.hf


###################################################
### code chunk number 5: MFSAS.Rnw:413-415
###################################################
plan.ms <- Ocmult(rn=3, m=5, stype="seq", pd=seq(0, 0.99, 0.01))
plan.ms


###################################################
### code chunk number 6: MFSAS.Rnw:421-425
###################################################
rn <- c(5,2)
names(rn) <- c("Marginal","Bad")
plan.hs <- Ocmult(rn=rn, m=4, N=100, type="hyper",stype="seq")
plan.hs


###################################################
### code chunk number 7: fig2
###################################################
 plot(plan.ms)


###################################################
### code chunk number 8: fig3
###################################################
  x.mn <- Ocmult(n=8, rn=3, pd=seq(0, 0.22, 0.01))
  x.mh <- Ocmult(n=8, rn=3, N=50, type="hyper", pd=seq(0, 0.2, 0.02))
  x.nmn <- Ocmult(rn=2,m=4, stype="seq", pd=seq(0, 0.22, 0.01))
  x.nmh <- Ocmult(rn=2, m=4, N=50, type="hyper", stype="seq", pd=seq(0, 0.2, 0.02))
  par(mfrow=c(1,2))
  main = "Fixed Sampling Plan \nn = 8, rn = 3"
  plot(x.mn, type="l", xlim=c(0, 0.2), ylim=c(0.75, 1), main=main)
  grid(lty="solid")
  points(x.mh@pd, x.mh@pa, col = 3)
  legend(0.01, 0.81, c("binomial", "hypergeometric"), col = c(1,3), 
     lty = c(1, -1), pch = c(-1, 1), bg = 'gray95')
  main = "Sequential Sampling Plan \nm = 4, rn = 2"
  plot(x.nmn, type="l", xlim=c(0, 0.2), ylim=c(0.7, 1), main=main) 
  grid(lty="solid")
  points(x.nmh@pd, x.nmh@pa, col= 3 )
  legend(0.01, 0.77, c("negative binomial", "negative hypergeometric"), col = c(1,3), 
     lty = c(1,-1),  pch = c(-1, 1), bg = 'gray96')


###################################################
### code chunk number 9: fig4
###################################################
 par(mfrow=c(1,2))
  px <- matrix(c(seq(0,0.2, 0.01),seq(0, 0.8, 0.04)),ncol=2)
  p.multinom <- Ocmult(n=15,rn=c(2,10), pd=px)
  persp(p.multinom, col="light blue")
  contour(p.multinom, nlevel=4)


###################################################
### code chunk number 10: MFSAS.Rnw:525-530
###################################################
  px <- matrix(c(seq(0, 0.5, 0.1), seq(0, 0.2, 0.04),seq(0, 0.1, 0.02)), ncol=3)
  rn <- c(5,4,2)
  names(rn) <- c("Critical","Major","Minor")
  p.multinom <- Ocmult(n=30,rn=rn, pd=px)
  summary(p.multinom ,detail=TRUE )


###################################################
### code chunk number 11: MFSAS.Rnw:541-543
###################################################
  px <- c(0.02, 0.06, 0.04, 0.06, 0.08, 0.02, 0.02, 0.08, 0.04, 0.10)
  pmh <- Ocmult(rn = c(2, 3, 2, 4), n = 20, N = 100, pd = px, type = "hyper")


###################################################
### code chunk number 12: MFSAS.Rnw:572-576
###################################################
 rn <- c(2,3)
 names(rn) <- c("Marginal","Bad")
 assess.multi(rn=rn, m=5, PRP = c(0.05,0.06, 0.95), CRP = c(0.14,0.18, 0.1), 
  stype="seq" )


###################################################
### code chunk number 13: MFSAS.Rnw:596-598
###################################################
  find.multi.plan(PRP=c(0.06, 0.04, 0.06, 0.8), CRP=c(0.14, 0.16, 0.2, 0.1), 
   N= 100,type = "hyper", stype="seq") 


###################################################
### code chunk number 14: MFSAS.Rnw:611-613
###################################################
  find.multi.plan(PRP=c(0.06, 0.04, 0.06, 0.8), CRP=c(0.14, 0.16, 0.2, 0.1), 
   N= 100,type = "hyper") 


###################################################
### code chunk number 15: MFSAS.Rnw:776-782
###################################################
 X <- c(1,3,4)
 n <- 15
 M <- c(8, 10, 14)
 N <- 100
 pr <- pmultihyper(X, n, M, N)
 pr


###################################################
### code chunk number 16: MFSAS.Rnw:794-799
###################################################
 X <- c(1, 3, 4)
 n <- 15
 pr <- c(0.08, 0.10, 0.14)
 cdf <- pmultinom(x = X, size = n, prob = pr)
 cdf


###################################################
### code chunk number 17: MFSAS.Rnw:805-807
###################################################
 for (i in c(0:6)) 
 print(pmultihyper(X, n, 10^i*M, 10^i*N))


###################################################
### code chunk number 18: MFSAS.Rnw:820-826
###################################################
 X <- c(2,3,4,1)
 m <- 5 
 M <-c(5,7,8,3)
 N <-130
 cdf <- pnmultihyper(X, m, M, N)
 cdf


###################################################
### code chunk number 19: MFSAS.Rnw:835-839
###################################################
 X <- c(2,3,4,1)
 m <-5
 pr <-c(5/130, 7/130, 8/130, 3/130)
 pnmultinom(x = X, m = m, prob = pr)


###################################################
### code chunk number 20: MFSAS.Rnw:845-846
###################################################
for (i in c(0:6)) print(pnmultihyper(X, m, 10^i*M, 10^i*N))


