### R code from vignette source 'MLPAstats.Rnw'

###################################################
### code chunk number 1: MLPAstats.Rnw:44-45
###################################################
library(MLPAstats)


###################################################
### code chunk number 2: MLPAstats.Rnw:50-51
###################################################
gui.mlpa()


###################################################
### code chunk number 3: MLPAstats.Rnw:78-85
###################################################
#	data(BRCA)
data(BRCA)
Ms<-list()
Ms$mlpa$arg.mlpa$cont.dat<-BRCAcontrols
Ms$mlpa$arg.mlpa$test.dat<-BRCAcases
Ms$mlpa$arg.mlpa$size.dat<-size
Ms$mlpa$arg.mlpa$probe.dat<-reference.probes


###################################################
### code chunk number 4: MLPAstats.Rnw:92-95
###################################################
attach(Ms$mlpa$arg.mlpa)
Ms$mlpa$mlpa.dat<-setupMLPA(cont.dat,test.dat,size.dat,probe.dat)
detach(Ms$mlpa$arg.mlpa)


###################################################
### code chunk number 5: MLPAstats.Rnw:105-107
###################################################
getInfo()



###################################################
### code chunk number 6: MLPAstats.Rnw:114-116
###################################################
getProbes()
getProbesControl()


###################################################
### code chunk number 7: MLPAstats.Rnw:121-123
###################################################
getPeaks("C5q31", "controls")
getPeaks("C5q31", "tests")


###################################################
### code chunk number 8: MLPAstats.Rnw:128-129
###################################################
getSize()


###################################################
### code chunk number 9: MLPAstats.Rnw:148-150
###################################################
path <- system.file("data", "BRCAcases.txt", package = "MLPAstats")
path


###################################################
### code chunk number 10: MLPAstats.Rnw:258-261
###################################################
Ms$norm$norm.dat<-mlpaNorm(Ms$mlpa$mlpa.dat,method="slope.correction", rep=FALSE)
Ms$norm$type<-"slope.correction"
Ms$norm$rep<-"FALSE"


###################################################
### code chunk number 11: MLPAstats.Rnw:268-269
###################################################
getInfo()


###################################################
### code chunk number 12: MLPAstats.Rnw:273-274
###################################################
# plot(getNormalize())


###################################################
### code chunk number 13: MLPAstats.Rnw:309-314
###################################################
Ms$analysis$analysis.config$method<-"threshold"
Ms$analysis$analysis.config$bands<-"parametric"
Ms$analysis$analysis.config$alpha<-0.05
Ms$analysis$analysis.config$norm<- c(paste(Ms$norm$type,"; rep=",Ms$norm$rep))
Ms$analysis$analysis.res<-mlpa(Ms$norm$norm.dat,Ms$analysis$analysis.config$method)


###################################################
### code chunk number 14: MLPAstats.Rnw:317-322
###################################################
Ms$analysis$analysis.config$method<-"REX-MLPA"
Ms$analysis$analysis.config$bands<-"parametric"
Ms$analysis$analysis.config$alpha<-0.05
Ms$analysis$analysis.config$norm<- c(paste(Ms$norm$type,"; rep=",Ms$norm$rep))
Ms$analysis$analysis.res<-mlpa(Ms$norm$norm.dat,Ms$analysis$analysis.config$method)


###################################################
### code chunk number 15: MLPAstats.Rnw:352-353
###################################################
getInfo()


###################################################
### code chunk number 16: MLPAstats.Rnw:357-358
###################################################
getConfig() 


###################################################
### code chunk number 17: MLPAstats.Rnw:362-363
###################################################
getResults() 


###################################################
### code chunk number 18: MLPAstats.Rnw:368-369
###################################################
plot(getResults())


###################################################
### code chunk number 19: MLPAstats.Rnw:375-376
###################################################
data(BRCA)


###################################################
### code chunk number 20: MLPAstats.Rnw:379-380
###################################################
mlpa.dat<-setupMLPA(BRCAcontrols,BRCAcases,size,reference.probes)


###################################################
### code chunk number 21: MLPAstats.Rnw:383-384
###################################################
norm.dat<-mlpaNorm(Ms$mlpa$mlpa.dat,method="sum.peaks.controls") 


###################################################
### code chunk number 22: MLPAstats.Rnw:387-388
###################################################
plot(norm.dat)


###################################################
### code chunk number 23: MLPAstats.Rnw:391-393
###################################################
ans<-mlpa(norm.dat,"REX-MLPA")
plot(ans)


###################################################
### code chunk number 24: MLPAstats.Rnw:396-397
###################################################
ans


