### R code from vignette source 'NMF-vignette.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(prompt=' ')
options(continue=' ')
set.seed(123456)


###################################################
### code chunk number 2: redirectmessages (eval = FALSE)
###################################################
## options(warn=1,prompt = " ", continue = " ", width = 85)
## cons <- showConnections(all=T)
## .LatexFileName <- "NMF-vignette.tex"
## .LatexFileCon<- getConnection(what = 
## as.integer(rownames(cons)[which(cons[,1]==.LatexFileName)]))
## sink(file = .LatexFileCon, append = TRUE, type = "message" )


###################################################
### code chunk number 3: citations (eval = FALSE)
###################################################
## citation('NMF')
## # To get the citations in Bibtex:
## toBibtex(citation('NMF'))


###################################################
### code chunk number 4: load_library
###################################################
## Install (not run)
# install.packages('NMF')
# Load
library(NMF)


###################################################
### code chunk number 5: features
###################################################
nalgo <- length(nmfAlgorithm())
nseed <- length(nmfSeed())


###################################################
### code chunk number 6: nmfAlgorithm
###################################################
# list all available algorithms
nmfAlgorithm()
# retrieve a specific algorithm: 'brunet' 
nmfAlgorithm('brunet')
# partial match is also fine
identical(nmfAlgorithm('br'), nmfAlgorithm('brunet')) 


###################################################
### code chunk number 7: nmfSeed
###################################################
# list all available seeding methods
nmfSeed()
# retrieve a specific method: 'nndsvd' 
nmfSeed('nndsvd')
# partial match is also fine
identical(nmfSeed('nn'), nmfSeed('nndsvd'))


###################################################
### code chunk number 8: show_Rversions
###################################################
nmfAlgorithm(all=TRUE)

# to get all the algorithms that have a secondary R version
nmfAlgorithm(type='R')


###################################################
### code chunk number 9: perftable_setup
###################################################
# retrieve all the methods that have a secondary R version
meth <- nmfAlgorithm(type='R')
meth <- c(names(meth), meth)
meth

# load the Golub data
data(esGolub)

# compute NMF for each method
res <- nmf(esGolub, 3, meth, seed=123456)

# extract only the elapsed time
t <- sapply(res, runtime)[3,]


###################################################
### code chunk number 10: perftable
###################################################
# speed-up
m <- length(meth)/2
su <- cbind( C=t[1:m], R=t[-(1:m)], Speed.up=t[-(1:m)]/t[1:m])

library(xtable)
xtable(su, caption='Performance speed up achieved by the optimized C++ implementation for some of the NMF algorithms.', label='tab:perf')


###################################################
### code chunk number 11: esGolub
###################################################
data(esGolub)
esGolub
esGolub <- esGolub[1:200,]


###################################################
### code chunk number 12: algo_default
###################################################
# default NMF algorithm
res <- nmf(esGolub, 3)


###################################################
### code chunk number 13: single_show
###################################################
res 


###################################################
### code chunk number 14: single_show_model
###################################################
fit(res)


###################################################
### code chunk number 15: single_show_estimate
###################################################
V.hat <- fitted(res)
dim(V.hat)


###################################################
### code chunk number 16: singlerun_summary
###################################################
summary(res)

# More quality measures are computed, if the target matrix is provided: 
summary(res, target=esGolub)


###################################################
### code chunk number 17: singlerun_summary_factor
###################################################
summary(res, class=esGolub$Cell)


###################################################
### code chunk number 18: get_matrices
###################################################
# get matrix W
w <- basis(res)
dim(w)

# get matrix H
h <- coef(res)
dim(h)


###################################################
### code chunk number 19: subset
###################################################
# keep only the first 10 features
res.subset <- res[1:10,] 
class(res.subset)
dim(res.subset)
# keep only the first 10 samples 
dim(res[,1:10])
# subset both features and samples:
dim(res[1:20,1:10])


###################################################
### code chunk number 20: single_extract
###################################################
# only compute the scores
s <- featureScore(res)
summary(s)

# compute the scores and characterize each metagene
s <- extractFeatures(res)
str(s)


###################################################
### code chunk number 21: algo_list
###################################################
nmfAlgorithm()


###################################################
### code chunk number 22: algo_lee
###################################################
# using Lee and Seung's algorithm
res <- nmf(esGolub, 3, 'lee')
algorithm(res)


###################################################
### code chunk number 23: algo_ns
###################################################
# using the Nonsmooth NMF algorithm with parameter theta=0.7
res <- nmf(esGolub, 3, 'ns', theta=0.7)
algorithm(res)
fit(res)


###################################################
### code chunk number 24: algo_pe
###################################################
# using the PE-NMF algorithm with parameters alpha=0.01, beta=1
res <- nmf(esGolub, 3, 'pe', alpha=0.01, beta=1)
res


###################################################
### code chunk number 25: seed_list
###################################################
nmfSeed()


###################################################
### code chunk number 26: seed
###################################################
res <- nmf(esGolub, 3, seed='nndsvd')
res


###################################################
### code chunk number 27: seed_numeric
###################################################
res <- nmf(esGolub, 3, seed=123456)
res


###################################################
### code chunk number 28: seed_WH
###################################################
n <- nrow(esGolub); p <- ncol(esGolub)
res <- nmf(esGolub, 3, seed=NULL, W=matrix(0.5, n, 3), H=matrix(0.3, 3, p))
res


###################################################
### code chunk number 29: seed_model (eval = FALSE)
###################################################
## res <- nmf(esGolub, 3, seed=NULL
## 		, model=list(W=matrix(0.5, n, 3), H=matrix(0.3, 3, p)))
## # or
## res <- nmf(esGolub, 3, seed=nmfModel(W=matrix(0.5, n, 3), H=matrix(0.3, 3, p)))


###################################################
### code chunk number 30: algo_multirun
###################################################
res.multirun <- nmf(esGolub, 3, nrun=5)
res.multirun


###################################################
### code chunk number 31: multirun_keep
###################################################
# explicitly setting the option keep.all to TRUE
res <- nmf(esGolub, 3, nrun=5, .options=list(keep.all=TRUE))
res


###################################################
### code chunk number 32: multirun_keep_alt (eval = FALSE)
###################################################
## # or using letter code 'k' in argument .options
## nmf(esGolub, 3, nrun=5, .options='k')


###################################################
### code chunk number 33: parallel_multicore
###################################################
# the default call will try to run in parallel using all the cores
# => will be in parallel if all the requirements are satisfied
nmf(esGolub, 3, nrun=5, .opt='v')


###################################################
### code chunk number 34: parallel_multicore_alt (eval = FALSE)
###################################################
## # specifying the number of cores to use 
## nmf(esGolub, 3, nrun=5, .opt='v', .pbackend=2)
## 
## # force parallel computation: use option 'P'
## nmf(esGolub, 3, nrun=5, .opt='vP')


###################################################
### code chunk number 35: mpi_file (eval = FALSE)
###################################################
## file.show(file.system('examples/mpi.R', package='NMF'))
## 
## # and
## file.show(file.system('examples/mpi_run.sh', package='NMF'))
## 


###################################################
### code chunk number 36: mpi (eval = FALSE)
###################################################
## 
## ## 0. Create and register an MPI cluster
## library(doMPI)
## cl <- startMPIcluster()
## registerDoMPI(cl)
## library(NMF)
## 
## ## 1. Schedule the runs accross the workers
## nrun <- 100;
## nworker <- getDoParWorkers();
## ntasks <- rep(round(nrun/nworker), nworker)
## # allocate remainder runs
## if( (remain <- nrun %% nworker) > 0 ) 
## 	ntasks[1:remain] <- ntasks[1:remain] + 1
## 
## ## 2. Send the jobs to the workers using a foreach loop
## t <- system.time({
## 	res <- foreach(i=1:getDoParWorkers(), n=ntasks, 
## 		.packages = c('NMF', 'doMC', 'Biobase')) %dopar% {
## 
## 		# each worker run its factorizations in parallel
## 		#Note: only the best result is kept
## 		data(esGolub)
## 		nmf(esGolub, 3, 'brunet', nrun=n, .opt='p')
## 	}
## })
## ## 3. reduce the result and save it in a file
## res <- NMF:::join(res, runtime.all=t)
## save(res, file='result.RData')
## 
## ## 4. Shutdown the cluster and quit MPI
## closeCluster(cl)
## mpi.quit()
## 


###################################################
### code chunk number 37: force_seq (eval = FALSE)
###################################################
## # force sequential computation by sapply: use option '-p' or .pbackend=''
## nmf(esGolub, 3, nrun=5, .opt='v-p')
## nmf(esGolub, 3, nrun=5, .opt='v', .pbackend='')
## 
## # or use the SEQ backend of foreach: .pbackend=NULL or 'seq'
## nmf(esGolub, 3, nrun=5, .opt='v', .pbackend=NULL)
## nmf(esGolub, 3, nrun=5, .opt='v', .pbackend='seq')


###################################################
### code chunk number 38: estimate_rank
###################################################
# perform 10 runs for each value of r in range 2:6
estim.r <- nmfEstimateRank(esGolub, range=2:6, nrun=10, seed=123456)


###################################################
### code chunk number 39: estimate_rank_plot
###################################################
plot(estim.r)


###################################################
### code chunk number 40: estimate_rank_plot_include
###################################################
plot(estim.r)


###################################################
### code chunk number 41: estimate_r_random
###################################################
# shuffle original data
V.random <- randomize(esGolub)
# estimate quality measures from the shuffled data (use default NMF algorithm)
estim.r.random <- nmfEstimateRank(V.random, range=2:6, nrun=10, seed=123456)
# plot measures on same graph
plot(estim.r, ref=estim.r.random)


###################################################
### code chunk number 42: estimate_rank_random_include
###################################################
# shuffle original data
V.random <- randomize(esGolub)
# estimate quality measures from the shuffled data (use default NMF algorithm)
estim.r.random <- nmfEstimateRank(V.random, range=2:6, nrun=10, seed=123456)
# plot measures on same graph
plot(estim.r, ref=estim.r.random)


###################################################
### code chunk number 43: errorplot_compute
###################################################
res <- nmf(esGolub, 3, .options='t')
# or alternatively:
# res <- nmf(esGolub, 3, .options=list(track=TRUE))
plot(res)


###################################################
### code chunk number 44: errorplot_include
###################################################
res <- nmf(esGolub, 3, .options='t')
# or alternatively:
# res <- nmf(esGolub, 3, .options=list(track=TRUE))
plot(res)


###################################################
### code chunk number 45: heatmap_profile
###################################################
# default is to plot metaprofiles
metaHeatmap(res) 


###################################################
### code chunk number 46: heatmap_profile_inc
###################################################
# default is to plot metaprofiles
metaHeatmap(res) 


###################################################
### code chunk number 47: heatmap_genes
###################################################
metaHeatmap(res, what='features', filter=TRUE)


###################################################
### code chunk number 48: heatmap_genes_inc
###################################################
metaHeatmap(res, what='features', filter=TRUE)


###################################################
### code chunk number 49: heatmap_consensus
###################################################
# The cell type is used to label rows and columns 
metaHeatmap(res.multirun, labRow=esGolub$Cell, labCol=esGolub$Cell)


###################################################
### code chunk number 50: heatmap_consensus_inc
###################################################
# The cell type is used to label rows and columns 
metaHeatmap(res.multirun, labRow=esGolub$Cell, labCol=esGolub$Cell)


###################################################
### code chunk number 51: multimethod
###################################################
res.multi.method <- nmf(esGolub, 3, list('brunet', 'lee', 'ns'), seed=123456)


###################################################
### code chunk number 52: compare
###################################################
compare(res.multi.method)

# If prior knowledge of classes is available
compare(res.multi.method, class=esGolub$Cell)


###################################################
### code chunk number 53: multiple_errorplot_compute
###################################################
res <- nmf(esGolub, 3, list('brunet', 'lee', 'ns'), seed=123456, .options='t')
plot(res)


###################################################
### code chunk number 54: multiple_errorplot_include
###################################################
res <- nmf(esGolub, 3, list('brunet', 'lee', 'ns'), seed=123456, .options='t')
plot(res)


###################################################
### code chunk number 55: custom_algo_sig
###################################################
my.algorithm <- function(x, seed, param.1, param.2){
	# do something with starting point
	# ...
	
	# return updated starting point
	return(seed)
}


###################################################
### code chunk number 56: custom_algo
###################################################
my.algorithm <- function(x, seed, scale.factor=1){
	# do something with starting point
	# ...
	# for example: 
	# 1. compute principal components	
	pca <- prcomp(t(x), retx=TRUE)
	
	# 2. use the absolute values of the first PCs for the metagenes
	# Note: the factorization rank is stored in object 'start'	
	factorization.rank <- nbasis(seed)
	metagenes(fit(seed)) <- abs(pca$rotation[,1:factorization.rank])
	# use the rotated matrix to get the mixture coefficient
	# use a scaling factor (just to illustrate the use of extra parameters)
	metaprofiles(fit(seed)) <- t(abs(pca$x[,1:factorization.rank])) / scale.factor
	
	# return updated data
	return(seed)
}


###################################################
### code chunk number 57: define_V
###################################################
n <- 50; r <- 3; p <- 20
V <-syntheticNMF(n, r, p, noise=TRUE)


###################################################
### code chunk number 58: custom_algo_run
###################################################
nmf(V, 3, my.algorithm, scale.factor=10)


###################################################
### code chunk number 59: custom_algo_run_obj
###################################################
# based on Kullbach-Leibler divergence
nmf(V, 3, my.algorithm, scale.factor=10, objective='KL')
# based on custom distance metric
nmf(V, 3, my.algorithm, scale.factor=10
	, objective=function(target, x){ 
			( sum( (target-fitted(x))^4 ) )^{1/4} 
		}
)


###################################################
### code chunk number 60: custom_algo_run_mixed
###################################################
# put some negative input data 
V.neg <- V; V.neg[1,] <- -1;

# this generates an error
err <- try( nmf(V.neg, 3, my.algorithm, scale.factor=10) )
err

# this runs my.algorithm without error
nmf(V.neg, 3, my.algorithm, mixed=TRUE, scale.factor=10)


###################################################
### code chunk number 61: nmf_models
###################################################
nmfModel()


###################################################
### code chunk number 62: custom_algo_NMFoffset
###################################################
my.algorithm.offset <- function(x, seed, scale.factor=1){
	# do something with starting point
	# ...
	# for example: 
	# 1. compute principal components	
	pca <- prcomp(t(x), retx=TRUE)
	
	# retrieve the model being estimated
	data.model <- fit(seed)
	
	# 2. use the absolute values of the first PCs for the metagenes
	# Note: the factorization rank is stored in object 'start'	
	factorization.rank <- nbasis(data.model)
	metagenes(data.model) <- abs(pca$rotation[,1:factorization.rank])	
	# use the rotated matrix to get the mixture coefficient
	# use a scaling factor (just to illustrate the use of extra parameters)
	metaprofiles(data.model) <- t(abs(pca$x[,1:factorization.rank])) / scale.factor
	
	# 3. Compute the offset as the mean expression
	data.model@offset <- rowMeans(x)	
	
	# return updated data
	fit(seed) <- data.model
	seed
}


###################################################
### code chunk number 63: custom_algo_NMFOffset_run
###################################################
# run custom algorithm with NMF model with offset
nmf(V, 3, my.algorithm.offset, model='NMFOffset', scale.factor=10)


###################################################
### code chunk number 64: custom_seed
###################################################

# start: object of class NMF
# target: the target matrix
my.seeding.method <- function(model, target){
	
	# use only the largest columns for W
	w.cols <- apply(target, 2, function(x) sqrt(sum(x^2)))
	metagenes(model) <- target[,order(w.cols)[1:nbasis(model)]]
	
	# initialize H randomly
	metaprofiles(model) <- matrix(runif(nbasis(model)*ncol(target))
						, nbasis(model), ncol(target))

	# return updated object
	return(model)
}


###################################################
### code chunk number 65: custom_algo_run
###################################################
nmf(V, 3, 'snmf/r', seed=my.seeding.method)


###################################################
### code chunk number 66: options_algo (eval = FALSE)
###################################################
## #show default algorithm and seeding method
## nmf.options('default.algorithm', 'default.seed')
## 
## # retrieve a single option
## nmf.getOption('default.seed')
## 
## # All options
## nmf.options()


###################################################
### code chunk number 67: sessionInfo
###################################################
sessionInfo()


###################################################
### code chunk number 68: restaure (eval = FALSE)
###################################################
## sink(type="message")


