### R code from vignette source 'R2admb.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: R2admb.Rnw:31-32
###################################################
options(continue=" ")


###################################################
### code chunk number 2: R2admb.Rnw:48-49 (eval = FALSE)
###################################################
## install.packages("R2admb",repos="http://r-forge.r-project.org")


###################################################
### code chunk number 3: R2admb.Rnw:79-81 (eval = FALSE)
###################################################
## do_admb(fn,data,params,
##         run.opts=run.control(checkparam="write",checkdata="write"))


###################################################
### code chunk number 4: libs
###################################################
library(R2admb)
library(ggplot2) ## for pictures


###################################################
### code chunk number 5: dat1
###################################################
ReedfrogSizepred <- 
  data.frame(TBL = rep(c(9,12,21,25,37),each=3),
             Kill = c(0,2,1,3,4,5,0,0,0,0,1,0,0,0,0L))


###################################################
### code chunk number 6: mlefit
###################################################
library(bbmle)
m0 <- mle2(Kill~dbinom(c*((TBL/d)*exp(1-TBL/d))^g,size=10),
           start=list(c=0.45,d=13,g=1),data=ReedfrogSizepred,
           method="L-BFGS-B",
           lower=c(c=0.003,d=10,g=0),
           upper=c(c=0.8,d=20,g=20),
           control=list(parscale=c(c=0.5,d=10,g=1)))


###################################################
### code chunk number 7: predvals
###################################################
TBLvec = seq(9.5,36,length=100)
predfr <- 
  data.frame(TBL=TBLvec,
             Kill=predict(m0,newdata=data.frame(TBL=TBLvec)))


###################################################
### code chunk number 8: fig1
###################################################
g1  <- ggplot(ReedfrogSizepred,
             aes(x=TBL,y=Kill/10))+
  geom_point()+stat_sum(aes(size=factor(..n..)))+
  geom_smooth()+
  theme_bw()+
  labs(size="n",x="Size (total body length",
       y="Proportion killed")+
  coord_cartesian(ylim=c(-0.05,0.55))
startest <- stat_function(fun = function(x) { 0.45*((x/13)*exp(1-x/13)) },
                          lty=2,colour="red")
print(g1+startest+
      geom_line(data=predfr,colour="purple",lty=2))


###################################################
### code chunk number 9: admbfit_getruns
###################################################
## load in data from previously executed runs
zz <- load("Reedfrog_runs.RData")


###################################################
### code chunk number 10: R2admb.Rnw:231-232 (eval = FALSE)
###################################################
## setup_admb()


###################################################
### code chunk number 11: R2admb.Rnw:234-239
###################################################
rfs_params <- list(c=0.45,d=13,g=1) ## starting parameters
rfs_bounds <- list(c=c(0,1),d=c(0,50),g=c(-1,25)) ## bounds
rfs_dat <- c(list(nobs=nrow(ReedfrogSizepred),
                  nexposed=rep(10,nrow(ReedfrogSizepred))),
             ReedfrogSizepred)


###################################################
### code chunk number 12: admbfit_fake (eval = FALSE)
###################################################
## m1 <- do_admb("ReedfrogSizepred0",
##               data=rfs_dat,
##               params=rfs_params,
##               bounds=rfs_bounds,
##               run.opts=run.control(checkparam="write",
##                 checkdata="write"))
## unlink(c("reedfrogsizepred0.tpl",
##          "reedfrogsizepred0_gen.tpl",
##          "reedfrogsizepred0")) ## clean up leftovers


###################################################
### code chunk number 13: basic
###################################################
m1


###################################################
### code chunk number 14: coef
###################################################
coef(m1)


###################################################
### code chunk number 15: summary
###################################################
summary(m1)


###################################################
### code chunk number 16: vcov
###################################################
vcov(m1)


###################################################
### code chunk number 17: others
###################################################
c(logLik(m1),deviance(m1),AIC(m1))


###################################################
### code chunk number 18: profrun (eval = FALSE)
###################################################
## m1P <- do_admb("ReedfrogSizepred0",
##                data=c(list(nobs=nrow(ReedfrogSizepred),
##                  nexposed=rep(10,nrow(ReedfrogSizepred))),
##                  ReedfrogSizepred),
##                params=rfs_params,
##                bounds=rfs_bounds,
##                run.opts=run.control(checkparam="write",
##                  checkdata="write"),
##                profile=TRUE,
##                profpars=c("c","d","g"))


###################################################
### code chunk number 19: mleprof
###################################################
m0prof <- profile(m0)


###################################################
### code chunk number 20: profcalcs2
###################################################
tmpf <- function(p,w="prof") {
  pp <- log(m1P$prof[[p]][[w]][,2])
  pp <- max(pp)-pp
  data.frame(param=p,z=sqrt(2*pp),
             par.vals.c=NA,par.vals.d=NA,par.vals.g=NA,focal=m1P$prof[[p]][[w]][,1])
}
proflist <- do.call(rbind,lapply(list("c","d","g"),tmpf))
profnlist <- do.call(rbind,lapply(list("c","d","g"),tmpf,w="prof_norm"))
pdat <- rbind(cbind(as.data.frame(m0prof),method="mle2"),
              cbind(proflist,method="ADMB"),
              cbind(profnlist,method="ADMB_norm"))


###################################################
### code chunk number 21: profpic
###################################################
print(ggplot(pdat,aes(x=focal,y=abs(z),group=method,colour=method))+geom_line()+
      geom_point(alpha=0.5)+
  facet_grid(.~param,scale="free_x")+ylim(0,3)+xlab("")+
      ylab(expression(Delta(sqrt(-2*L))))+
      geom_hline(yintercept=1.96,lty=2))


###################################################
### code chunk number 22: admbfakemc (eval = FALSE)
###################################################
## m1MC <- do_admb("ReedfrogSizepred0",
##               data=rfs_dat,
##                 params=rfs_params,
##                 bounds=rfs_bounds,
##                 run.opts=run.control(checkparam="write",
##                   checkdata="write"),
##                 mcmc=TRUE,
##                 mcmc.opts=mcmc.control(mcmcpars=c("c","d","g")))
## ## clean up leftovers:
## unlink(c("reedfrogsizepred0.tpl",
##          "reedfrogsizepred0_gen.tpl",
##          "reedfrogsizepred0"))


###################################################
### code chunk number 23: mchistplot
###################################################
print(plot(m1MC$hist))


###################################################
### code chunk number 24: R2admb.Rnw:419-421
###################################################
library(coda)
mmc <- as.mcmc(m1MC$mcmc)


###################################################
### code chunk number 25: mctraceplot
###################################################
print(xyplot(mmc))


###################################################
### code chunk number 26: R2admb.Rnw:440-442
###################################################
raftery.diag(mmc)
geweke.diag(mmc)


###################################################
### code chunk number 27: R2admb.Rnw:444-446
###################################################
gd <- geweke.diag(mmc)
gd1 <- gd[["z"]][1]


###################################################
### code chunk number 28: R2admb.Rnw:459-460
###################################################
effectiveSize(mmc)


###################################################
### code chunk number 29: R2admb.Rnw:467-468
###################################################
HPDinterval(mmc)


###################################################
### code chunk number 30: mcdensplot
###################################################
print(densityplot(mmc))


###################################################
### code chunk number 31: lme4
###################################################
library(lme4)
gm1 <- glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
                family = binomial, data = cbpp)


###################################################
### code chunk number 32: toymats
###################################################
X <- model.matrix(~period,data=cbpp)
Zherd <- model.matrix(~herd-1,data=cbpp)


###################################################
### code chunk number 33: toydat
###################################################
tmpdat <- list(X=X,Zherd=Zherd,
                 incidence=cbpp$incidence,size=cbpp$size,
                 nobs=nrow(cbpp))


###################################################
### code chunk number 34: loadtoy1
###################################################
load("toy1_runs.RData")


###################################################
### code chunk number 35: fakerun2 (eval = FALSE)
###################################################
## d1 <- do_admb("toy1",
##               data=tmpdat,
##               params=list(beta=rep(0,ncol(X)),sigma_herd=0.1),
##               bounds=list(sigma_herd=c(0.0001,20)),
##               re=list(u_herd=ncol(Zherd)),
##               run.opts=run.control(checkdata="write",checkparam="write"),
##               mcmc=TRUE,
##               mcmc.opts=mcmc.control(mcmc=20,mcmcpars=c("beta","sigma_herd")))


###################################################
### code chunk number 36: testprofinput (eval = FALSE)
###################################################
## do_admb("toy1", data=tmpdat,
##         params=list(beta=rep(0,ncol(X)),sigma_herd=0.1),
##         bounds=list(sigma_herd=c(0.0001,20)),
##         re=list(u_herd=ncol(Zherd)),
##         run.opts=run.control(checkdata="write",checkparam="write",
##           clean=FALSE))
## run_admb("toy1_gen",profile=TRUE)
## read_admb("toy1_gen",profile=TRUE)


###################################################
### code chunk number 37: coefsumlmer
###################################################
coef(summary(gm1))


###################################################
### code chunk number 38: coefsumadmb
###################################################
coef(summary(d1))[1:5,]


###################################################
### code chunk number 39: ranefs
###################################################
plot(ranef(gm1)$herd[,1],coef(d1)[6:20]*coef(d1)["sigma_herd"],
     xlab="glmer estimate",ylab="ADMB estimate")
abline(a=0,b=1)


###################################################
### code chunk number 40: R2admb.Rnw:587-589
###################################################
detach("package:lme4") ## HPDinterval definition gets in the way
HPDinterval(as.mcmc(d1$mcmc[,6:20]))


