/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.MenuCanvas;
import ij.gui.ScrollbarWithLabel;
import ij.gui.StackWindow;
import ij.io.PluginClassLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

public class ImageJApplet
extends Applet {
    ScrollPane imagePane;
    ScrollbarWithLabel scrollC;
    ScrollbarWithLabel scrollZ;
    ScrollbarWithLabel scrollT;
    int heightWithoutImage;
    Panel north;
    Panel south;
    MenuCanvas menu;
    ImagePlus image;
    Vector pluginJarURLs;

    public ImageJApplet() {
        try {
            System.setSecurityManager(null);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.menu = new MenuCanvas();
        this.north = new Panel();
        this.north.setLayout(new BorderLayout());
        this.north.add((Component)this.menu, "North");
        this.add((Component)this.north, "North");
        this.imagePane = new ScrollPane();
        this.add((Component)this.imagePane, "Center");
        this.south = new Panel();
        this.south.setLayout(new GridBagLayout());
        this.add((Component)this.south, "South");
    }

    public Component add(Component component) {
        if (this.north.getComponentCount() < 2) {
            this.north.add(component, "South");
        } else if (this.getComponentCount() < 3) {
            this.add(component, "Center");
        } else if (this.getComponentCount() < 4) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.south.add(component, gridBagConstraints);
        } else {
            IJ.error("Too many components!");
        }
        return null;
    }

    public void pack() {
        this.north.doLayout();
        this.imagePane.doLayout();
        this.south.doLayout();
        this.doLayout();
    }

    public void setImageCanvas(Component component) {
        if (component != null) {
            this.imagePane.removeAll();
            this.imagePane.add(component);
            component.requestFocus();
            if (this.scrollC != null) {
                this.south.remove(this.scrollC);
            }
            if (this.scrollZ != null) {
                this.south.remove(this.scrollZ);
            }
            if (this.scrollT != null) {
                this.south.remove(this.scrollT);
            }
            if (component instanceof ImageCanvas) {
                this.image = ((ImageCanvas)component).getImage();
                if (this.image.getWindow() instanceof StackWindow) {
                    StackWindow stackWindow = (StackWindow)this.image.getWindow();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    this.scrollC = stackWindow.getCSelector();
                    this.scrollZ = stackWindow.getZSelector();
                    this.scrollT = stackWindow.getTSelector();
                    if (this.scrollC != null) {
                        gridBagConstraints.fill = 2;
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = 1;
                        this.south.add((Component)this.scrollC, gridBagConstraints);
                    }
                    if (this.scrollZ != null) {
                        gridBagConstraints.fill = 2;
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = 2;
                        this.south.add((Component)this.scrollZ, gridBagConstraints);
                    }
                    if (this.scrollT != null) {
                        gridBagConstraints.fill = 2;
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = 3;
                        this.south.add((Component)this.scrollT, gridBagConstraints);
                    }
                }
            }
            this.pack();
        }
    }

    public String getURLParameter(String string) {
        int n;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return null;
        }
        if (string2.indexOf(":/") < 0) {
            string2 = this.getCodeBase().toString() + string2;
        }
        if (string2.indexOf("://") < 0 && (n = string2.indexOf(":/")) > 0) {
            string2 = string2.substring(0, n) + ":///" + string2.substring(n + 2);
        }
        return string2;
    }

    public Vector getPluginJarURLs() {
        if (this.pluginJarURLs == null) {
            String string;
            this.pluginJarURLs = new Vector();
            for (int i = 1; i < 999 && (string = this.getURLParameter("plugin" + i)) != null; ++i) {
                this.pluginJarURLs.addElement(string);
            }
        }
        return this.pluginJarURLs;
    }

    public void init() {
        Object object;
        String string;
        int n;
        ImageJ imageJ = IJ.getInstance();
        if (imageJ == null || imageJ != null && !imageJ.isShowing()) {
            new ImageJ(this);
        }
        for (n = 1; n <= 9 && (string = this.getURLParameter("url" + n)) != null; ++n) {
            object = new ImagePlus(string);
            if (object == null) continue;
            ((ImagePlus)object).show();
        }
        for (n = 1; n <= 9 && (string = this.getURLParameter("macro" + n)) != null; ++n) {
            try {
                String string2;
                object = new URL(string).openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2 + "\n");
                }
                ((InputStream)object).close();
                IJ.runMacro(stringBuffer.toString());
                continue;
            }
            catch (Exception exception) {
                IJ.write("warning: " + exception);
            }
        }
        for (n = 1; n <= 9 && (string = this.getParameter("eval" + n)) != null; ++n) {
            IJ.runMacro(string);
        }
        IJ.setClassLoader(new PluginClassLoader(this.getPluginJarURLs()));
    }

    public void destroy() {
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null) {
            imageJ.quit();
        }
    }

    public void stop() {
        ImageJ imageJ = IJ.getInstance();
        imageJ.dispose();
    }

    public void open(String string) {
        IJ.open(string);
    }

    public void eval(String string) {
        IJ.runMacro(string);
    }
}

