/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.ColorPanel;
import ij.gui.GenericDialog;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class ColorChooser
implements TextListener,
AdjustmentListener {
    Vector colors;
    Vector sliders;
    ColorPanel panel;
    Color initialColor;
    int red;
    int green;
    int blue;
    boolean useHSB;
    String title;
    Frame frame;

    public ColorChooser(String string, Color color, boolean bl) {
        this(string, color, bl, null);
    }

    public ColorChooser(String string, Color color, boolean bl, Frame frame) {
        this.title = string;
        if (color == null) {
            color = Color.black;
        }
        this.initialColor = color;
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.useHSB = bl;
        this.frame = frame;
    }

    public Color getColor() {
        int n;
        GenericDialog genericDialog = this.frame != null ? new GenericDialog(this.title, this.frame) : new GenericDialog(this.title);
        genericDialog.addSlider("Red:", 0.0, 255.0, this.red);
        genericDialog.addSlider("Green:", 0.0, 255.0, this.green);
        genericDialog.addSlider("Blue:", 0.0, 255.0, this.blue);
        this.panel = new ColorPanel(this.initialColor);
        genericDialog.addPanel(this.panel, 10, new Insets(10, 0, 0, 0));
        this.colors = genericDialog.getNumericFields();
        for (n = 0; n < this.colors.size(); ++n) {
            ((TextField)this.colors.elementAt(n)).addTextListener(this);
        }
        this.sliders = genericDialog.getSliders();
        for (n = 0; n < this.sliders.size(); ++n) {
            ((Scrollbar)this.sliders.elementAt(n)).addAdjustmentListener(this);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        n = (int)genericDialog.getNextNumber();
        int n2 = (int)genericDialog.getNextNumber();
        int n3 = (int)genericDialog.getNextNumber();
        return new Color(n, n2, n3);
    }

    public void textValueChanged(TextEvent textEvent) {
        int n = (int)Tools.parseDouble(((TextField)this.colors.elementAt(0)).getText());
        int n2 = (int)Tools.parseDouble(((TextField)this.colors.elementAt(1)).getText());
        int n3 = (int)Tools.parseDouble(((TextField)this.colors.elementAt(2)).getText());
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        this.panel.setColor(new Color(n, n2, n3));
        this.panel.repaint();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        for (int i = 0; i < this.sliders.size(); ++i) {
            if (object != this.sliders.elementAt(i)) continue;
            Scrollbar scrollbar = (Scrollbar)object;
            TextField textField = (TextField)this.colors.elementAt(i);
        }
    }
}

