/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.PopupMenuBar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;

public class MenuCanvas
extends Panel {
    private final int pad = 2;
    private final int padx = 8;
    private Color toolColor = new Color(0, 25, 45);
    PopupMenuBar menuBar = new PopupMenuBar();
    int menuX;

    public MenuCanvas() {
        this.setLayout(new FlowLayout());
        this.enableEvents(48L);
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(this.menuBar.getFont());
        int n = this.menuBar.getFont().getSize();
        int[] nArray = this.menuBar.calculateWidths(this, graphics);
        int n2 = 10;
        for (int i = 0; i < nArray.length; ++i) {
            if (i == nArray.length - 1 && this.menuBar.helpMenu != null) {
                n2 = this.getWidth() - 2 - nArray[i];
            }
            graphics.drawString(this.menuBar.getMenu(i).getLabel(), n2, n - 1);
            n2 += nArray[i] + 16;
        }
    }

    public Dimension getPreferredSize() {
        int n = 4;
        int n2 = this.getFont().getSize() + 4;
        int[] nArray = this.menuBar.calculateWidths(this, this.getGraphics());
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] + 16;
        }
        return new Dimension(n, n2);
    }

    int getMenuIndex(int n) {
        int[] nArray = this.menuBar.getWidths();
        int n2 = this.getWidth();
        Menu menu = this.menuBar.getHelpMenu();
        int n3 = this.menuBar.getMenuCount();
        if (menu != null) {
            --n3;
            this.menuX = n2 - nArray[nArray.length - 1] - 2 - 8;
            if (n < n2 - 2 && n >= this.menuX) {
                return n3;
            }
        }
        n2 = 2;
        this.menuX = 2;
        for (int i = 0; i < n3; ++i) {
            if (n < (n2 += nArray[i] + 16)) {
                return i;
            }
            this.menuX = n2;
        }
        return -1;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = this.getMenuIndex(mouseEvent.getX());
        int n2 = mouseEvent.getID();
        if (n2 == 501) {
            if (n < 0) {
                return;
            }
            Dimension dimension = this.getSize();
            PopupMenu popupMenu = (PopupMenu)this.menuBar.getMenu(n);
            this.add(popupMenu);
            popupMenu.show(this, this.menuX, dimension.height);
        } else if (n2 == 505 || n2 == 503 || n2 == 504) {
            // empty if block
        }
    }
}

