/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.plugin.Colors;
import java.awt.Color;
import java.awt.Font;

public class RoiProperties {
    private Roi roi;
    private String title;
    private boolean showName = true;
    private boolean showCheckbox;

    public RoiProperties(String string, Roi roi) {
        if (roi == null) {
            throw new IllegalArgumentException("ROI is null");
        }
        this.title = string;
        this.showName = string.startsWith("Prop");
        this.showCheckbox = string.equals("Add to Overlay");
        this.roi = roi;
    }

    public boolean showDialog() {
        String string;
        String string2;
        Object object;
        double d;
        String string3;
        Color color = null;
        Color color2 = null;
        double d2 = 1.0;
        String string4 = this.roi.getName();
        boolean bl = string4 != null && string4.startsWith("range: ");
        String string5 = string3 = bl ? "Range:" : "Name:";
        if (bl) {
            string4 = string4.substring(7);
        }
        if (string4 == null) {
            string4 = "";
        }
        if (!bl && this.roi instanceof ImageRoi) {
            return this.showImageDialog(string4);
        }
        if (this.roi.getStrokeColor() != null) {
            color = this.roi.getStrokeColor();
        }
        if (color == null) {
            color = Roi.getColor();
        }
        if (this.roi.getFillColor() != null) {
            color2 = this.roi.getFillColor();
        }
        if ((d = (double)this.roi.getStrokeWidth()) > 1.0) {
            d2 = d;
        }
        boolean bl2 = this.roi instanceof TextRoi;
        boolean bl3 = this.roi.isLine();
        if (bl2) {
            object = ((TextRoi)this.roi).getCurrentFont();
            d2 = ((Font)object).getSize();
        }
        Object object2 = object = color != null ? "#" + Integer.toHexString(color.getRGB()) : "none";
        if (((String)object).length() == 9 && ((String)object).startsWith("#ff")) {
            object = "#" + ((String)object).substring(3);
        }
        if ((string2 = Colors.hexToColor((String)object)) != null) {
            object = string2;
        }
        String string6 = string = color2 != null ? "#" + Integer.toHexString(color2.getRGB()) : "none";
        if (IJ.isMacro()) {
            string = "none";
        }
        int n = (double)((int)d2) == d2 ? 0 : 1;
        GenericDialog genericDialog = new GenericDialog(this.title);
        if (this.showName) {
            genericDialog.addStringField(string3, string4, 15);
        }
        genericDialog.addStringField("Stroke Color: ", (String)object);
        genericDialog.addNumericField(bl2 ? "Font Size" : "Width:", d2, n);
        if (!bl3) {
            genericDialog.addMessage("");
            genericDialog.addStringField("Fill Color: ", string);
        }
        if (this.showCheckbox) {
            genericDialog.addCheckbox("New Overlay", false);
            genericDialog.setInsets(15, 10, 0);
            genericDialog.addMessage("Use the alt-b shortcut\nto skip this dialog.");
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        if (this.showName) {
            string4 = genericDialog.getNextString();
            if (!bl) {
                this.roi.setName(string4.length() > 0 ? string4 : null);
            }
        }
        object = genericDialog.getNextString();
        d2 = genericDialog.getNextNumber();
        if (!bl3) {
            string = genericDialog.getNextString();
        }
        boolean bl4 = this.showCheckbox ? genericDialog.getNextBoolean() : false;
        color = Colors.decode((String)object, Roi.getColor());
        color2 = Colors.decode(string, null);
        if (bl2) {
            Font font = ((TextRoi)this.roi).getCurrentFont();
            if ((int)d2 != font.getSize()) {
                font = new Font(font.getName(), font.getStyle(), (int)d2);
                ((TextRoi)this.roi).setCurrentFont(font);
            }
        } else {
            this.roi.setStrokeWidth((float)d2);
        }
        this.roi.setStrokeColor(color);
        this.roi.setFillColor(color2);
        if (bl4) {
            this.roi.setName("new-overlay");
        }
        return true;
    }

    public boolean showImageDialog(String string) {
        boolean bl;
        GenericDialog genericDialog = new GenericDialog(this.title);
        genericDialog.addStringField("Name:", string, 15);
        genericDialog.addNumericField("Opacity (0-100%):", ((ImageRoi)this.roi).getOpacity() * 100.0, 0);
        if (this.showCheckbox) {
            genericDialog.addCheckbox("New Overlay", false);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        string = genericDialog.getNextString();
        this.roi.setName(string.length() > 0 ? string : null);
        double d = genericDialog.getNextNumber() / 100.0;
        ((ImageRoi)this.roi).setOpacity(d);
        boolean bl2 = bl = this.showCheckbox ? genericDialog.getNextBoolean() : false;
        if (bl) {
            this.roi.setName("new-overlay");
        }
        return true;
    }
}

