/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

class ByteVector {
    private byte[] data;
    private int size;

    public ByteVector() {
        this.data = new byte[10];
        this.size = 0;
    }

    public ByteVector(int n) {
        this.data = new byte[n];
        this.size = 0;
    }

    public ByteVector(byte[] byArray) {
        this.data = byArray;
        this.size = 0;
    }

    public void add(byte by) {
        if (this.size >= this.data.length) {
            this.doubleCapacity();
            this.add(by);
        } else {
            this.data[this.size++] = by;
        }
    }

    public int size() {
        return this.size;
    }

    public void add(byte[] byArray) {
        int n = byArray.length;
        while (this.data.length - this.size < n) {
            this.doubleCapacity();
        }
        System.arraycopy(byArray, 0, this.data, this.size, n);
        this.size += n;
    }

    void doubleCapacity() {
        byte[] byArray = new byte[this.data.length * 2 + 1];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }

    public void clear() {
        this.size = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.data, 0, byArray, 0, this.size);
        return byArray;
    }
}

