/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Duplicator
implements PlugIn,
TextListener {
    private static boolean duplicateStack;
    private boolean duplicateSubstack;
    private int first;
    private int last;
    private Checkbox checkbox;
    private TextField rangeField;

    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        int n = imagePlus.getStackSize();
        String string2 = imagePlus.getTitle();
        String string3 = WindowManager.getUniqueName(string2);
        if (!IJ.altKeyDown() || n > 1) {
            string3 = this.showDialog(imagePlus, "Duplicate...", "Title: ", string3);
        }
        if (string3 == null) {
            return;
        }
        Roi roi = imagePlus.getRoi();
        ImagePlus imagePlus2 = this.duplicateSubstack && (this.first > 1 || this.last < n) ? this.run(imagePlus, this.first, this.last) : (duplicateStack || imagePlus.getStackSize() == 1 ? this.run(imagePlus) : this.duplicateImage(imagePlus));
        imagePlus2.setTitle(string3);
        imagePlus2.show();
        if (roi != null && roi.isArea() && roi.getType() != 0) {
            imagePlus2.restoreRoi();
        }
    }

    public ImagePlus run(ImagePlus imagePlus) {
        Object object;
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp);");
        }
        if (imagePlus.getStackSize() == 1) {
            return this.duplicateImage(imagePlus);
        }
        Rectangle rectangle = null;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isArea()) {
            rectangle = roi.getBounds();
        }
        int n = rectangle != null ? rectangle.width : imagePlus.getWidth();
        int n2 = rectangle != null ? rectangle.height : imagePlus.getHeight();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(n, n2, imagePlus.getProcessor().getColorModel());
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            object = imageStack.getProcessor(i);
            ((ImageProcessor)object).setRoi(rectangle);
            object = ((ImageProcessor)object).crop();
            imageStack2.addSlice(imageStack.getSliceLabel(i), (ImageProcessor)object);
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack("DUP_" + imagePlus.getTitle(), imageStack2);
        object = imagePlus.getDimensions();
        imagePlus2.setDimensions((int)object[2], (int)object[3], (int)object[4]);
        if (imagePlus.isComposite()) {
            imagePlus2 = new CompositeImage(imagePlus2, 0);
            ((CompositeImage)imagePlus2).copyLuts(imagePlus);
        }
        if (imagePlus.isHyperStack()) {
            imagePlus2.setOpenAsHyperStack(true);
        }
        if (!imagePlus.getHideOverlay()) {
            imagePlus2.setOverlay(imagePlus.getOverlay());
        }
        return imagePlus2;
    }

    ImagePlus duplicateImage(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor().crop();
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setProcessor("DUP_" + imagePlus.getTitle(), imageProcessor);
        String string = (String)imagePlus.getProperty("Info");
        if (string != null) {
            imagePlus2.setProperty("Info", string);
        }
        if (imagePlus.getStackSize() > 1) {
            ImageStack imageStack = imagePlus.getStack();
            String string2 = imageStack.getSliceLabel(imagePlus.getCurrentSlice());
            if (string2 != null && string2.indexOf(10) > 0) {
                imagePlus2.setProperty("Info", string2);
            }
            if (imagePlus.isComposite()) {
                LUT lUT = ((CompositeImage)imagePlus).getChannelLut();
                imagePlus2.getProcessor().setColorModel(lUT);
            }
        }
        if (!imagePlus.getHideOverlay()) {
            imagePlus2.setOverlay(imagePlus.getOverlay());
        }
        return imagePlus2;
    }

    public ImagePlus run(ImagePlus imagePlus, int n, int n2) {
        boolean bl;
        Rectangle rectangle = null;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isArea()) {
            rectangle = roi.getBounds();
        }
        int n3 = rectangle != null ? rectangle.width : imagePlus.getWidth();
        int n4 = rectangle != null ? rectangle.height : imagePlus.getHeight();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(n3, n4, imagePlus.getProcessor().getColorModel());
        for (int i = n; i <= n2; ++i) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            imageProcessor.setRoi(rectangle);
            imageProcessor = imageProcessor.crop();
            imageStack2.addSlice(imageStack.getSliceLabel(i), imageProcessor);
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack("DUP_" + imagePlus.getTitle(), imageStack2);
        int n5 = imageStack2.getSize();
        boolean bl2 = bl = imagePlus.getNFrames() == imagePlus.getStackSize();
        if (bl) {
            imagePlus2.setDimensions(1, 1, n5);
        } else {
            imagePlus2.setDimensions(1, n5, 1);
        }
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp, " + n + ", " + n2 + ");");
        }
        return imagePlus2;
    }

    String showDialog(ImagePlus imagePlus, String string, String string2, String string3) {
        String[] stringArray;
        int n = imagePlus.getStackSize();
        this.duplicateSubstack = n > 1 && (n == imagePlus.getNSlices() || n == imagePlus.getNFrames());
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addStringField(string2, string3, this.duplicateSubstack ? 15 : 20);
        if (n > 1) {
            stringArray = this.duplicateSubstack ? "Duplicate Stack" : "Duplicate Entire Stack";
            genericDialog.addCheckbox((String)stringArray, duplicateStack || imagePlus.isComposite());
            if (this.duplicateSubstack) {
                genericDialog.setInsets(2, 30, 3);
                genericDialog.addStringField("Range:", "1-" + n);
                Vector vector = genericDialog.getStringFields();
                this.rangeField = (TextField)vector.elementAt(1);
                this.rangeField.addTextListener(this);
                this.checkbox = (Checkbox)genericDialog.getCheckboxes().elementAt(0);
            }
        } else {
            duplicateStack = false;
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        string = genericDialog.getNextString();
        if (n > 1) {
            duplicateStack = genericDialog.getNextBoolean();
            if (duplicateStack && this.duplicateSubstack) {
                stringArray = Tools.split(genericDialog.getNextString(), " -");
                double d = Tools.parseDouble(stringArray[0]);
                double d2 = stringArray.length == 2 ? Tools.parseDouble(stringArray[1]) : Double.NaN;
                this.first = Double.isNaN(d) ? 1 : (int)d;
                int n2 = this.last = Double.isNaN(d2) ? n : (int)d2;
                if (this.first < 1) {
                    this.first = 1;
                }
                if (this.last > n) {
                    this.last = n;
                }
                if (this.first > this.last) {
                    this.first = 1;
                    this.last = n;
                }
            } else {
                this.first = 1;
                this.last = n;
            }
        }
        return string;
    }

    public void textValueChanged(TextEvent textEvent) {
        this.checkbox.setState(true);
    }
}

