### R code from vignette source 'Rcell.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: Rcell.Rnw:19-20
###################################################
  if(!file.exists("fig")) dir.create("fig")  


###################################################
### code chunk number 2: foo
###################################################
options(keep.source = TRUE, width = 100)
foo <- packageDescription("Rcell")


###################################################
### code chunk number 3: library
###################################################
library(Rcell)


###################################################
### code chunk number 4: Rcell.Rnw:50-52 (eval = FALSE)
###################################################
## setwd("C:\\microscopy-data\\my-experiment")
## X<-load.cellID.data()


###################################################
### code chunk number 5: Rcell.Rnw:58-59 (eval = FALSE)
###################################################
## data(ACL394)


###################################################
### code chunk number 6: Rcell.Rnw:62-74
###################################################
data(ACL394data)
X$images$path<-factor(system.file('img', package='Rcell'))
X$data$QC<-rep(TRUE,times=dim(X$data)[1])
X$data<-subset(X$data,select=-c(time.min,f.total.y,n.tot,AF.nM))
X$QC.history<-list()
X$subset.history<-list()
X$transform<-list()
X$variables$transformed<-NULL
X$variables$merged<-NULL
X$variables$merged.by<-NULL
X$variables$as.factor<-c("pos","cellID","ucid")
X$variables$all<-setdiff(X$variables$all,c("time.min","f.total.y","n.tot","AF.nM"))


###################################################
### code chunk number 7: Rcell.Rnw:83-84
###################################################
summary(X)


###################################################
### code chunk number 8: Rcell.Rnw:87-88 (eval = FALSE)
###################################################
## help(ACL394)


###################################################
### code chunk number 9: Rcell.Rnw:91-92 (eval = FALSE)
###################################################
## vignette("Cell-ID-vars")


###################################################
### code chunk number 10: fig01
###################################################
cplot(X,f.tot.y~t.frame,subset=pos==1)


###################################################
### code chunk number 11: Rcell.Rnw:104-107
###################################################
print(
cplot(X,f.tot.y~t.frame,subset=pos==1)
)


###################################################
### code chunk number 12: fig02
###################################################
cplot(X,f.tot.y~t.frame,facets=~pos)


###################################################
### code chunk number 13: Rcell.Rnw:125-128
###################################################
print(
cplot(X,f.tot.y~t.frame,facets=~pos)+ facet_wrap(~pos,ncol=5)
)


###################################################
### code chunk number 14: Rcell.Rnw:142-144
###################################################
library(xtable)
print(xtable(pdata, table.placement = "tbp",caption.placement = "top",caption="example pdata.txt file",label="tab:t01"), include.rownames=FALSE)


###################################################
### code chunk number 15: Rcell.Rnw:147-148 (eval = FALSE)
###################################################
## X<-load.pdata(X)


###################################################
### code chunk number 16: Rcell.Rnw:150-151
###################################################
X<-merge(X,pdata,by="pos")


###################################################
### code chunk number 17: Rcell.Rnw:158-159
###################################################
X<-transform(X,f.total.y=f.tot.y-f.bg.y*a.tot)


###################################################
### code chunk number 18: Rcell.Rnw:166-167 (eval = FALSE)
###################################################
## vignette('transform')


###################################################
### code chunk number 19: fig03
###################################################
cplot(X,~fft.stat)


###################################################
### code chunk number 20: Rcell.Rnw:182-185
###################################################
print(
cplot(X,~fft.stat)
)


###################################################
### code chunk number 21: img4
###################################################
img4<-cimage(X,channel="BF.out",subset=fft.stat>0.5&t.frame==11&pos%in%c(1,8,15,22,29),bg.col="white")


###################################################
### code chunk number 22: Rcell.Rnw:198-199
###################################################
writeImage(img4, 'fig/Rcell-img4.jpg', quality=80)


###################################################
### code chunk number 23: Rcell.Rnw:212-213 (eval = FALSE)
###################################################
## vignette('cimage')


###################################################
### code chunk number 24: Rcell.Rnw:218-219
###################################################
X<-QC.filter(X,fft.stat<0.5)


###################################################
### code chunk number 25: Rcell.Rnw:224-226
###################################################
X<-update.n.tot(X)
X<-QC.filter(X,n.tot==14)


###################################################
### code chunk number 26: fig05a
###################################################
cplot(X,a.tot~fft.stat)


###################################################
### code chunk number 27: fig05b
###################################################
cplot(X,~a.tot)


###################################################
### code chunk number 28: Rcell.Rnw:246-254
###################################################
grid.newpage()
pushViewport(viewport(layout = grid.layout(1, 2)))
print(
cplot(X,a.tot~fft.stat)
, vp = viewport(layout.pos.row = 1, layout.pos.col = 1))
print(
cplot(X,~a.tot)
, vp = viewport(layout.pos.row = 1, layout.pos.col = 2))


###################################################
### code chunk number 29: fig06a
###################################################
cplotmean(X,f.total.y~t.frame,color=factor(AF.nM),yzoom=c(0,5.6e6))


###################################################
### code chunk number 30: fig06b
###################################################
cplot(X,f.tot.y~f.tot.c,color=factor(AF.nM),size=a.tot,alpha=0.5,subset=t.frame==13)


###################################################
### code chunk number 31: Rcell.Rnw:278-286
###################################################
grid.newpage()
pushViewport(viewport(layout = grid.layout(1, 2)))
print(
cplotmean(X,f.total.y~t.frame,color=factor(AF.nM),yzoom=c(0,5.6e6))
, vp = viewport(layout.pos.row = 1, layout.pos.col = 1))
print(
cplot(X,f.tot.y~f.tot.c,color=factor(AF.nM),size=a.tot,alpha=0.5,subset=t.frame==13)
, vp = viewport(layout.pos.row = 1, layout.pos.col = 2))


###################################################
### code chunk number 32: Rcell.Rnw:297-298 (eval = FALSE)
###################################################
## vignette('cplot')


