### R code from vignette source 'cimage.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: cimage.Rnw:18-19
###################################################
  if(!file.exists("fig")) dir.create("fig")  


###################################################
### code chunk number 2: foo
###################################################
options(keep.source = TRUE, width = 100)
foo <- packageDescription("Rcell")


###################################################
### code chunk number 3: cimage.Rnw:38-39 (eval = FALSE)
###################################################
## vignette('Rcell')


###################################################
### code chunk number 4: cimage.Rnw:44-46 (eval = FALSE)
###################################################
## library(EBImage)
## example(display)


###################################################
### code chunk number 5: cimage.Rnw:53-55 (eval = FALSE)
###################################################
## library(Rcell) 
## data(ACL394filtered)


###################################################
### code chunk number 6: cimage.Rnw:58-61
###################################################
library(Rcell)
data(ACL394data)
X$images$path<-factor(system.file('img', package='Rcell'))


###################################################
### code chunk number 7: img1
###################################################
img1<-cimage(X,subset=pos==29&t.frame==11,channel="BF",bg.col="white")


###################################################
### code chunk number 8: cimage.Rnw:72-73
###################################################
writeImage(img1, 'fig/cimage-img1.jpg', quality=80)


###################################################
### code chunk number 9: img2
###################################################
img2<-cimage(X,channel~t.frame,subset=pos==29&cellID==5,channel=c("BF","YFP"),bg.col="white")


###################################################
### code chunk number 10: cimage.Rnw:91-92
###################################################
writeImage(img2, 'fig/cimage-img2.jpg', quality=80)


###################################################
### code chunk number 11: img3
###################################################
img3<-cimage(X,...+channel~t.frame,subset=pos==29,channel=c("BF","YFP"),N=4,bg.col="white")


###################################################
### code chunk number 12: cimage.Rnw:109-110
###################################################
writeImage(img3, 'fig/cimage-img3.jpg', quality=80)


###################################################
### code chunk number 13: img4
###################################################
img4<-cimage(X,...~channel+t.frame,subset=pos==29,channel.subset=channel=="YFP"|(channel=="BF.out"&t.frame==11),N=4,bg.col="white")


###################################################
### code chunk number 14: cimage.Rnw:129-130
###################################################
writeImage(img4, 'fig/cimage-img4.jpg', quality=80)


###################################################
### code chunk number 15: img5
###################################################
img5<-cimage(X,...~channel,facets=~pos,subset=t.frame==11&pos%in%c(1,8,15,22,29),channel=c("YFP","BF"),bg.col="white",N=3,facets.nx=5)


###################################################
### code chunk number 16: cimage.Rnw:152-153
###################################################
writeImage(img5, 'fig/cimage-img5.jpg', quality=80)


###################################################
### code chunk number 17: cut
###################################################
X<-transform(X,cut.fft.stat=cut(fft.stat,20))
X<-transform(X,cut.f.tot.y=cut(f.tot.y,20))


###################################################
### code chunk number 18: img6
###################################################
img6<-cimage(X,cut.f.tot.y~cut.fft.stat,facets=~channel,subset=t.frame==11 & pos %in% c(1,8,15,22,29),channel=c("YFP","BF.out"),bg.col="white",N=1)


###################################################
### code chunk number 19: cimage.Rnw:180-181
###################################################
writeImage(img6, 'fig/cimage-img6.jpg', quality=80)


