### R code from vignette source 'SVGMapping-tutorial.Rnw'

###################################################
### code chunk number 1: SVGMapping-tutorial.Rnw:53-54
###################################################
library(SVGMapping)


###################################################
### code chunk number 2: SVGMapping-tutorial.Rnw:67-69
###################################################
data(yeastExprData)      # Expression data from geo:GSE7140 
data(yeastAnnotMatrix)   # Annotations from SGD 


###################################################
### code chunk number 3: SVGMapping-tutorial.Rnw:76-78
###################################################
TCAtemplate <- system.file("extdata/example.svg", package="SVGMapping")
mysvg <- loadSVG(TCAtemplate)


###################################################
### code chunk number 4: SVGMapping-tutorial.Rnw:90-96
###################################################
logratios <- yeastExprData[,1]    
foldchange <- ifelse(logratios>=0, 2^(logratios), -2^-logratios)
mapDataSVG(mysvg, 
           numData=logratios, 
           tooltipData=foldchange, 
           annotation=yeastAnnotMatrix)


###################################################
### code chunk number 5: SVGMapping-tutorial.Rnw:111-112
###################################################
saveSVG(mysvg, file="output1.svg")


###################################################
### code chunk number 6: SVGMapping-tutorial.Rnw:130-131 (eval = FALSE)
###################################################
## system.file("extdata/example.svg", package="SVGMapping")


###################################################
### code chunk number 7: SVGMapping-tutorial.Rnw:149-150
###################################################
yeastExprData[c("YKL085W","YPL262W"),1]


###################################################
### code chunk number 8: SVGMapping-tutorial.Rnw:178-179
###################################################
substring(yeastAnnotMatrix[1:3,], 0, 80)


###################################################
### code chunk number 9: SVGMapping-tutorial.Rnw:200-201 (eval = FALSE)
###################################################
## mysvg <- loadSVG(TCAtemplate)


###################################################
### code chunk number 10: SVGMapping-tutorial.Rnw:207-211 (eval = FALSE)
###################################################
## mapDataSVG(mysvg, 
##            numData=logratios,
##            tooltipData=foldchange,
##            annotation=yeastAnnotMatrix)


###################################################
### code chunk number 11: SVGMapping-tutorial.Rnw:217-224 (eval = FALSE)
###################################################
## reacdata <- c(mean(yeastExprData[c("YGL062W","YBR218C"),1]),
##                    yeastExprData["YKL085W",1],
##                    yeastExprData["YPL262W",1]
##               )
## names(reacdata) <- c("from-pyruvate", 
##                      "from-malate", 
##                      "from-fumarate")


###################################################
### code chunk number 12: SVGMapping-tutorial.Rnw:231-235 (eval = FALSE)
###################################################
## mapDataSVG(mysvg, 
##            numData=reacdata, mode="stroke",
##            tooltipData=NULL, 
##            col=microarrayColors[c((1:333),(666:1000))])


###################################################
### code chunk number 13: SVGMapping-tutorial.Rnw:241-242 (eval = FALSE)
###################################################
## saveSVG(mysvg, file="output3.svg")


###################################################
### code chunk number 14: SVGMapping-tutorial.Rnw:263-265 (eval = FALSE)
###################################################
## TCAtemplate2 <- system.file("extdata/example2.svg", package="SVGMapping")
## mysvg <- loadSVG(TCAtemplate2)


###################################################
### code chunk number 15: SVGMapping-tutorial.Rnw:271-273 (eval = FALSE)
###################################################
## mydata <- c(10, 25, 50)
## names(mydata) <- c("citrate", "cis-aconitate", "isocitrate")


###################################################
### code chunk number 16: SVGMapping-tutorial.Rnw:279-284 (eval = FALSE)
###################################################
## mapDataSVG(mysvg, 
##            numData=mydata, mode="fill", 
##            col=c("#FF0000","#00FF00","#0000FF"),
##            colrange=range(mydata), 
##            tooltipData=paste(mydata, "mmol/L"))


###################################################
### code chunk number 17: SVGMapping-tutorial.Rnw:292-295 (eval = FALSE)
###################################################
## mapDataSVG(mysvg, 
##            numData=mydata/100, mode="partial-fill")
## saveSVG(mysvg, file="output4.svg")


###################################################
### code chunk number 18: SVGMapping-tutorial.Rnw:338-339 (eval = FALSE)
###################################################
## mysvg <- loadSVG(TCAtemplate)


###################################################
### code chunk number 19: SVGMapping-tutorial.Rnw:345-347 (eval = FALSE)
###################################################
## logratios <- yeastExprData
## foldchange <- ifelse(logratios>=0, 2^(logratios), -2^-logratios)


###################################################
### code chunk number 20: SVGMapping-tutorial.Rnw:352-357 (eval = FALSE)
###################################################
## mapDataSVG(mysvg, 
##            numData=logratios, mode="pie",
##            tooltipData=foldchange,
##            annotation=yeastAnnotMatrix)
## saveSVG(mysvg, file="output2.svg")


###################################################
### code chunk number 21: SVGMapping-tutorial.Rnw:377-382 (eval = FALSE)
###################################################
## mysvg <- loadSVG(TCAtemplate2)
## mydata <- matrix(c(-2, -1.5, -1, -0.5, 2, 1.5, 1, 0.5), ncol=4, byrow=TRUE)
## rownames(mydata) <- c("malate", "fumarate")
## mapDataSVG(mysvg, mydata, mode="fill")
## saveSVG(mysvg, file="output5.svg")


###################################################
### code chunk number 22: SVGMapping-tutorial.Rnw:410-411 (eval = FALSE)
###################################################
## mysvg <- loadSVG(system.file("extdata/device-example.svg", package="SVGMapping"))


###################################################
### code chunk number 23: SVGMapping-tutorial.Rnw:421-422 (eval = FALSE)
###################################################
## devSVGMapping(mysvg, "@inkscape:label", "Rplot1") 


###################################################
### code chunk number 24: SVGMapping-tutorial.Rnw:431-433 (eval = FALSE)
###################################################
## heatmap(yeastExprData[1:30,], col=microarrayColors, labCol=NA, scale="none")
## dev.off()


###################################################
### code chunk number 25: SVGMapping-tutorial.Rnw:442-443 (eval = FALSE)
###################################################
## saveSVG(mysvg, "pdev-output1.svg")


###################################################
### code chunk number 26: SVGMapping-tutorial.Rnw:465-472
###################################################
## from: LadyofHats @Wikipedia -- copyleft
dna_svg <- "http://upload.wikimedia.org/wikipedia/commons/8/8f/DNA_replication_en.svg"

mysvg <- loadSVG(system.file("extdata/device-example.svg", package="SVGMapping"))
includeSVG(template=mysvg, file=dna_svg, 
           attribute.name="@inkscape:label", attribute.value="Rplot1")
saveSVG(mysvg, "pdev-output2.svg")


###################################################
### code chunk number 27: SVGMapping-tutorial.Rnw:487-510 (eval = FALSE)
###################################################
## mysvg <- loadSVG(system.file("extdata/example3.svg", package="SVGMapping"))
## 
## genes <- getLabelsSVG(mysvg)
## genes <- genes[grepl("^Y.+\\-plot$", genes)]
## genes <- sapply(strsplit(genes, "-", fixed=TRUE), function(x) x[[1]])
## 
## timeValues <- c(0, 5, 10, 20, 60, 120)
## for (gene in genes) {
##   devSVGMapping(mysvg, attribute.value=paste(gene, "-plot", sep=""), width=1.5, height=1)
##   par(mar=c(0, 0, 2, 0))
##   shortGeneName <- strsplit(yeastAnnotMatrix[gene,"name"], " ", fixed=TRUE)[[1]]
##   shortGeneName <- shortGeneName[[length(shortGeneName)]]
##   ylims <- 1.2
##   image(c(timeValues[1],timeValues[length(timeValues)]), seq(-ylims,ylims,length.out=21),
##         matrix(seq(-ylims,ylims,length.out=20), nrow=1), col=microarrayColors, main=shortGeneName)
##   points(timeValues, yeastExprData[gene,], type="o")
##   dev.off()
## }
## 
## logratios <- yeastExprData
## mapDataSVG(mysvg, logratios, tooltipData=ifelse(logratios>=0, 2^(logratios), -2^-logratios), mode="pie", annotation=yeastAnnotMatrix)
## 
## showSVG(mysvg)


###################################################
### code chunk number 28: SVGMapping-tutorial.Rnw:538-541 (eval = FALSE)
###################################################
## mysvg <- loadSVG(TCAtemplate2)
## mapDataSVG(mysvg, matrix(seq(-2,2,by=0.5), nrow=1, dimnames=list("malate", NULL)))
## showSVG(mysvg)


###################################################
### code chunk number 29: SVGMapping-tutorial.Rnw:556-560 (eval = FALSE)
###################################################
## mysvg <- loadSVG(TCAtemplate2)
## mapDataSVG(mysvg, matrix(seq(-2,2,by=0.5), nrow=1, dimnames=list("malate", NULL)),
##            col=substring(rainbow(1000), 0, 7))
## showSVG(mysvg)


###################################################
### code chunk number 30: SVGMapping-tutorial.Rnw:572-576 (eval = FALSE)
###################################################
## mysvg <- loadSVG(TCAtemplate2)
## mapDataSVG(mysvg, matrix(c(1,2,3,2,3,1,2), nrow=1, dimnames=list("malate", NULL)),
##            col=c("#CC0000", "#00CC00", "#0000CC"), colrange=c(1,3))
## showSVG(mysvg)


###################################################
### code chunk number 31: SVGMapping-tutorial.Rnw:585-605 (eval = FALSE)
###################################################
## mysvg <- loadSVG(TCAtemplate2)
## 
## stop1 <- newXMLNode("stop", attrs=list(offset=0, style="stop-color:red"))
## stop2 <- newXMLNode("stop", attrs=list(offset=1, style="stop-color:darkred"))
## gradient <- newXMLNode("radialGradient", attrs=list(id="redGradient"),
##                        .children=list(stop1,stop2))
## addDefinesSVG(mysvg, gradient)
## 
## stop1 <- newXMLNode("stop", attrs=list(offset=0, style="stop-color:lightgreen"))
## stop2 <- newXMLNode("stop", attrs=list(offset=1, style="stop-color:darkgreen"))
## gradient <- newXMLNode("radialGradient", attrs=list(id="greenGradient"),
##                        .children=list(stop1,stop2))
## addDefinesSVG(mysvg, gradient)
## 
## logratios <- yeastExprData[,1]
## # Here log-ratios are used for colors but fold-changes are displayed
## mapDataSVG(mysvg, logratios, tooltipData=ifelse(logratios>=0, 2^(logratios), -2^-logratios),
##            annotation=yeastAnnotMatrix, col=c("url(#greenGradient)", "url(#redGradient)"))
## 
## showSVG(mysvg)


###################################################
### code chunk number 32: SVGMapping-tutorial.Rnw:614-619 (eval = FALSE)
###################################################
## mysvg <- loadSVG(system.file("extdata/example.svg", package="SVGMapping"))
## setTextSVG(mysvg, "text3091", "Krebs cycle", searchAttribute="id")
## addLinkByLabelSVG(mysvg, "text3091", "http://en.wikipedia.org/wiki/TCA_cycle",
##                   searchAttribute="id")
## showSVG(mysvg)


