### R code from vignette source 'Guide.Stex'

###################################################
### code chunk number 1: Guide.Stex:10-11
###################################################
 options(continue="  ")


###################################################
### code chunk number 2: Guide.Stex:26-27
###################################################
library("TSMySQL")  


###################################################
### code chunk number 3: Guide.Stex:42-49
###################################################
   user    <- Sys.getenv("MYSQL_USER")
   if ("" != user) {
       host    <- Sys.getenv("MYSQL_HOST")
       if ("" == host)     host <- Sys.info()["nodename"] 
       passwd  <- Sys.getenv("MYSQL_PASSWD")
       if ("" == passwd)   passwd <- NULL
      }


###################################################
### code chunk number 4: Guide.Stex:57-63
###################################################
m <- dbDriver("MySQL")
con <-  if ("" == user) dbConnect(m, dbname="test") else
    dbConnect(m, dbname="test", username=user, password=passwd, host=host)

source(system.file("TSsql/CreateTables.TSsql", package = "TSdbi"))
dbDisconnect(con)


###################################################
### code chunk number 5: Guide.Stex:80-82
###################################################
con <-  if ("" == user) TSconnect("MySQL", dbname="test") else
    TSconnect("MySQL", dbname="test", username=user, password=passwd, host=host)


###################################################
### code chunk number 6: Guide.Stex:91-96
###################################################
 z <- ts(rnorm(10), start=c(1990,1), frequency=1)
 seriesNames(z) <- "vec"
 if(TSexists("vec", con)) TSdelete("vec", con) 
 TSput( z, con)
 z <- TSget("vec", con)


###################################################
### code chunk number 7: Guide.Stex:110-118
###################################################
 z <- ts(matrix(rnorm(20),10,2), start=c(1990,1), frequency=1)
 seriesNames(z) <- c("matc1", "matc2")
 TSreplace(z, con)
 TSget("matc1", con)
 TSget("matc2", con)
 TSget(c("matc1","matc2"), con)
 tfplot(z+1, TSget(c("matc1","matc2"), con), 
          lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 8: Guide.Stex:121-127
###################################################
 z <- ts(matrix(rnorm(20),10,2), start=c(1990,1), frequency=4)
  seriesNames(z) <- c("matc1", "matc2")
 TSreplace(z, con)
 TSget(c("matc1","matc2"), con)
 tfplot(z+1, TSget(c("matc1","matc2"), con),
          lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 9: Guide.Stex:130-135
###################################################
 z <- ts(matrix(rnorm(200),100,2), start=c(1995,1), frequency=12)
  seriesNames(z) <- c("mat2c1", "mat2c2")
 TSreplace(z, con)
 tfplot(z+1, TSget(c("mat2c1","mat2c2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 10: Guide.Stex:140-145
###################################################
 TSmeta("mat2c1", con)
 TSmeta("vec", con)
 TSdates("vec", con)
 TSdescription("vec", con)
 TSdoc("vec", con)


###################################################
### code chunk number 11: Guide.Stex:152-153
###################################################
 options(TSconnection=con)


###################################################
### code chunk number 12: Guide.Stex:159-161
###################################################
 z <- TSget("mat2c1") 
 TSmeta("mat2c1")


###################################################
### code chunk number 13: Guide.Stex:177-203
###################################################
 z <- ts(matrix(rnorm(10),10,1), start=c(1990,1), frequency=1)
 TSreplace(z, serIDs="Series1", con) 
 zz <- TSget("Series1", con)
 TSreplace(z, serIDs="Series1", con, 
     TSdescription="short rnorm series", 
     TSdoc="Series created as an example in the vignette.")
 zz <- TSget("Series1", con, TSdescription=TRUE, TSdoc=TRUE)
 start(zz)
 end(zz)
 TSdescription(zz)
 TSdoc(zz)

 TSdescription("Series1", con)
 TSdoc("Series1", con)

 z <- ts(rnorm(10), start=c(1990,1), frequency=1)
 seriesNames(z) <- "vec"
 TSreplace(z, con)
 zz <- TSget("vec", con)

 z <- ts(matrix(rnorm(20),10,2), start=c(1990,1), frequency=1)
 seriesNames(z) <- c("matc1", "matc2")
 TSreplace(z, con) 
 tfplot(z+1, TSget(c("matc1","matc2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))



###################################################
### code chunk number 14: Guide.Stex:206-212
###################################################
 z <- ts(matrix(rnorm(20),10,2), start=c(1990,1), frequency=4)
 seriesNames(z) <- c("matc1", "matc2")
 TSreplace(z, con)
 tfplot(z+1, TSget(c("matc1","matc2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))



###################################################
### code chunk number 15: Guide.Stex:215-220
###################################################
 z <- ts(matrix(rnorm(200),100,2), start=c(1995,1), frequency=12)
 seriesNames(z) <- c("mat2c1", "mat2c2")
 TSreplace(z, con) 
 tfplot(z+1, TSget(c("mat2c1","mat2c2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 16: Guide.Stex:226-234
###################################################
require("zoo") 

 z <- zoo(matrix(rnorm(200),100,2), as.Date("1990-01-01") + 0:99)
  seriesNames(z) <- c("zooc1", "zooc2")
 TSreplace(z, con, Table="D")
 tfplot(z+1, TSget(c("zooc1","zooc2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))
  


###################################################
### code chunk number 17: Guide.Stex:237-242
###################################################
 z <- zoo(matrix(rnorm(200),100,2), as.Date("1990-01-01") + 0:99 * 7)
  seriesNames(z) <- c("zooWc1", "zooWc2")
 TSreplace(z, con, Table="W")
 tfplot(z+1, TSget(c("zooWc1","zooWc2"), con), col=c("black", "red"),
    lty=c("dashed", "solid"))  


###################################################
### code chunk number 18: Guide.Stex:245-246
###################################################
 dbDisconnect(con)


###################################################
### code chunk number 19: Guide.Stex:260-262
###################################################
con <-  if ("" == user) TSconnect("MySQL", dbname="test") else
    TSconnect("MySQL", dbname="test", username=user, password=passwd, host=host)


###################################################
### code chunk number 20: Guide.Stex:267-277
###################################################
  require("TShistQuote")
  Yahoo <- TSconnect("histQuote", dbname="yahoo") 
  x <- TSget("^gspc", quote = "Close", con=Yahoo)
  plot(x)
  tfplot(x)

  TSrefperiod(x) 
  TSdescription(x) 
  TSdoc(x) 
  TSlabel(x) 


###################################################
### code chunk number 21: Guide.Stex:284-285
###################################################
   TSreplace(x,  serIDs="gspc", Table="B", con=con)


###################################################
### code chunk number 22: Guide.Stex:290-295
###################################################
  TSrefperiod(TSget(serIDs="gspc", con=con)) 
  TSdescription("gspc", con=con) 
  TSdoc("gspc", con=con)
  TSlabel("gspc", con=con) # this is not yet supported on the db
  tfplot(TSget(serIDs="gspc", con=con))


###################################################
### code chunk number 23: Guide.Stex:298-311
###################################################
   x <- TSget("ibm", quote = c("Close", "Vol"), con=Yahoo)
   TSreplace(x, serIDs=c("ibm.Cl", "ibm.Vol"),  con=con, Table="B",
              TSdescription.=c("IBM Close","IBM  Volume"),
	      TSdoc.= paste(c(
	         "IBM  Close   retrieved on ",
		 "IBM  Volume retrieved  on "), Sys.Date()))

   z <- TSget(serIDs=c("ibm.Cl", "ibm.Vol"), 
             TSdescription=TRUE, TSdoc=TRUE, con=con)
   TSdescription(z)
   TSdoc(z)
   tfplot(z, xlab = TSdoc(z), Title = TSdescription(z))
   tfplot(z, Title="IBM", start="2007-01-01")


###################################################
### code chunk number 24: Guide.Stex:317-320
###################################################
   Oanda <- TSconnect("histQuote", dbname="oanda") 
   x <- TSget("EUR/USD", start=Sys.Date() - 495, con=Oanda)
   TSreplace(x, serIDs="EUR/USD", Table="D", con=con)


###################################################
### code chunk number 25: Guide.Stex:325-331
###################################################
   z <- TSget(serIDs="EUR/USD",TSlabel=TRUE, TSdescription=TRUE,  con=con)
   tfplot(z, Title = TSdescription(z), ylab=TSlabel(z))
   tfplot(z, Title = "EUR/USD", start="2007-01-01")
   tfplot(z, Title = "EUR/USD", start="2007-03-01")
   tfplot(z, Title = "EUR/USD", start=Sys.Date()-14, end=Sys.Date(),
      xlab = format(Sys.Date(), "%Y"))


###################################################
### code chunk number 26: Guide.Stex:334-337
###################################################
  dbDisconnect(con)
  dbDisconnect(Yahoo)
  dbDisconnect(Oanda)


###################################################
### code chunk number 27: Guide.Stex:356-383
###################################################
  m <- dbDriver("MySQL")
  conets <-  try(if ("" == user) TSconnect(m, dbname="ets") else
    TSconnect(m, dbname="ets", username=user, password=passwd, host=host))
  if (!inherits(conets, "try-error")) {
  
  options(TSconnection=conets)

  print(TSmeta("M.SDR.CCUSMA02.ST"))

  EXCH.IDs <- t(matrix(c(
 	"M.SDR.CCUSMA02.ST",	 "SDR/USD exchange rate",
 	"M.CAN.CCUSMA02.ST",	 "CAN/USD exchange rate",
 	"M.MEX.CCUSMA02.ST",	 "MEX/USD exchange rate",
 	"M.JPN.CCUSMA02.ST",	 "JPN/USD exchange rate",
 	"M.EMU.CCUSMA02.ST",	 "Euro/USD exchange rate",
 	"M.OTO.CCUSMA02.ST",	 "OECD /USD exchange rate",
 	"M.G7M.CCUSMA02.ST",	 "G7   /USD exchange rate",
 	"M.E15.CCUSMA02.ST",	 "Euro 15. /USD exchange rate"
	), 2, 8))

  print(TSdates(EXCH.IDs[,1]))
  z <- TSdates(EXCH.IDs[,1])
  print(start(z))
  print(end(z))
   
  tfplot(TSget(serIDs="V122646", conets))
  }


###################################################
### code chunk number 28: Guide.Stex:386-395
###################################################
if (!inherits(conets, "try-error")) {
  print(TSdescription(TSget("V122646", TSdescription=TRUE)))
  print(TSdescription("V122646"))

  print(TSdoc(TSget("V122646", TSdoc=TRUE)))
  print(TSdoc("V122646"))

  tfplot(TSget("V122646", names="V122646", conets))
  }


###################################################
### code chunk number 29: Guide.Stex:398-402
###################################################
if (!inherits(conets, "try-error")) {
  z <- TSget("V122646", TSdescription=TRUE)
  tfplot(z, Title=strsplit(TSdescription(z), ","))
  }


###################################################
### code chunk number 30: Guide.Stex:405-410
###################################################
if (!inherits(conets, "try-error")) {
  z <- TSget("SDSP500", TSdescription=TRUE)
  tfplot(z, Title=TSdescription(z))
  plot(z)
  }


###################################################
### code chunk number 31: Guide.Stex:413-417
###################################################
if (!inherits(conets, "try-error")) {
  z <- TSget(c("DSP500","SDSP500"), TSdescription=TRUE)
  tfplot(z, xlab=TSdescription(z))
  }


###################################################
### code chunk number 32: Guide.Stex:420-423
###################################################
if (!inherits(conets, "try-error")) {
  plot(z)
  }


###################################################
### code chunk number 33: Guide.Stex:426-431
###################################################
if (!inherits(conets, "try-error")) {
  ETSgdp    <- annualizedGrowth(aggregate(TSget("V1992067"),
                   nfrequency=4,FUN=mean), lag=4, names="GDP Y/Y Growth")
  tfplot(ETSgdp)
  }  # end if !try-error


###################################################
### code chunk number 34: Guide.Stex:434-439
###################################################
  if (!inherits(conets, "try-error")) {
  #dbDisconnect(conets)
  dbDisconnect(options()$TSconnection)
  options(TSconnection=NULL)
  }  # end if !try-error


###################################################
### code chunk number 35: Guide.Stex:448-452
###################################################
 m <- dbDriver("MySQL")
 con <-  if ("" == user) TSconnect(m, dbname="test") else
    TSconnect(m, dbname="test", username=user, password=passwd, host=host)
 options(TSconnection=con)


###################################################
### code chunk number 36: Guide.Stex:456-457
###################################################
dbListTables(con)


###################################################
### code chunk number 37: Guide.Stex:463-473
###################################################
 dbGetQuery(con, "show tables;")
 dbGetQuery(con, "describe A;")
 dbGetQuery(con, "describe B;")
 dbGetQuery(con, "describe D;")
 dbGetQuery(con, "describe M;")
 dbGetQuery(con, "describe Meta;")
 dbGetQuery(con, "describe U;")
 dbGetQuery(con, "describe Q;")
 dbGetQuery(con, "describe S;")
 dbGetQuery(con, "describe W;")


###################################################
### code chunk number 38: Guide.Stex:482-498
###################################################
z <-  try( dbGetQuery(con, paste(
       "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.Columns ",
       " WHERE TABLE_SCHEMA='test' AND table_name='A' ;"))  )
if (!inherits( z, "try-error")) print(z)

z <-  try( dbGetQuery(con, paste(
       "SELECT COLUMN_NAME, COLUMN_DEFAULT, COLLATION_NAME, DATA_TYPE,",
       "CHARACTER_SET_NAME, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION",
 "FROM INFORMATION_SCHEMA.Columns WHERE TABLE_SCHEMA='test' AND table_name='A' ;"))  )
if (!inherits( z, "try-error")) print(z)

z <-  try( dbGetQuery(con, paste(
   "SELECT COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION",
 "FROM INFORMATION_SCHEMA.Columns WHERE TABLE_SCHEMA='test' AND table_name='M';"))  )
if (!inherits( z, "try-error")) print(z)



###################################################
### code chunk number 39: Guide.Stex:503-509
###################################################

dbDisconnect(con)

dbDisconnect(options()$TSconnection)
options(TSconnection=NULL)
#dbUnloadDriver(m)


