### R code from vignette source 'Guide.Stex'

###################################################
### code chunk number 1: Guide.Stex:10-11
###################################################
 options(continue="  ")


###################################################
### code chunk number 2: Guide.Stex:31-32
###################################################
library("TSSQLite")  


###################################################
### code chunk number 3: Guide.Stex:43-47
###################################################
m <- dbDriver("SQLite")
con <- dbConnect(m, dbname="test") 
source(system.file("TSsql/CreateTables.TSsql", package = "TSdbi"))
dbDisconnect(con)


###################################################
### code chunk number 4: Guide.Stex:64-66
###################################################
 m <- dbDriver("SQLite")
 con <- TSconnect(m, dbname="test") 


###################################################
### code chunk number 5: Guide.Stex:75-80
###################################################
 z <- ts(rnorm(10), start=c(1990,1), frequency=1)
 seriesNames(z) <- "vec"
 if(TSexists("vec", con)) TSdelete("vec", con) 
 TSput( z, con)
 z <- TSget("vec", con)


###################################################
### code chunk number 6: Guide.Stex:94-102
###################################################
 z <- ts(matrix(rnorm(20),10,2), start=c(1990,1), frequency=1)
 seriesNames(z) <- c("matc1", "matc2")
 TSreplace(z, con)
 TSget("matc1", con)
 TSget("matc2", con)
 TSget(c("matc1","matc2"), con)
 tfplot(z+1, TSget(c("matc1","matc2"), con), 
          lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 7: Guide.Stex:105-111
###################################################
 z <- ts(matrix(rnorm(20),10,2), start=c(1990,1), frequency=4)
  seriesNames(z) <- c("matc1", "matc2")
 TSreplace(z, con)
 TSget(c("matc1","matc2"), con)
 tfplot(z+1, TSget(c("matc1","matc2"), con),
          lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 8: Guide.Stex:114-119
###################################################
 z <- ts(matrix(rnorm(200),100,2), start=c(1995,1), frequency=12)
  seriesNames(z) <- c("mat2c1", "mat2c2")
 TSreplace(z, con)
 tfplot(z+1, TSget(c("mat2c1","mat2c2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 9: Guide.Stex:124-129
###################################################
 TSmeta("mat2c1", con)
 TSmeta("vec", con)
 TSdates("vec", con)
 TSdescription("vec", con)
 TSdoc("vec", con)


###################################################
### code chunk number 10: Guide.Stex:136-137
###################################################
 options(TSconnection=con)


###################################################
### code chunk number 11: Guide.Stex:143-145
###################################################
 z <- TSget("mat2c1") 
 TSmeta("mat2c1")


###################################################
### code chunk number 12: Guide.Stex:161-187
###################################################
 z <- ts(matrix(rnorm(10),10,1), start=c(1990,1), frequency=1)
 TSreplace(z, serIDs="Series1", con) 
 zz <- TSget("Series1", con)
 TSreplace(z, serIDs="Series1", con, 
     TSdescription="short rnorm series", 
     TSdoc="Series created as an example in the vignette.")
 zz <- TSget("Series1", con, TSdescription=TRUE, TSdoc=TRUE)
 start(zz)
 end(zz)
 TSdescription(zz)
 TSdoc(zz)

 TSdescription("Series1", con)
 TSdoc("Series1", con)

 z <- ts(rnorm(10), start=c(1990,1), frequency=1)
 seriesNames(z) <- "vec"
 TSreplace(z, con)
 zz <- TSget("vec", con)

 z <- ts(matrix(rnorm(20),10,2), start=c(1990,1), frequency=1)
 seriesNames(z) <- c("matc1", "matc2")
 TSreplace(z, con) 
 tfplot(z+1, TSget(c("matc1","matc2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))



###################################################
### code chunk number 13: Guide.Stex:190-196
###################################################
 z <- ts(matrix(rnorm(20),10,2), start=c(1990,1), frequency=4)
 seriesNames(z) <- c("matc1", "matc2")
 TSreplace(z, con)
 tfplot(z+1, TSget(c("matc1","matc2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))



###################################################
### code chunk number 14: Guide.Stex:199-204
###################################################
 z <- ts(matrix(rnorm(200),100,2), start=c(1995,1), frequency=12)
 seriesNames(z) <- c("mat2c1", "mat2c2")
 TSreplace(z, con) 
 tfplot(z+1, TSget(c("mat2c1","mat2c2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 15: Guide.Stex:210-218
###################################################
require("zoo") 

 z <- zoo(matrix(rnorm(200),100,2), as.Date("1990-01-01") + 0:99)
  seriesNames(z) <- c("zooc1", "zooc2")
 TSreplace(z, con, Table="D")
 tfplot(z+1, TSget(c("zooc1","zooc2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))
  


###################################################
### code chunk number 16: Guide.Stex:221-226
###################################################
 z <- zoo(matrix(rnorm(200),100,2), as.Date("1990-01-01") + 0:99 * 7)
  seriesNames(z) <- c("zooWc1", "zooWc2")
 TSreplace(z, con, Table="W")
 tfplot(z+1, TSget(c("zooWc1","zooWc2"), con), col=c("black", "red"),
    lty=c("dashed", "solid"))  


###################################################
### code chunk number 17: Guide.Stex:229-231
###################################################
 dbDisconnect(con)
 #dbUnloadDriver(m)


###################################################
### code chunk number 18: Guide.Stex:245-246
###################################################
con <- TSconnect("SQLite", dbname="test")


###################################################
### code chunk number 19: Guide.Stex:251-261
###################################################
  require("TShistQuote")
  Yahoo <- TSconnect("histQuote", dbname="yahoo") 
  x <- TSget("^gspc", quote = "Close", con=Yahoo)
  plot(x)
  tfplot(x)

  TSrefperiod(x) 
  TSdescription(x) 
  TSdoc(x) 
  TSlabel(x) 


###################################################
### code chunk number 20: Guide.Stex:268-269
###################################################
   TSreplace(x,  serIDs="gspc", Table="B", con=con)


###################################################
### code chunk number 21: Guide.Stex:274-279
###################################################
  TSrefperiod(TSget(serIDs="gspc", con=con)) 
  TSdescription("gspc", con=con) 
  TSdoc("gspc", con=con)
  TSlabel("gspc", con=con) # this is not yet supported on the db
  tfplot(TSget(serIDs="gspc", con=con))


###################################################
### code chunk number 22: Guide.Stex:282-295
###################################################
   x <- TSget("ibm", quote = c("Close", "Vol"), con=Yahoo)
   TSreplace(x, serIDs=c("ibm.Cl", "ibm.Vol"),  con=con, Table="B",
              TSdescription.=c("IBM Close","IBM  Volume"),
	      TSdoc.= paste(c(
	         "IBM  Close   retrieved on ",
		 "IBM  Volume retrieved  on "), Sys.Date()))

   z <- TSget(serIDs=c("ibm.Cl", "ibm.Vol"), 
             TSdescription=TRUE, TSdoc=TRUE, con=con)
   TSdescription(z)
   TSdoc(z)
   tfplot(z, xlab = TSdoc(z), Title = TSdescription(z))
   tfplot(z, Title="IBM", start="2007-01-01")


###################################################
### code chunk number 23: Guide.Stex:301-304
###################################################
   Oanda <- TSconnect("histQuote", dbname="oanda") 
   x <- TSget("EUR/USD", start=Sys.Date() - 495, con=Oanda)
   TSreplace(x, serIDs="EUR/USD", Table="D", con=con)


###################################################
### code chunk number 24: Guide.Stex:309-315
###################################################
   z <- TSget(serIDs="EUR/USD",TSlabel=TRUE, TSdescription=TRUE,  con=con)
   tfplot(z, Title = TSdescription(z), ylab=TSlabel(z))
   tfplot(z, Title = "EUR/USD", start="2007-01-01")
   tfplot(z, Title = "EUR/USD", start="2007-03-01")
   tfplot(z, Title = "EUR/USD", start=Sys.Date()-14, end=Sys.Date(),
      xlab = format(Sys.Date(), "%Y"))


###################################################
### code chunk number 25: Guide.Stex:318-321
###################################################
  dbDisconnect(con)
  dbDisconnect(Yahoo)
  dbDisconnect(Oanda)


###################################################
### code chunk number 26: Guide.Stex:337-340
###################################################
 m <- dbDriver("SQLite")
 con <- TSconnect(m, dbname="test") 
 options(TSconnection=con)


###################################################
### code chunk number 27: Guide.Stex:344-345
###################################################
dbListTables(con)


###################################################
### code chunk number 28: Guide.Stex:354-367
###################################################
  try( dbGetQuery(con, paste(
       "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.Columns ",
       " WHERE TABLE_SCHEMA='test' AND table_name='A' ;"))  )

  try( dbGetQuery(con, paste(
       "SELECT COLUMN_NAME, COLUMN_DEFAULT, COLLATION_NAME, DATA_TYPE,",
       "CHARACTER_SET_NAME, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION",
 "FROM INFORMATION_SCHEMA.Columns WHERE TABLE_SCHEMA='test' AND table_name='A' ;"))  )

  try( dbGetQuery(con, paste(
   "SELECT COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION",
 "FROM INFORMATION_SCHEMA.Columns WHERE TABLE_SCHEMA='test' AND table_name='M';"))  )



###################################################
### code chunk number 29: Guide.Stex:372-375
###################################################
dbDisconnect(options()$TSconnection)
options(TSconnection=NULL)
#dbUnloadDriver(m)


