### R code from vignette source 'Guide.Stex'

###################################################
### code chunk number 1: Guide.Stex:10-11
###################################################
 options(continue="  ")


###################################################
### code chunk number 2: Guide.Stex:23-24
###################################################
library("TSxls")  


###################################################
### code chunk number 3: Guide.Stex:40-49
###################################################
  con <- TSconnect("xls",
          dbname="http://www.rba.gov.au/statistics/tables/xls/d03hist.xls",
          map=list(ids  =list(i=11,     j="B:Q"), 
	           data =list(i=12:627, j="B:Q"), 
	           dates=list(i=12:627, j="A"),
                   names=list(i=4:7,    j="B:Q"), 
		   description = NULL,
		   tsrepresentation = function(data,dates){
		       ts(data,start=c(1959,7), frequency=12)}))


###################################################
### code chunk number 4: Guide.Stex:57-63
###################################################
  x <- TSget("DMACN", con)
  tfplot(x)

  x <- TSget(c("DMAM1N", "DMAM3N"), con)
  tfplot(x)
  TSdescription(x) 


###################################################
### code chunk number 5: Guide.Stex:68-70
###################################################
  options(TSconnection=con)
  tfplot(TSget(serIDs="DMAM1N"))


###################################################
### code chunk number 6: Guide.Stex:75-79
###################################################
  x2 <- TSget("DMAM3N")
  tfplot(x2)
  plot(x2)
  TSdescription(x2) 


###################################################
### code chunk number 7: Guide.Stex:82-87
###################################################
  x <- TSget("DMAM1N")
  tfplot(x)
  tfplot(x, xlab = TSdescription(x))
  tfplot(x, Title="Australia M1", start=c(2000,1))
  tfplot(x, Title=TSdoc(x), xlab = TSlabel(x), start=c(2000,1))


###################################################
### code chunk number 8: Guide.Stex:93-97
###################################################
  x <- TSget(c("DMAM1N", "DMAM3N", "DMABMN","DMAM1S","DMAM3S","DMABMS"))
  plot(x)
  tfplot(x, Title="Australian Monetary Aggregates", graphs.per.page=3)
  TSdescription(x) 


###################################################
### code chunk number 9: Guide.Stex:102-105
###################################################
  tfplot(TSget(c("DMAM1S", "DMAM3S", "DMABMS")),
         TSget(c("DMAM1N", "DMAM3N", "DMABMN")),
    Title="Australian Monetary Aggregates")


###################################################
### code chunk number 10: Guide.Stex:109-116
###################################################
  tfplot(TSget("DMAM1S"),
         TSget("DMAM3S"),
         TSget("DMABMS"),
	 TSget("DMAM1N"),
         TSget("DMAM3N"),
         TSget("DMABMN"),
    Title="Australian Monetary Aggregates")


###################################################
### code chunk number 11: Guide.Stex:119-120
###################################################
  TSdates(c("DMAM1N", "DMAM3N"), con) 


