### R code from vignette source 'abn.Rnw'

###################################################
### code chunk number 1: abn.Rnw:68-94
###################################################
library(abn);# load library
bin.nodes<-c(1,3,4,6,9,10,11,12,15,18,19,20,21,26,27,28,32); 
var33.cat<-var33[,bin.nodes];#categorical nodes only
mydag<-matrix(c(
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v1
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v3
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v4  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v6  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v9  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v10  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v11  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v12  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v15  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v18 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v19
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v20 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v21 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v26 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v27 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v28 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  #v32 
              ),byrow=TRUE,ncol=17); 
colnames(mydag)<-rownames(mydag)<-names(var33.cat);#set names
## now fit the model defined in mydag - full independence model
fitbn (data.df=var33.cat, dag.m=mydag,useK2=TRUE);
# this is the network score goodness of fit = log marginal likelihood


###################################################
### code chunk number 2: abn.Rnw:97-105
###################################################
# now fit model with some conditional dependencies let v11 
## depend jointly on v12 and v10
mydag["v11","v12"]<-1;
mydag["v11","v10"]<-1;
## let v4 depend on v3
mydag["v4","v3"]<-1;
fitbn (data.df=var33.cat, dag.m=mydag,useK2=TRUE);
# network score for a model with conditional independence


###################################################
### code chunk number 3: abn.Rnw:108-111
###################################################
tographviz(dag=mydag,data.df=var33.cat,outfile="mydag.dot");#create file
# mydag.dot can then be processed with graphviz
# unix shell "dot -Tpdf mydag.dot -o mydag.pdf" or use gedit if on Windows


###################################################
### code chunk number 4: abn.Rnw:125-132
###################################################
## move back to independence model
mydag["v11","v12"]<-0;mydag["v11","v10"]<-0;mydag["v4","v3"]<-0;
fitabn (data.df=var33.cat,dag.m=mydag,verbose=TRUE);
# now fit the model with some conditional dependencies 
mydag["v11","v12"]<-1;mydag["v11","v10"]<-1;mydag["v4","v3"]<-1;
fitabn (data.df=var33.cat, dag.m=mydag,verbose=TRUE);
# network score for a model with conditional independence


###################################################
### code chunk number 5: abn.Rnw:137-161
###################################################
var33.cts<-var33[,-bin.nodes];#drop categorical nodes
mydag<-matrix(c(
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v2
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v5  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v7  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v8 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v13  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v14  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v16  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v17  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v22 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v23
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v24 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v25 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v29 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v30 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v31 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  #v33 
              ),byrow=TRUE,ncol=16); 
colnames(mydag)<-rownames(mydag)<-names(var33.cts);#set names
## now fit the model defined in mydag - full independence
fitabn (data.df=var33.cts,dag.m=mydag,verbose=TRUE);
## uses default priors of N(mu=0,var=1000), 1/var=Gamma(0.001,1/0.001)
# this is the network score goodness of fit = log marginal likelihood


###################################################
### code chunk number 6: abn.Rnw:164-174
###################################################
# now fit model with some conditional dependencies let v33 
## depend on v31, and v24 depend on 23, and v14 depend on v13
mydag["v33","v31"]<-1;
mydag["v24","v23"]<-1;
mydag["v14","v13"]<-1;
fitabn (data.df=var33.cts, dag.m=mydag,verbose=TRUE);
# network score for a model with conditional independence
tographviz(dag=mydag,data.df=var33.cts,outfile="mydagcts.dot");#create file
# mydag.dot can then be processed with graphviz
# unix shell "dot -Tpdf mydagcts.dot -o mydagcts.pdf" or use gedit if on Windows


###################################################
### code chunk number 7: abn.Rnw:185-223
###################################################
mydag<-matrix(c(
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#1
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#2  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#3  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#4  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#5  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#6  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#7  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#8  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#9  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#10 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#11 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#12 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#13 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#14 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#15 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#16 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#17 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#18 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#19 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#20 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#21 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#22 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#23 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#24 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#25 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#26 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#27 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#28 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#29 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#30
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#31
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#32 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 #33
                                               ),byrow=TRUE,ncol=33); 
colnames(mydag)<-rownames(mydag)<-names(var33);#set names
## now fit the model defined in mydag - full independence
fitabn (data.df=var33,dag.m=mydag,verbose=TRUE);


###################################################
### code chunk number 8: abn.Rnw:226-256
###################################################
# define a model with many independencies
mydag[2,1]<-1;
mydag[4,3]<-1;
mydag[6,4]<-1; mydag[6,7]<-1;
mydag[5,6]<-1;
mydag[7,8]<-1;  
mydag[8,9]<-1;
mydag[9,10]<-1;
mydag[11,10]<-1; mydag[11,12]<-1; mydag[11,19]<-1;
mydag[14,13]<-1;
mydag[17,16]<-1;mydag[17,20]<-1;
mydag[15,14]<-1; mydag[15,21]<-1;
mydag[18,20]<-1;
mydag[19,20]<-1;
mydag[21,20]<-1;
mydag[22,21]<-1;
mydag[23,21]<-1;
mydag[24,23]<-1;
mydag[25,23]<-1; mydag[25,26]<-1;
mydag[26,20]<-1;
mydag[33,31]<-1;
mydag[33,31]<-1;
mydag[32,21]<-1; mydag[32,31]<-1;mydag[32,29]<-1;    
mydag[30,29]<-1;
mydag[28,27]<-1; mydag[28,29]<-1;mydag[28,31]<-1;       
fitabn (data.df=var33, dag.m=mydag);
# network score for a model with conditional independence
tographviz(dag=mydag,data.df=var33,outfile="mydag_all.dot");#create file
# mydag.dot can then be processed with graphviz
# unix shell "dot -Tpdf mydag_all.dot -o mydag_all.pdf" or use gedit if on Windows


###################################################
### code chunk number 9: abn.Rnw:275-309 (eval = FALSE)
###################################################
## bin.nodes<-c(1,3,4,6,9,10,11,12,15,18,19,20,21,26,27,28,32); 
## var33.cat<-var33[,bin.nodes];#categorical nodes only
## mydag<-matrix(c(
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v1
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v3
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v4  
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v6  
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v9  
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v10  
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v11  
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v12  
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v15  
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v18 
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v19
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v20 
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v21 
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v26 
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v27 
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v28 
##                  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  #v32 
##               ),byrow=TRUE,ncol=17); 
## colnames(mydag)<-rownames(mydag)<-names(var33.cat);#set names
## ## create empty DAGs
## banned.cat<-matrix(rep(0,dim(var33.cat)[2]^2),ncol=dim(var33.cat)[2]);
## colnames(banned.cat)<-rownames(banned.cat)<-names(var33.cat);#set names
## retain.cat<-matrix(rep(0,dim(var33.cat)[2]^2),ncol=dim(var33.cat)[2]);
## colnames(retain.cat)<-rownames(retain.cat)<-names(var33.cat);#set names
## start.cat<-matrix(rep(0,dim(var33.cat)[2]^2),ncol=dim(var33.cat)[2]);
## colnames(start.cat)<-rownames(start.cat)<-names(var33.cat);#set names
## myres<-searchbn(data.df=var33.cat,
##                 banned.m=banned.cat,
##                 retain.m=retain.cat,
##                 start.m=start.cat,
##                 useK2=TRUE,max.parents=2,init.permuts=0,db.size=1000);


###################################################
### code chunk number 10: abn.Rnw:315-322 (eval = FALSE)
###################################################
## ## just use default priors 
## myres.add<-searchabn(data.df=var33.cat,
##                  banned.m=banned.cat,
##                  retain.m=retain.cat,
##                  start.m=start.cat,
##                  max.parents=2, 
##                  init.permuts=0,db.size=1000,error.verbose=TRUE);


###################################################
### code chunk number 11: abn.Rnw:327-360
###################################################
var33.cts<-var33[,-bin.nodes];#drop categorical nodes
mydag<-matrix(c(
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v2
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v5  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v7  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v8 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v13  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v14  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v16  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v17  
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v22 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v23
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v24 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v25 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v29 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v30 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, #v31 
                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  #v33 
              ),byrow=TRUE,ncol=16); 
colnames(mydag)<-rownames(mydag)<-names(var33.cts);#set names
banned.cts<-matrix(rep(0,dim(var33.cts)[2]^2),ncol=dim(var33.cts)[2]);
colnames(banned.cts)<-rownames(banned.cts)<-names(var33.cts);#set names
retain.cts<-matrix(rep(0,dim(var33.cts)[2]^2),ncol=dim(var33.cts)[2]);
colnames(retain.cts)<-rownames(retain.cts)<-names(var33.cts);#set names
start.cts<-matrix(rep(0,dim(var33.cts)[2]^2),ncol=dim(var33.cts)[2]);
colnames(start.cts)<-rownames(start.cts)<-names(var33.cts);#set names
#
myres.add<-searchabn(data.df=var33.cts,
                 banned.m=banned.cts,
                 retain.m=retain.cts,
                 start.m=start.cts,
                 max.parents=2, 
                 init.permuts=0,db.size=1000,error.verbose=TRUE);


###################################################
### code chunk number 12: abn.Rnw:366-424 (eval = FALSE)
###################################################
## mydag<-matrix(c(
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#1
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#2  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#3  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#4  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#5  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#6  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#7  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#8  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#9  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#10 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#11 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#12 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#13 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#14 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#15 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#16 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#17 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#18 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#19 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#20 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#21 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#22 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#23 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#24 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#25 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#26 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#27 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#28 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#29 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#30
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#31
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#32 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 #33
##                                                ),byrow=TRUE,ncol=33); 
## colnames(mydag)<-rownames(mydag)<-names(var33);#set names
## ## create empty DAGs
## banned<-matrix(rep(0,dim(var33)[2]^2),ncol=dim(var33)[2]);
## colnames(banned)<-rownames(banned)<-names(var33);#set names
## retain<-matrix(rep(0,dim(var33)[2]^2),ncol=dim(var33)[2]);
## colnames(retain)<-rownames(retain)<-names(var33);#set names
## start<-matrix(rep(0,dim(var33)[2]^2),ncol=dim(var33)[2]);
## colnames(start)<-rownames(start)<-names(var33);#set names
## 
## ## giving diffuse priors - same as default but explicitly stated
## myres.add<-searchabn(data.df=var33,
##                  banned.m=banned,
##                  retain.m=retain,
##                  start.m=start,
##                  hyper.params=list(
##                                    mean=rep(0,dim(var33)[2]+1),
##                                    sd=rep(sqrt(1000),dim(var33)[2]+1), 
##                                    shape=rep(0.001,16),## 16 Gaussian nodes
##                                    scale=rep(1/0.001,16)## 16 Gaussian nodes
##                  ),
##                  max.parents=2, 
##                  init.permuts=0,db.size=10000,
##                  error.verbose=TRUE,enforce.db.size=TRUE);


###################################################
### code chunk number 13: abn.Rnw:434-495 (eval = FALSE)
###################################################
## mydag<-matrix(c(
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#1
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#2  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#3  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#4  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#5  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#6  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#7  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#8  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#9  
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#10 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#11 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#12 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#13 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#14 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#15 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#16 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#17 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#18 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#19 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#20 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#21 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#22 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#23 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#24 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#25 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#26 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#27 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#28 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#29 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#30
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#31
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#32 
## 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 #33
##                                                ),byrow=TRUE,ncol=33); 
## colnames(mydag)<-rownames(mydag)<-names(var33);#set names
## ## create empty DAGs
## banned<-matrix(rep(0,dim(var33)[2]^2),ncol=dim(var33)[2]);
## colnames(banned)<-rownames(banned)<-names(var33);#set names
## retain<-matrix(rep(0,dim(var33)[2]^2),ncol=dim(var33)[2]);
## colnames(retain)<-rownames(retain)<-names(var33);#set names
## start<-matrix(rep(0,dim(var33)[2]^2),ncol=dim(var33)[2]);
## colnames(start)<-rownames(start)<-names(var33);#set names
## 
## set.seed(10000);## only affects init.permuts
## start.list<-list();
## n.searches<-10;#example only - must be much larger in practice
## for(i in 1:n.searches){start.list[[i]]<-retain;} ## empty networks
## myres<-hillsearchabn(data.df=var33,banned.m=banned,retain.m=retain,
##                      start.m=start.list,
##                      hyper.params=list(
##                      mean=rep(0,dim(var33)[2]+1),
##                      sd=rep(sqrt(1000),dim(var33)[2]+1), 
##                      shape=rep(0.001,16),## 16 Gaussian nodes
##                      scale=rep(1/0.001,16)## 16 Gaussian nodes
##                      ),
##                      max.parents=2, 
##                      num.searches=n.searches,
##                      init.permuts=20,db.size=20000,
##                      localdb=TRUE,timing=TRUE);
## 


###################################################
### code chunk number 14: abn.Rnw:507-527 (eval = FALSE)
###################################################
## # use results from above searches which are stored in ``myres''
## #step 1. discard any duplicate searches (these are unlikely)
## indexes<-uniquenets(myres$init.dag);
## all.res<-list();
## all.res$init.score<-myres$init.score[indexes];
## all.res$final.score<-myres$final.score[indexes];
## all.res$init.dag.<-myres$init.dag[indexes];
## all.res$final.dag<-myres$final.dag[indexes];
## # for every possible arc calculate how many times it appears in the searches  
## mypruneddags<-prunenets(all.res$final.dag,round(0.51*length(all.res$final.dag)));
## # now get a matrix/DAG for the majority network comprising of 1/0s
## myfunc<-function(arg1,threshold,netdata){#trivial helper for apply()
##          if(arg1>=round(threshold*length(netdata$final.dag)))
##          {return(1);} else {return(0);}}
## dag.con<-apply(mypruneddags$arcs.sum,c(1,2),FUN=myfunc,threshold=0.51,
##                netdata=all.res);
## tographviz(dag=dag.con,data.df=var33,outfile="dagcon.dot");#create file
## # dagcon.dot can then be processed with graphviz
## # unix shell "dot -Tpdf dagcon.dot -o dagcon.pdf" or use gedit if on Windows
## 


###################################################
### code chunk number 15: abn.Rnw:537-600
###################################################
#specific a DAG model
mydag<-matrix(c(
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#1
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#2  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#3  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#4  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#5  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#6  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#7  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#8  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#9  
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#10 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#11 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#12 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#13 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#14 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#15 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#16 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#17 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#18 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#19 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#20 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#21 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#22 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#23 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#24 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#25 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#26 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#27 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#28 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#29 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#30
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#31
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,#32 
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 #33
                                               ),byrow=TRUE,ncol=33); 
colnames(mydag)<-rownames(mydag)<-names(var33);#set names
## now fit the model defined in mydag - full independence
# define a model with many independencies
mydag[2,1]<-1;
mydag[4,3]<-1;
mydag[6,4]<-1; mydag[6,7]<-1;
mydag[5,6]<-1;
mydag[7,8]<-1;  
mydag[8,9]<-1;
mydag[9,10]<-1;
mydag[11,10]<-1; mydag[11,12]<-1; mydag[11,19]<-1;
mydag[14,13]<-1;
mydag[17,16]<-1;mydag[17,20]<-1;
mydag[15,14]<-1; mydag[15,21]<-1;
mydag[18,20]<-1;
mydag[19,20]<-1;
mydag[21,20]<-1;
mydag[22,21]<-1;
mydag[23,21]<-1;
mydag[24,23]<-1;
mydag[25,23]<-1; mydag[25,26]<-1;
mydag[26,20]<-1;
mydag[33,31]<-1;
mydag[33,31]<-1;
mydag[32,21]<-1; mydag[32,31]<-1;mydag[32,29]<-1;    
mydag[30,29]<-1;
mydag[28,27]<-1; mydag[28,29]<-1;mydag[28,31]<-1;


###################################################
### code chunk number 16: abn.Rnw:602-618
###################################################
#now get the marginal distribution for the parameters of v33     
marg1<-getmarginal(data.df=var33,
                   dag.m=mydag,
                   whichnode="v33",
                   whichvar="constant",#this is the intercept
                    hyper.params=list(
                     mean=rep(0,dim(var33)[2]+1),
                     sd=rep(sqrt(1000),dim(var33)[2]+1), 
                     shape=rep(0.001,16),## 16 Gaussian nodes
                     scale=rep(1/0.001,16)## 16 Gaussian nodes
                     ),
                     post.x=seq(from=-1.5,to=-0.5,len=1000),
                     verbose=TRUE);
cum.marg<-cumsum(marg1[,"f"])/sum(marg1[,"f"])
marg<-cbind(marg1,cum.marg);
marg[which(marg[,3]>0.5)[1]];#approx.median


###################################################
### code chunk number 17: abn.Rnw:620-636
###################################################
## now for the precision at node v33
marg2<-getmarginal(data.df=var33,
                   dag.m=mydag,
                   whichnode="v33",
                   whichvar="precision",#this is the intercept
                    hyper.params=list(
                     mean=rep(0,dim(var33)[2]+1),
                     sd=rep(sqrt(1000),dim(var33)[2]+1), 
                     shape=rep(0.001,16),## 16 Gaussian nodes
                     scale=rep(1/0.001,16)## 16 Gaussian nodes
                     ),
                     post.x=seq(from=0.5,to=1.5,len=1000),
                     verbose=TRUE);
cum.marg<-cumsum(marg2[,"f"])/sum(marg2[,"f"])
marg<-cbind(marg2,cum.marg);
marg[which(marg[,3]>0.5)[1]];#approx.median


###################################################
### code chunk number 18: abn.Rnw:638-654
###################################################
## now for a covariate effect at node v6
marg3<-getmarginal(data.df=var33,
                   dag.m=mydag,
                   whichnode="v6",
                   whichvar="v4",#this is the covariate effect
                    hyper.params=list(
                     mean=rep(0,dim(var33)[2]+1),
                     sd=rep(sqrt(1000),dim(var33)[2]+1), 
                     shape=rep(0.001,16),## 16 Gaussian nodes
                     scale=rep(1/0.001,16)## 16 Gaussian nodes
                     ),
                     post.x=seq(from=-1.5,to=2.5,len=1000),
                     verbose=TRUE);
cum.marg<-cumsum(marg3[,"f"])/sum(marg3[,"f"])
marg<-cbind(marg3,cum.marg);
marg[which(marg[,3]>0.5)[1]];#approx.median


###################################################
### code chunk number 19: abn.Rnw:658-672
###################################################
par(mar=c(8.8,8.2,3.1,3.1));
par(cex.axis=2.5);par(cex.lab=2.5);par(bg="white");par(fg="black");par(col.axis="black");par(col="black");par(col.main="black");
par(cex.main=2.5);par(col.lab="black");par(las=1);par(xaxs="i");par(yaxs="i");
par(mfrow=c(1,1));
plot(marg1[,"x"],marg1[,"f"],main="",xlab="",ylab="",type="n",axes=FALSE,xlim=c(-2,3),ylim=c(0,8));
lines(marg1[,"x"],marg1[,"f"],col="brown",lwd=3,lty=1);
lines(marg2[,"x"],marg2[,"f"],col="darkblue",lwd=3,lty=6);
lines(marg3[,"x"],marg3[,"f"],col="darkgreen",lwd=3,lty=4);
mtext("log odds",1,line=4,cex=2.5);
par(las=3);
mtext("Density",2,line=4.5,cex=2.5);par(las=1);
axis(1,padj=0.5,cex.axis=2.0);axis(2);box(); title("");
legend(0.5,8,legend=c("intercept node v33","Precision node v33","effect of v4 at node v6"),cex=1.5,
 col=c("brown","darkblue","darkgreen"),lty=c(1,6,4),lwd=5,bty="n");


