### R code from vignette source 'amei.Rnw'

###################################################
### code chunk number 1: amei.Rnw:21-23
###################################################
library(amei)
options(width=70, prompt="R> ", digits=5)


###################################################
### code chunk number 2: amei.Rnw:492-493
###################################################
set.seed(12345)


###################################################
### code chunk number 3: amei.Rnw:504-507
###################################################
tp <- list(b=0.00218, k=10, nu=0.4, mu=0) 
init <- list(S0=762, I0=1, R0=0, D0=0) 
costs <- list(vac=2, death=4, infect=1)


###################################################
### code chunk number 4: amei.Rnw:523-524
###################################################
vac <- list(frac=0, stop=0)


###################################################
### code chunk number 5: amei.Rnw:538-539
###################################################
init.MCepi <- MCepi(init, tp, vac, costs)


###################################################
### code chunk number 6: epis
###################################################
plot(init.MCepi)


###################################################
### code chunk number 7: costs
###################################################
plot(init.MCepi, type="costs")


###################################################
### code chunk number 8: amei.Rnw:572-573
###################################################
vacgrid <- list(fracs=seq(0,1.0,0.1),stops=seq(2,init$S0-75,75)) 


###################################################
### code chunk number 9: amei.Rnw:581-582
###################################################
out.optvac <-optvac(init, tp, vacgrid, costs) 


###################################################
### code chunk number 10: amei.Rnw:587-590
###################################################
best <-getpolicy(out.optvac) 
worst <-getpolicy(out.optvac, which="worst")
rbind(best, worst)


###################################################
### code chunk number 11: optvac
###################################################
plot(out.optvac) 


###################################################
### code chunk number 12: amei.Rnw:620-622
###################################################
vac.opt <- best[3:4]
opt.MCepi <- MCepi(init, tp, vac.opt, costs)


###################################################
### code chunk number 13: episov
###################################################
plot(opt.MCepi)


###################################################
### code chunk number 14: costsov
###################################################
plot(opt.MCepi, type="costs")


###################################################
### code chunk number 15: amei.Rnw:652-653
###################################################
getvac(opt.MCepi)


###################################################
### code chunk number 16: amei.Rnw:665-669
###################################################
T <- length(opt.MCepi$Median$C)
optC <- getcost(opt.MCepi)
initC <- getcost(init.MCepi)
data.frame(rbind(initC,optC), row.names=c("init", "opt"))


###################################################
### code chunk number 17: amei.Rnw:677-678
###################################################
opt.MCepi


###################################################
### code chunk number 18: amei.Rnw:724-725
###################################################
out.man <- manage(init, epistep, vacgrid, costs) 


###################################################
### code chunk number 19: epi
###################################################
plot(out.man)


###################################################
### code chunk number 20: cost
###################################################
plot(out.man, type="cost")


###################################################
### code chunk number 21: amei.Rnw:752-753
###################################################
getcost(out.man)


###################################################
### code chunk number 22: params
###################################################
true <- as.list(formals(epistep)$true)
plot(out.man, type="params",tp=tp) 


###################################################
### code chunk number 23: amei.Rnw:779-780
###################################################
out.man


###################################################
### code chunk number 24: amei.Rnw:812-813
###################################################
set.seed(12345)


###################################################
### code chunk number 25: amei.Rnw:827-828
###################################################
out.MCmanage <- MCmanage(init, epistep, vacgrid, costs)


###################################################
### code chunk number 26: MCmanepis
###################################################
plot(out.MCmanage)


###################################################
### code chunk number 27: MCmancosts
###################################################
plot(out.MCmanage, type="costs")


###################################################
### code chunk number 28: amei.Rnw:857-858
###################################################
getvac(out.MCmanage)


###################################################
### code chunk number 29: MCmanfracs
###################################################
plot(out.MCmanage, type="fracs")


###################################################
### code chunk number 30: MCmanstops
###################################################
plot(out.MCmanage, type="stops")


###################################################
### code chunk number 31: amei.Rnw:882-887
###################################################
cinit <- getcost(init.MCepi)
copt <- getcost(opt.MCepi)
cman <- getcost(out.MCmanage)
data.frame(rbind(cinit, copt, cman), 
           row.names=c("init", "opt", "man"))


###################################################
### code chunk number 32: amei.Rnw:902-903
###################################################
bad <- list(b=0.001, k=10, nu=0.9, mu=0)


###################################################
### code chunk number 33: amei.Rnw:907-910
###################################################
costs.bad <- optvac(init, bad, vacgrid, costs)
pol.bad <- getpolicy(costs.bad)
pol.bad


###################################################
### code chunk number 34: amei.Rnw:915-918
###################################################
bad.MCepi <- MCepi(init, tp, pol.bad[3:4], costs)
cbad <- getcost(bad.MCepi)
cbad


###################################################
### code chunk number 35: amei.Rnw:932-933
###################################################
set.seed(12345)


###################################################
### code chunk number 36: amei.Rnw:993-1022
###################################################
alt.epistep <- 
function(SIR, last=list(rem=0, rec=0, infect=0, dead=0, Z=0),
         tp=list(a = 0.05, mu = 0.05, nu = 0.1, m = 0.4, 
	 rho = 200, C = 500))
{
  ## calculate the infection probability based on the
  ## reservoir, and randomly infect susceptibles
  Z <- last$Z
  fz <- Z/(Z+tp$C)
  pi <- 1 - exp(-tp$a * fz)
  infect <- rbinom(1, SIR$S, pi)

  ## update recovereds and deaths
  pr <- 1 - exp(-tp$nu)
  rec <- rbinom(1,SIR$I,pr)
  pd <- 1 - exp(-tp$mu)
  dead <- rbinom(1, SIR$I-rec, pd)

  ## reservoir dynamics
  pz <- 1 - exp(-tp$m)
  dz <- rbinom(1, Z, pz)
  bz <- round(SIR$I*tp$rho)
  Z <- Z - dz + bz

  ## the returned list is passed in as "last" in a
  ## subsequent call to this "epistep" function
  return(list(rem=(rec+dead), rec=rec, infect=infect, 
              dead=dead, Z=Z))
}


###################################################
### code chunk number 37: amei.Rnw:1034-1039
###################################################
init1 <- list(S0=150, I0=1, R0=0, D0=0)
tp <- list(a=0.1, mu=0.0, nu=0.3, m=50, rho=500, C=500)
alt.epistep1 <- alt.epistep
formals(alt.epistep1)$tp <- tp
out.alt<- manage(init1, alt.epistep1, NULL, NULL, T=80)


###################################################
### code chunk number 38: amei.Rnw:1049-1053
###################################################
tp <- list(a=0.1, mu=0.0, nu=0.3, m=0.001, rho=500, C=500)
alt.epistep2 <- alt.epistep
formals(alt.epistep2)$tp <- tp
out.alt2 <- manage(init1, alt.epistep2, NULL, NULL, T=80)


###################################################
### code chunk number 39: alt
###################################################
plot(out.alt,showv=FALSE)


###################################################
### code chunk number 40: alt2
###################################################
plot(out.alt2,showv=FALSE)


###################################################
### code chunk number 41: alt-params
###################################################
plot(out.alt, type="params", showd=TRUE)


###################################################
### code chunk number 42: alt2-params
###################################################
plot(out.alt2, type="params", showd=TRUE)


###################################################
### code chunk number 43: amei.Rnw:1140-1143
###################################################
init <- list(S0=600, I0=1, R0=0, D0=0)
time <- 80
posterior <- manage(init, alt.epistep, NULL, NULL, T=time, bkrate=100)


###################################################
### code chunk number 44: alt-mixing-b
###################################################
plot(log(posterior$samp$b), type="l", main="",ylab=expression(b))


###################################################
### code chunk number 45: alt-mixing-k
###################################################
plot(posterior$samp$k, type="l", main="",ylab=expression(k))


###################################################
### code chunk number 46: alt-mixing-nu
###################################################
plot(posterior$samp$nu, type="l", main="",ylab=expression(nu))


###################################################
### code chunk number 47: alt-mixing-mu
###################################################
plot(posterior$samp$mu, type="l", main="",ylab=expression(mu))


###################################################
### code chunk number 48: amei.Rnw:1172-1173
###################################################
mean.params <- as.list(apply(posterior$samp, 2, mean))


###################################################
### code chunk number 49: amei.Rnw:1178-1182
###################################################
costs <- list(vac=2.5, death=4, infect=1) 
vacgrid <- list(fracs=seq(0,1.0,0.1), stops=seq(2,init$S0-50,50)) 
alt.optvac <- optvac(init, mean.params, vacgrid, costs, T=time)
alt.best <- getpolicy(alt.optvac)


###################################################
### code chunk number 50: alt-optvac
###################################################
plot(alt.optvac)


###################################################
### code chunk number 51: amei.Rnw:1200-1202
###################################################
alt.vac.opt <- alt.best[3:4]
alt.MCepi <- MCepi(init, alt.epistep, alt.vac.opt, costs, T=time)


###################################################
### code chunk number 52: amei.Rnw:1204-1205
###################################################
getcost(alt.MCepi)


###################################################
### code chunk number 53: amei.Rnw:1212-1213
###################################################
alt.MCmanage <- MCmanage(init, alt.epistep, vacgrid, costs, T=time)


###################################################
### code chunk number 54: amei.Rnw:1215-1216
###################################################
getcost(alt.MCmanage)


###################################################
### code chunk number 55: alt-MCepi-t
###################################################
plot(alt.MCepi, showd=TRUE)


###################################################
### code chunk number 56: alt-MCepi-c
###################################################
plot(alt.MCepi, type="costs")


###################################################
### code chunk number 57: alt-MCmanage-t
###################################################
plot(alt.MCmanage, showd=TRUE)


###################################################
### code chunk number 58: alt-MCmanage-c
###################################################
plot(alt.MCmanage, type="costs")


###################################################
### code chunk number 59: amei.Rnw:1269-1271
###################################################
alt.worst <- getpolicy(alt.optvac, which ="worst") 
rbind(alt.best, alt.worst) 


