### R code from vignette source 'amerApplications.Rnw'

###################################################
### code chunk number 1: prelim
###################################################
rm(list=ls())
options(width=60, continuation="   ")
library(amer)
library(mlmRev)
library(SASmixed)


###################################################
### code chunk number 2: contra_fit1
###################################################
print(contra1 <- lmer(use ~ urban + age + livch + (1|district), Contraception, 
				family = binomial), cor=F)


###################################################
### code chunk number 3: contra_fit2
###################################################
print(contra2 <- lmer(use ~ urban + age + livch + (urban|district), Contraception,
				family = binomial), cor=F)


###################################################
### code chunk number 4: contra_fit3
###################################################
print(contra3 <- amer(use ~ urban + bsp(age) + livch + (urban|district), Contraception, family = binomial), cor=F)


###################################################
### code chunk number 5: contra_fit4
###################################################
print(contra4 <- amer(use ~ urban + bsp(age, by=urban) + livch + (urban|district), Contraception, family = binomial), cor=F)


###################################################
### code chunk number 6: contra_anova
###################################################
print(anova(contra1 ,contra2, contra3, contra4))


###################################################
### code chunk number 7: contra_plot3
###################################################
	plotF(contra3)             


###################################################
### code chunk number 8: contra_plot4
###################################################
	plotF(contra4)             


###################################################
### code chunk number 9: chem_fit1
###################################################
 print(chem1 <- lmer(score ~ gcsecnt + (1 | school) + (1 | lea), Chem97), cor=F)


###################################################
### code chunk number 10: chem_fit2
###################################################
print(chem2 <- amer(score ~ bsp(gcsecnt) + (1 | school) + (1 | lea), Chem97), cor=F)
print(anova(chem1, chem2))


###################################################
### code chunk number 11: chem_plot
###################################################
plotF(chem2)


###################################################
### code chunk number 12: oxboys_fit1
###################################################
print(oxboys1 <- lmer(height ~ poly(age, 4) + (poly(age, 2) | Subject), data=Oxboys), cor=F)


###################################################
### code chunk number 13: oxboys_fit2
###################################################
print(oxboys2 <- amer(height ~ tp(age, k=12) + tp(age, k=4, by=Subject, allPen=T), data=Oxboys), cor=F)
print(anova(oxboys1, oxboys2))


###################################################
### code chunk number 14: scots
###################################################
ScotsSec$social <- factor(ScotsSec$social)
print(scots1 <- lmer(attain ~ sex  + (1 | primary) + (1 |second), ScotsSec), cor=F)
print(scots2 <- lmer(attain ~ sex  + verbal + (1 | primary) + (1 |second), ScotsSec), cor=F)
print(scots3 <- lmer(attain ~ sex  + social  + verbal +  (1 | primary) + (1 |second), ScotsSec), cor=F)


###################################################
### code chunk number 15: scots2
###################################################
print(scots4 <- amer(attain ~ sex  + social + bsp(verbal) + (1 | primary) + (1 |second), ScotsSec), cor=F)
print(scots5 <- amer(attain ~ sex  + social + bsp(verbal, by=social) + (1 | primary) + (1 |second), ScotsSec), cor=F)

print(anova(scots1, scots2, scots3, scots4, scots5))


###################################################
### code chunk number 16: scotsSecPlot
###################################################
plotF(scots4)             


