### R code from vignette source 'confReg.Rnw'

###################################################
### code chunk number 1: load-package
###################################################
library("confReg")


###################################################
### code chunk number 2: data-creation
###################################################
set.seed(100)
dataMatrix <- matrix(runif(10*200),200,10)
y<- (10*sin(pi*dataMatrix[,1]*dataMatrix[,2])+20*(dataMatrix[,3]-0.5)^2+10*dataMatrix[,4]+5*dataMatrix[,5]) + rnorm(200,0,0.1)
dataMatrix <- cbind(dataMatrix,y)


###################################################
### code chunk number 3: data-oject-creation
###################################################
data <- Dataset(dataMatrix);


###################################################
### code chunk number 4: data-oject-split
###################################################
folds <- calculateFolds(data, 5, random=TRUE);
datasets <- splitByFolds(data, folds, 5);


###################################################
### code chunk number 5: data-oject-normalize
###################################################
trainingData <- normalize(datasets[[1]]);
testData <- normalizeBy(datasets[[2]], trainingData);


###################################################
### code chunk number 6: modelcreation1
###################################################
me <- ModelEvaluation();
rModel <- Regression(lm, predict);


###################################################
### code chunk number 7: modelcreation2
###################################################
rModel <- FastRegression();


###################################################
### code chunk number 8: feature-selection-creation
###################################################
fs <- TwinScan(averageError, min);


###################################################
### code chunk number 9: feature-selection-selection
###################################################
featureList <- selectFeatures(fs, trainingData, me, randomize=TRUE, rModel)
featureList


###################################################
### code chunk number 10: model-creation
###################################################
featureSet(trainingData) <- featureList;
rModel <- learnFromDataset(rModel, trainingData);


###################################################
### code chunk number 11: model-prediction
###################################################
featureSet(testData) <- featureList;
predictions <- predictDataset(rModel, testData);
predictions


###################################################
### code chunk number 12: model-responses
###################################################
getResponses(testData)


###################################################
### code chunk number 13: model-eval1
###################################################
averageError(getResponses(testData),predictions);


###################################################
### code chunk number 14: model-eval2
###################################################
realResponses <- unscaleVector(testData, getResponses(testData));
realPredictions <- unscaleVector(testData, predictions);
averageError(realResponses, realPredictions);


###################################################
### code chunk number 15: model-eval3
###################################################
evaluateInCV(me, data, rModel, 5, random=FALSE, fs);


###################################################
### code chunk number 16: confidence-1
###################################################
ce <- ConfidenceEstimatorNNErrors(rModel, trainingData);


###################################################
### code chunk number 17: confidence-2
###################################################
predictionsTrainingData <- predictDataset(rModel, trainingData);
ce <- create(ce, optimize=TRUE, predictionsTrainingData);


###################################################
### code chunk number 18: confidence-3
###################################################
confidences <- estimate(ce, testData, predictions);
confidences


###################################################
### code chunk number 19: confidence-4
###################################################
evaluateConfidenceEstimates( getResponses(testData), predictions, confidences);


###################################################
### code chunk number 20: confidence-4
###################################################
interval_widths <- confidences[,3]-confidences[,2]
top20 <- which( interval_widths <= sort(interval_widths)[ length(interval_widths)*0.2]);
top20Error <- averageError(getResponses(testData)[top20],predictions[top20]) 
top20Error
overallError <- averageError(getResponses(testData),predictions)
overallError
(1-top20Error / overallError)*100;


###################################################
### code chunk number 21: fig1plot
###################################################
plotConfidenceIntervals(ce, getResponses(testData), predictions, confidences[,1]);


###################################################
### code chunk number 22: fig1
###################################################
plotConfidenceIntervals(ce, getResponses(testData), predictions, confidences[,1]);


