### R code from vignette source 'deducorrect-correction.Rnw'

###################################################
### code chunk number 1: deducorrect-correction.Rnw:57-59
###################################################
library(editrules)
library(deducorrect)


###################################################
### code chunk number 2: deducorrect-correction.Rnw:219-223
###################################################
(d <- data.frame(x=1,y=0,z=1))
E <- editmatrix("x==y-z")
sol <- correctSigns(E,d)
sol


###################################################
### code chunk number 3: deducorrect-correction.Rnw:228-229
###################################################
sol$corrected


###################################################
### code chunk number 4: deducorrect-correction.Rnw:232-233
###################################################
sol$corrections


###################################################
### code chunk number 5: deducorrect-correction.Rnw:238-239
###################################################
sol$status


###################################################
### code chunk number 6: deducorrect-correction.Rnw:420-425
###################################################
E <- editmatrix( c("X1 + X2 == X3"
                  ,"X2 == X4"
                  ,"X5 + X6 + X7 == X8"
                  ,"X3 + X8 == X9"
                  ,"X9 - X10 == X11"))


###################################################
### code chunk number 7: deducorrect-correction.Rnw:428-430
###################################################
(dat <- data.frame(t(c(12, 4, 15, 4, 3, 1, 8, 11, 27, 41, -13))))
violatedEdits(E,dat)


###################################################
### code chunk number 8: deducorrect-correction.Rnw:436-440
###################################################
set.seed(1)
sol <- correctRounding(E,dat)
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### code chunk number 9: deducorrect-correction.Rnw:583-585
###################################################
dat <- data.frame(x = 123, y = 192, z = 252)
(E <- editmatrix("z == x + y"))


###################################################
### code chunk number 10: deducorrect-correction.Rnw:605-606
###################################################
correctTypos(E, dat)$corrected


###################################################
### code chunk number 11: deducorrect-correction.Rnw:612-617
###################################################
E <- editmatrix( c("x1 + x2 == x3"
                  ,"x2 == x4"
                  ,"x5 + x6 + x7 == x8"
                  ,"x3 + x8 == x9"
                  ,"x9 - x10 == x11"))


###################################################
### code chunk number 12: deducorrect-correction.Rnw:622-631
###################################################
dat <-as.data.frame( matrix(c(
    1452, 116, 1568, 116, 323, 76, 12, 411,  1979, 1842, 137,
    1452, 116, 1568, 161, 323, 76, 12, 411,  1979, 1842, 137,
    1452, 116, 1568, 161, 323, 76, 12, 411, 19979, 1842, 137,
    1452, 116, 1568, 161,   0,  0,  0, 411, 19979, 1842, 137,
    1452, 116, 1568, 161, 323, 76, 12,   0, 19979, 1842, 137), 
    byrow=TRUE,nrow=5))
rownames(dat) <- paste("example 4.",0:4,sep="")
colnames(dat) <- paste("x",1:11,sep="")


###################################################
### code chunk number 13: deducorrect-correction.Rnw:633-634
###################################################
dat


###################################################
### code chunk number 14: deducorrect-correction.Rnw:645-646
###################################################
violatedEdits(E,dat)


###################################################
### code chunk number 15: deducorrect-correction.Rnw:649-651
###################################################
sol <- correctTypos(E, dat)
cbind(sol$corrected, sol$status)


###################################################
### code chunk number 16: deducorrect-correction.Rnw:790-794
###################################################
(dat <- data.frame(
    x = c( 3, 14, 15,  1, 17, 12.3),
    y = c(13, -4,  5,  2,  7, -2.1),
    z = c(10, 10,-10, NA, 10, 10 )))


###################################################
### code chunk number 17: deducorrect-correction.Rnw:801-802
###################################################
E <- editmatrix(c("z == x-y"))


###################################################
### code chunk number 18: deducorrect-correction.Rnw:806-807
###################################################
cbind(dat, violatedEdits(E,dat))


###################################################
### code chunk number 19: deducorrect-correction.Rnw:813-816
###################################################
sol <- correctSigns(E, dat)
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### code chunk number 20: deducorrect-correction.Rnw:827-830
###################################################
sol <- correctSigns(E, dat, eps=2)
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### code chunk number 21: deducorrect-correction.Rnw:836-839
###################################################
sol <- correctSigns(E, dat, eps=2, fixate="z")
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### code chunk number 22: deducorrect-correction.Rnw:843-844
###################################################
correctSigns(E, dat, flip=c("x","y"))


###################################################
### code chunk number 23: deducorrect-correction.Rnw:848-852
###################################################
sol <- correctSigns(E, dat, swap=list(c("x","y")), 
    eps=2, fixate="z")
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### code chunk number 24: deducorrect-correction.Rnw:870-873
###################################################
sol <- correctSigns(E, dat, flip=c(), swap=list(c("x","y")))
cbind(sol$corrected, sol$status) 
sol$corrections


###################################################
### code chunk number 25: deducorrect-correction.Rnw:876-877
###################################################
correctSigns(E, sol$corrected, eps=2)$status


###################################################
### code chunk number 26: deducorrect-correction.Rnw:882-897
###################################################
# make x and y swappable, swap a counts as one flip
correctSigns(E, dat, flip="z", swap=list(c("x","y")))

# same, but now, swapping is preferred (has lower weight)
correctSigns(E, dat, flip="z", swap=list(c("x","y")), weight=c(2,1))

# same, but now becayse x any y carry lower weight. Also allow for rounding errors
correctSigns(E, dat, flip="z", swap=list(c("x","y")), eps=2, weight=c(x=1, y=1, z=3))

# demand that solution has y>0
E <- editmatrix(c("z==x-y", "y>0"))
correctSigns(E,dat)

# demand that solution has y>0, taking acount of roundings in equalities
correctSigns(E,dat,eps=2)


###################################################
### code chunk number 27: deducorrect-correction.Rnw:906-921
###################################################
dat <- data.frame(
   case = c("a","b","c","d"),
   x0r = c(2100,5100,3250,5726),
   x0c = c(1950,4650,3550,5449),
   x0  = c( 150, 450, 300, 276),
   x1r = c(   0,   0, 110,  17),
   x1c = c(  10, 130,  10,  26),
   x1  = c(  10, 130, 100,  10),
   x2r = c(  20,  20,  50,   0),
   x2c = c(   5,   0,  90,  46),
   x2  = c(  15,  20,  40,  46),
   x3r = c(  50,  15,  30,   0),
   x3c = c(  10,  25,  10,   0),
   x3  = c(  40,  10,  20,   0),
   x4  = c( 195, 610,-140, 221))


###################################################
### code chunk number 28: deducorrect-correction.Rnw:929-936
###################################################
E <-editmatrix(c(
    "x0 == x0r - x0c",
    "x1 == x1r - x1c",
    "x2 == x2r - x2c",
    "x3 == x3r - x3c",
    "x4 == x0 + x1 + x2 + x3"))
E


###################################################
### code chunk number 29: deducorrect-correction.Rnw:940-941
###################################################
violatedEdits(E,dat)


###################################################
### code chunk number 30: deducorrect-correction.Rnw:946-951
###################################################
swap <- list(
    c("x1r","x1c"), 
    c("x2r","x2c"), 
    c("x3r","x3c"))
flip <- c("x0","x1","x2","x3","x4")


###################################################
### code chunk number 31: deducorrect-correction.Rnw:969-971
###################################################
cor <- correctSigns(E, dat, flip=flip, swap=swap)
cor$status


###################################################
### code chunk number 32: deducorrect-correction.Rnw:976-979
###################################################
cor <- correctSigns(E, dat, flip=flip, swap=swap, eps=2)
cor$status
cor$corrected


###################################################
### code chunk number 33: deducorrect-correction.Rnw:1049-1054
###################################################
(E <- editmatrix(c(
    "t >= 1", 
    "l >= 0",
    "t == p + l",
    "p < 0.6*t")))


###################################################
### code chunk number 34: deducorrect-correction.Rnw:1059-1074
###################################################
E <- matrix(c(
     1,   0, 0,
     0,   1, 0,
     1,  -1,-1,
    -0.6, 1, 1),
    nrow=4,
    byrow=TRUE,
    dimnames=list(
        1:4,
        c("t","l","p")
    )
)
b <- c(1,0,0,0)
ops <- c(">=", ">=", "==", ">")
(E <- as.editmatrix(E,b,ops))


###################################################
### code chunk number 35: deducorrect-correction.Rnw:1082-1083
###################################################
E[getOps(E)==">=", ]


###################################################
### code chunk number 36: deducorrect-correction.Rnw:1086-1087
###################################################
editmatrix(as.character(E),normalize=TRUE)


