### R code from vignette source 'deducorrect-imputation.Rnw'

###################################################
### code chunk number 1: deducorrect-imputation.Rnw:54-56
###################################################
library(editrules)
library(deducorrect)


###################################################
### code chunk number 2: deducorrect-imputation.Rnw:262-287
###################################################
E <- editmatrix(c(
         "x1 + x2      == x3",
         "x2           == x4",
         "x5 + x6 + x7 == x8",
         "x3 + x8      == x9",
         "x9 - x10     == x11",
         "x6 >= 0",
         "x7 >= 0"
))
dat <- data.frame(
    x1=c(145,145),
    x2=c(NA,NA),
    x3=c(155,155),
    x4=c(NA,NA),
    x5=c(NA, 86),
    x6=c(NA,NA),
    x7=c(NA,NA),
    x8=c(86,86),
    x9=c(NA,NA),
    x10=c(217,217),
    x11=c(NA,NA)
)
dat
d <- deduImpute(E,dat)
d$corrected


###################################################
### code chunk number 3: deducorrect-imputation.Rnw:297-298
###################################################
dat[1,]


###################################################
### code chunk number 4: deducorrect-imputation.Rnw:375-396
###################################################
M <- editarray(c(
"v1 %in% letters[1:4]",
"v2 %in% letters[1:3]",
"v3 %in% letters[1:3]",
"v4 %in% letters[1:2]",
"if (v2 == 'c'  & v3 != 'c' & v4 == 'a' ) FALSE",
"if (v2 != 'a'  & v4 == 'b') FALSE",
"if (v1 != 'c'  & v2 != 'b' & v3 != 'a') FALSE",
"if (v1 == 'c'  & v3 != 'a' & v4 == 'a' ) FALSE"
))
Mdat <- data.frame(
    v1 = c('c', NA,'b'),
    v2 = c('b', NA,'c'),
    v3 = c( NA, NA,'a'),
    v4 = c( NA,'b', NA),
    stringsAsFactors=FALSE
)
s <- deduImpute(M, Mdat)
s$corrected
s$status
s$corrections


###################################################
### code chunk number 5: deducorrect-imputation.Rnw:479-480
###################################################
(x <- dat[1,])


###################################################
### code chunk number 6: deducorrect-imputation.Rnw:483-484
###################################################
(s <- solSpace(E,x))


###################################################
### code chunk number 7: deducorrect-imputation.Rnw:494-495
###################################################
imputess(x, s$x0, s$C)


###################################################
### code chunk number 8: deducorrect-imputation.Rnw:499-500
###################################################
( y <- imputess(x, s$x0, s$C, z=rep(0,ncol(s$C))) )


###################################################
### code chunk number 9: deducorrect-imputation.Rnw:504-505
###################################################
any(violatedEdits(E,y,tol=1e-8))


###################################################
### code chunk number 10: deducorrect-imputation.Rnw:509-513
###################################################
Ey <- editmatrix(c(
    "yt == y1 + y2 + y3",
    "y4 == 0"))
y <- c(yt=10, y1=NA, y2=3, y3=7,y4=12)


###################################################
### code chunk number 11: deducorrect-imputation.Rnw:518-519
###################################################
(s <- solSpace(Ey,y))


###################################################
### code chunk number 12: deducorrect-imputation.Rnw:523-525
###################################################
(s <- solSpace(Ey, y, adapt=c(FALSE,FALSE,FALSE,FALSE,TRUE)))
imputess(y,x0=s$x0,C=s$C)


###################################################
### code chunk number 13: deducorrect-imputation.Rnw:576-581
###################################################
Ey <- editmatrix(c(
    "yt == y1 + y2 + y3",
    "y1 >= 0", "y2 >= 0 ","y3 >= 0"))
y <- c(yt=10, y1=NA, y2=3, y3=7)
(I<-deductiveZeros(Ey,y))


###################################################
### code chunk number 14: deducorrect-imputation.Rnw:584-586
###################################################
y[I] <- 0
y


###################################################
### code chunk number 15: deducorrect-imputation.Rnw:673-679
###################################################
E <- editarray(c(
    "gender     %in% c('male','female')",
    "pregnant   %in% c(TRUE,FALSE)",
    "chromosome %in% c('XX','XY')",
    "if (gender == 'male') !pregnant",
    "if (gender == 'male') chromosome == 'XY'"))


###################################################
### code chunk number 16: deducorrect-imputation.Rnw:682-684
###################################################
v <- c(gender='male',pregnant=FALSE,chromosome=NA)
(s <- deductiveLevels(E,v))


###################################################
### code chunk number 17: deducorrect-imputation.Rnw:687-689
###################################################
v[names(s)] <- s
v


###################################################
### code chunk number 18: deducorrect-imputation.Rnw:698-700
###################################################
v <- c(gender='male',pregnant=TRUE,chromosome=NA)
deductiveLevels(E,v)


###################################################
### code chunk number 19: deducorrect-imputation.Rnw:706-707
###################################################
deductiveLevels(E,v,checkFeasibility=FALSE)


###################################################
### code chunk number 20: deducorrect-imputation.Rnw:716-718
###################################################
adapt <- c(gender=FALSE,pregnant=TRUE,chromosome=TRUE)
(s <- deductiveLevels(E,v,adapt=adapt,checkFeasibility=FALSE))


###################################################
### code chunk number 21: deducorrect-imputation.Rnw:721-723
###################################################
v[names(s)] <- s
v


