### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: vignette.Rnw:17-29
###################################################
library(ezsim)
ezsim_basic<-ezsim(
    m             = 200,
    run           = TRUE,
    core          = 1,
    display_name  = c(mean_hat="hat(mu)",sd_mean_hat="hat(sigma[hat(mu)])"),
    parameter_def = createParDef(list(n=seq(20,80,20),mu=c(0,2),sigma=c(1,3,5))),
    dgp           = function() rnorm(n,mu,sigma),
    estimator     = function(x) c(mean_hat = mean(x), 
                                 sd_mean_hat=sd(x)/sqrt(length(x)-1)),
    true_value    = function() c(mu, sigma / sqrt(n-1))
)


###################################################
### code chunk number 2: vignette.Rnw:30-31
###################################################
summary(ezsim_basic)


###################################################
### code chunk number 3: vignette.Rnw:32-34 (eval = FALSE)
###################################################
## plot(ezsim_basic)
## plot(ezsim_basic,"density")


###################################################
### code chunk number 4: vignette.Rnw:36-37
###################################################
print(plot(ezsim_basic,return_print=TRUE)[[1]])


###################################################
### code chunk number 5: vignette.Rnw:40-41
###################################################
print(plot(ezsim_basic,return_print=TRUE)[[2]])


###################################################
### code chunk number 6: vignette.Rnw:44-45
###################################################
print(plot(ezsim_basic,"density",return_print=TRUE)[[1]])


###################################################
### code chunk number 7: vignette.Rnw:48-49
###################################################
print(plot(ezsim_basic,"density",return_print=TRUE)[[2]])


###################################################
### code chunk number 8: vignette.Rnw:72-74
###################################################
par_def<-createParDef(scalars=list(n=seq(20,80,20),mu=c(0,2),sigma=c(1,3,5)))
par_def


###################################################
### code chunk number 9: vignette.Rnw:77-78
###################################################
generate(par_def)[1:3]


###################################################
### code chunk number 10: vignette.Rnw:82-84
###################################################
par_def2<-createParDef(scalars=list(mu1=5,mu2=3,n=c(10,20)), others=list(Sigma=matrix(c(1,.4,.4,1),nrow=2)))
generate(par_def2)


###################################################
### code chunk number 11: vignette.Rnw:90-93
###################################################
dgp<-function(){
	rnorm(n,mu,sigma)
}


###################################################
### code chunk number 12: vignette.Rnw:95-98
###################################################
test(par_def,dgp,index=1)
test(par_def,dgp,index=2)



###################################################
### code chunk number 13: vignette.Rnw:100-107
###################################################
dgp_2<-function(){
    z1<-rnorm(n)
    z2<-rnorm(n)
    cbind(x1=mu1+z1*Sigma[1,1], x2=mu2+ Sigma[2,2]*(Sigma[1,2]*z1+ sqrt(1-Sigma[1,2]^2)*z2 ))
}
test(par_def2,dgp_2)



###################################################
### code chunk number 14: vignette.Rnw:111-115
###################################################
estimator<-function(x){
    c(mean_hat = mean(x), sd_mean_hat=sd(x)/sqrt(length(x)-1))
}
estimator(test(par_def,dgp,index=1))


###################################################
### code chunk number 15: vignette.Rnw:120-124
###################################################
true<-function(){
    c(mu, sigma / sqrt(n-1))
}
test(par_def,true)


###################################################
### code chunk number 16: vignette.Rnw:129-130
###################################################
display_name<-c(mean_hat="hat(mu)",sd_mean_hat="hat(sigma[hat(mu)])")


###################################################
### code chunk number 17: vignette.Rnw:138-139
###################################################
summary(ezsim_basic,subset=list(estimator="mean_hat",n=c(20,40),sigma=c(1,3)))


###################################################
### code chunk number 18: vignette.Rnw:143-144
###################################################
summary(ezsim_basic,simple=FALSE,subset=list(estimator="mean_hat",n=c(20,40),sigma=c(1,3)))


###################################################
### code chunk number 19: vignette.Rnw:148-149
###################################################
summary(ezsim_basic,stat=c("q25","median","q75"),Q025=quantile(value_of_estimator,0.025),Q975=quantile(value_of_estimator,0.975),subset=list(estimator="mean_hat",n=c(20,40),sigma=c(1,3)))


###################################################
### code chunk number 20: vignette.Rnw:158-159 (eval = FALSE)
###################################################
## plot(ezsim_basic,subset=list(estimator="sd_mean_hat",mu=3))


###################################################
### code chunk number 21: vignette.Rnw:160-162
###################################################
print(plot(ezsim_basic,subset=list(estimator="sd_mean_hat",mu=0),return_print=TRUE)[[1]])



###################################################
### code chunk number 22: vignette.Rnw:163-164 (eval = FALSE)
###################################################
## plot(ezsim_basic,subset=list(estimator="mean_hat",sigma=3))


###################################################
### code chunk number 23: vignette.Rnw:165-166
###################################################
print(plot(ezsim_basic,subset=list(estimator="mean_hat",sigma=3),return_print=TRUE)[[1]])


###################################################
### code chunk number 24: vignette.Rnw:171-172 (eval = FALSE)
###################################################
## plot(ezsim_basic,subset=list(estimator="sd_mean_hat",mu=0),parameters_priority=c("sigma","n"))


###################################################
### code chunk number 25: vignette.Rnw:173-176
###################################################
print(plot(ezsim_basic,subset=list(estimator="sd_mean_hat",mu=0),parameters_priority="sigma",return_print=TRUE)[[1]])




###################################################
### code chunk number 26: vignette.Rnw:177-178 (eval = FALSE)
###################################################
## plot(ezsim_basic,subset=list(estimator="mean_hat",sigma=c(1,3)),parameters_priority="mu")


###################################################
### code chunk number 27: vignette.Rnw:179-181
###################################################
print(plot(ezsim_basic,subset=list(estimator="mean_hat",sigma=c(1,3)),parameters_priority="mu",return_print=TRUE)[[1]])



###################################################
### code chunk number 28: vignette.Rnw:187-188 (eval = FALSE)
###################################################
## plot(ezsim_basic,"density",subset=list(estimator="mean_hat",sigma=3),parameters_priority="n",benchmark=dnorm)


###################################################
### code chunk number 29: vignette.Rnw:189-192
###################################################
print(plot(ezsim_basic,"density",benchmark=dnorm,subset=list(estimator="mean_hat",sigma=3),parameters_priority="n",return_print=TRUE)[[1]])




###################################################
### code chunk number 30: vignette.Rnw:193-194 (eval = FALSE)
###################################################
## plot(ezsim_basic,"density",subset=list(estimator="mean_hat",mu=0),parameters_priority="n" ,benchmark=dnorm)


###################################################
### code chunk number 31: vignette.Rnw:195-196
###################################################
print(plot(ezsim_basic,"density",benchmark=dnorm,subset=list(estimator="mean_hat",mu=0),parameters_priority="n",return_print=TRUE)[[1]])


###################################################
### code chunk number 32: vignette.Rnw:202-203 (eval = FALSE)
###################################################
## plot(summary(ezsim_basic,c("q25","q75")))


###################################################
### code chunk number 33: vignette.Rnw:204-206
###################################################
print(plot(summary(ezsim_basic,c("q25","q75")),return_print=TRUE))



###################################################
### code chunk number 34: vignette.Rnw:207-208 (eval = FALSE)
###################################################
## plot(summary(ezsim_basic,c("q25","q75"),subset=list(estimator="mean_hat")))


###################################################
### code chunk number 35: vignette.Rnw:209-211
###################################################
print(plot(summary(ezsim_basic,c("q25","q75"),subset=list(estimator="mean_hat")),return_print=TRUE))



###################################################
### code chunk number 36: vignette.Rnw:212-213 (eval = FALSE)
###################################################
## plot(summary(ezsim_basic,c("median"),subset=list(estimator="sd_mean_hat")))


###################################################
### code chunk number 37: vignette.Rnw:214-216
###################################################
print(plot(summary(ezsim_basic,c("median"),subset=list(estimator="sd_mean_hat")),return_print=TRUE))



###################################################
### code chunk number 38: vignette.Rnw:222-245
###################################################
ez_powerfun<-ezsim(
    m             = 100,
    run           = TRUE,
    core          = 1,
    display_name  = c(b="beta",es="sigma[e]^2",xs="sigma[x]^2"),
    parameter_def = createParDef(scalars=list(xs=1,n=50,es=5,b=seq(-1,1,0.1))),
    dgp           = function(){
                        x<-rnorm(n,0,xs)
                        e<-rnorm(n,0,es)
                        y<-b * x + e
                        data.frame(y,x)
                    },
    estimator     = function(d){
                        r<-summary(lm(y~x-1,data=d))
                        stat<-r$coef[,1]/r$coef[,2]

                        # test whether b > 0
                        # level of significance : 5%
                        out <- stat > c(qnorm(.95), qt(0.95,df=r$df[2]))
                        names(out)<-c("z-test","t-test")
                        out
                    }
)


###################################################
### code chunk number 39: vignette.Rnw:247-249 (eval = FALSE)
###################################################
## plot(ez_powerfun,"powerfun",null_hypothesis=0)
## 


###################################################
### code chunk number 40: vignette.Rnw:250-251
###################################################
print(plot(ez_powerfun,"powerfun",null_hypothesis=0,return_print=TRUE))


