### R code from vignette source 'LR_vignette.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: load
###################################################
library(forensim)


###################################################
### code chunk number 2: LR
###################################################
victim <- "15/18"
suspect <- "14/17"


###################################################
### code chunk number 3: LR1
###################################################
LR(stain = c(14, 15, 17, 18), freq = c(0.033, 0.331, 0.239, 0.056), xp = 0, Tp = c(victim, suspect), Vp = NULL, Td = NULL, 
Vd = c(victim, suspect), xd = 2,theta=0)


###################################################
### code chunk number 4: LR2
###################################################
LR(stain = c(14, 15, 17, 18), freq = c(0.033, 0.331, 0.239, 0.056), 
xp = 0, Tp = c(victim, suspect), Vp = NULL, Td = victim, Vd = suspect, xd = 1,theta=0)


###################################################
### code chunk number 5: LR
###################################################
LR(stain=c(14,15,17,18),freq=c(0.033,0.331,0.239,0.056),xp=0,Tp=c(victim,suspect),Vp=NULL,Td=victim,Vd=suspect,xd=1,theta=0.03)


###################################################
### code chunk number 6: theta correction
###################################################
theta<-seq(0,0.03,by=0.001)
theta


###################################################
### code chunk number 7: sapply
###################################################
sapply(theta, function(i) LR(stain=c(14,15,17,18),freq=c(0.033,0.331,0.239,0.056),xp=0,Tp=c(victim,suspect),Vp=NULL,Td=victim,
Vd=suspect,xd=1,theta=i))


###################################################
### code chunk number 8: save LR
###################################################
LRtheta<-sapply(theta, function(i) LR(stain=c(14,15,17,18),freq=c(0.033,0.331,0.239,0.056),xp=0,Tp=c(victim,suspect),
Vp=NULL,Td=victim,Vd=suspect,xd=1,theta=i))


###################################################
### code chunk number 9: plotLR
###################################################
plot(theta,LRtheta)


###################################################
### code chunk number 10: load
###################################################
1/(24*0.033*0.331*0.239*0.056)


###################################################
### code chunk number 11: load
###################################################
1/(2*0.033*0.239)


###################################################
### code chunk number 12: load
###################################################
(1+3*0.03)*(1+4*0.03)/(2*(0.03+(1-0.03)*0.033)*(0.03+(1-0.03)*0.239))


###################################################
### code chunk number 13: LR2
###################################################
LR(stain=c(14,15,17,18),freq=c(0.033,0.331,0.239,0.056),xp=0,Tp=c(victim,suspect),Vp=NULL,Td=victim,Vd=suspect,xd=1,theta=0.03)


###################################################
### code chunk number 14: stains
###################################################
stainD3<-c(15,16,17)
stainv<-c(15,16,18)
stainFGA<-c(20,21,22,24,26)


###################################################
### code chunk number 15: suspects
###################################################
suspectD3<-"15/17"
suspectv<-"16/18"
suspectFGA<-"20/26"


###################################################
### code chunk number 16: LR
###################################################
LRD3<-LR(stain=stainD3,freq=rep(0.1,3),xp=2,Tp=c(suspectD3),Vp=NULL,Td=NULL,Vd=suspectD3,xd=3,theta=0)
LRD3


###################################################
### code chunk number 17: LR2
###################################################
LRDv<-LR(stain=stainv,freq=rep(0.1,3),xp=2,Tp=c(suspectv),Vp=NULL,Td=NULL,Vd=suspectv,xd=3,theta=0)
LRDv


###################################################
### code chunk number 18: LR3
###################################################
LRDFGA<-LR(stain=stainFGA,freq=rep(0.1,5),xp=2,Tp=c(suspectFGA),Vp=NULL,Td=NULL,Vd=suspectFGA,xd=3,theta=0)
LRDFGA


###################################################
### code chunk number 19: prodLR
###################################################
LRD3*LRDv*LRDFGA


###################################################
### code chunk number 20: ABdef
###################################################
D <- 0.01
pA <- 0.2
pB <- 0.1


###################################################
### code chunk number 21: load
###################################################
1/(2*pA*pB) 


###################################################
### code chunk number 22: LR
###################################################
LR(stain=c("A","B"),freq=c(0.2,0.1),xp=0,Tp="A/B",Vp=NULL,Td=NULL,Vd="A/B",xd=1,theta=0)


###################################################
### code chunk number 23: LR
###################################################
LR(stain=c("A"),freq=c(0.2),xp=0,Tp="A/A",Vp=NULL,Td=NULL,Vd="A/A",xd=1,theta=0)


###################################################
### code chunk number 24: LR
###################################################
25^9


###################################################
### code chunk number 25: load
###################################################
D/((1+D)*pA^2+2*pA*(1-pA)*D)


###################################################
### code chunk number 26: load
###################################################
25^9*0.2293578


###################################################
### code chunk number 27: xydef (eval = FALSE)
###################################################
## D=seq(0,1,length=1000)
## pA=0.2
## LR1=D/((1+D)*pA^2+D*2*pA*(1-pA))


###################################################
### code chunk number 28: LR_vignette.Rnw:508-511
###################################################
D=seq(0,1,length=1000)
pA=0.2
LR1=D/((1+D)*pA^2+D*2*pA*(1-pA))
plot(D,LR1,type="l",xlab="Drop out probability",ylab="LR1")
title("Stain:A.Suspect:AB.pA=0.2.\n LR as a function of drop out probability")


