### R code from vignette source 'gRain-intro.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: gRain-intro.Rnw:124-126
###################################################
library(gRain)
options("prompt"="> ","width"=85)


###################################################
### code chunk number 2: gRain-intro.Rnw:163-172
###################################################
yn <- c("yes","no")
a    <- cptable(~asia, values=c(1,99),levels=yn)
t.a  <- cptable(~tub|asia, values=c(5,95,1,99),levels=yn)
s    <- cptable(~smoke, values=c(5,5), levels=yn)
l.s  <- cptable(~lung|smoke, values=c(1,9,1,99), levels=yn)
b.s  <- cptable(~bronc|smoke, values=c(6,4,3,7), levels=yn)
e.lt <- cptable(~either|lung:tub,values=c(1,0,1,0,1,0,0,1),levels=yn)
x.e  <- cptable(~xray|either, values=c(98,2,5,95), levels=yn)
d.be <- cptable(~dysp|bronc:either, values=c(9,1,7,3,8,2,1,9), levels=yn)


###################################################
### code chunk number 3: gRain-intro.Rnw:178-182
###################################################
plist <- compileCPT(list(a, t.a, s, l.s, b.s, e.lt, x.e, d.be))
plist
in1 <- grain(plist)
in1


###################################################
### code chunk number 4: gRain-intro.Rnw:194-195
###################################################
querygrain(in1,nodes=c("lung","bronc"), type="marginal")


###################################################
### code chunk number 5: gRain-intro.Rnw:201-202
###################################################
querygrain(in1,nodes=c("lung","bronc"), type="joint")


###################################################
### code chunk number 6: gRain-intro.Rnw:208-209
###################################################
in12  <- setFinding(in1,nodes=c("asia","dysp"),states=c("yes","yes"))


###################################################
### code chunk number 7: gRain-intro.Rnw:215-217
###################################################
querygrain(in12,nodes=c("lung","bronc"))
querygrain(in12,nodes=c("lung","bronc"), type="joint")


###################################################
### code chunk number 8: gRain-intro.Rnw:225-226
###################################################
in13  <- setFinding(in1,nodes=c("either","tub"),states=c("no","yes"))


###################################################
### code chunk number 9: gRain-intro.Rnw:231-232
###################################################
pFinding(in13)


###################################################
### code chunk number 10: gRain-intro.Rnw:238-239
###################################################
querygrain(in13,nodes=c("lung","bronc"), type="joint")


