### R code from vignette source 'mixed-graphs.Rnw'

###################################################
### code chunk number 1: mixed-graphs.Rnw:134-137
###################################################
library(ggm)
options(width = 50)
options(continue = "  ")


###################################################
### code chunk number 2: mixed-graphs.Rnw:140-143
###################################################
exdag <- dag(~r, ~q*r, ~p, ~h*p*r, ~l, 
             ~k*l, ~j*k, ~i*h*l*j)
exdag


###################################################
### code chunk number 3: mixed-graphs.Rnw:147-148
###################################################
nodes(exdag)


###################################################
### code chunk number 4: mixed-graphs.Rnw:153-154 (eval = FALSE)
###################################################
## plotGraph(exdag)


###################################################
### code chunk number 5: mixed-graphs.Rnw:162-165
###################################################
exdag <- graph.formula(q+-r-+h+-p, 
         h-+i+-l-+k,   i+-j+-k)
exdag


###################################################
### code chunk number 6: mixed-graphs.Rnw:183-187
###################################################
A <- matrix(0,8,8)
A[8,7] <- A[8,5] <- A[6,5] <- A[5,1] <- 
A[4,1] <- A[4,3] <- A[2,1] <- A[3,2] <- 1
A


###################################################
### code chunk number 7: mixed-graphs.Rnw:192-193 (eval = FALSE)
###################################################
## plotGraph(A)


###################################################
### code chunk number 8: mixed-graphs.Rnw:199-201
###################################################
V <- c("i","j","k","l","h","p","q","r")
dimnames(A) = list(V, V)


###################################################
### code chunk number 9: mixed-graphs.Rnw:206-207
###################################################
exdag <- DAG(i ~ j+l+h, k~l, h~r+p, q ~ r)


###################################################
### code chunk number 10: mixed-graphs.Rnw:213-216
###################################################
mg <- c("b","X","Y","a","X","Y","l","X","Q",
        "b","Q","X","a","Y","Q","b","Y","Z",
        "a","Z","W","a","W","Z","b","W","Q")


###################################################
### code chunk number 11: mixed-graphs.Rnw:218-219 (eval = FALSE)
###################################################
## plotGraph(mg)


###################################################
### code chunk number 12: mixed-graphs.Rnw:256-265
###################################################
mg <- matrix(c( 0, 101,   0,   0, 110,
              100,   0, 100,   0,   1,
                0, 110,   0,   1,   0,
                0,   0,   1,   0, 100,
              110,   0,   0, 100,   0), 
      5,5, byrow = TRUE)
N <- c("X","Y","Z","W","Q")
dimnames(mg) <- list(N, N)
mg


###################################################
### code chunk number 13: mixed-graphs.Rnw:273-276
###################################################
mgv <- c("b","X","Y","a","X","Y","l","X","Q",
         "b","Q","X","a","Y","Q","b","Y","Z",
         "a","Z","W","a","W","Z","b","W","Q")


###################################################
### code chunk number 14: mixed-graphs.Rnw:287-290
###################################################
mg <- makeMG(dg = DG(Y~X, Z~W, W~Z, Q~X), 
            ug = UG(~ X*Q), 
            bg = UG(~ Y*X + X*Q + Q*W +Y*Z))


###################################################
### code chunk number 15: mixed-graphs.Rnw:310-321
###################################################
ex <- matrix(c(0,1,0,0,0,0,0,0,
               0,0,1,0,0,0,0,0,
               0,0,0,0,0,0,0,0,
               0,0,1,0,1,0,1,0,
               0,0,0,0,0,1,0,0,
               0,0,0,0,0,0,0,0,
               0,0,0,0,0,1,0,0,
               0,0,0,0,0,1,1,0),8,8,byrow=TRUE)
exvec <- c("a",1,2,"a",2,3,"a",4,3,
           "a",4,5,"a",4,7,"a",5,6,
           "a",7,6,"a",8,6,"a",8,7)


###################################################
### code chunk number 16: mixed-graphs.Rnw:323-324 (eval = FALSE)
###################################################
## plotGraph(ex)


###################################################
### code chunk number 17: mixed-graphs.Rnw:330-332
###################################################
M <- c(5,8)
C <- 3


###################################################
### code chunk number 18: mixed-graphs.Rnw:335-336 (eval = FALSE)
###################################################
## RG(ex, M, C, plot = TRUE)


###################################################
### code chunk number 19: mixed-graphs.Rnw:338-339
###################################################
RG(ex, M, C)


###################################################
### code chunk number 20: mixed-graphs.Rnw:345-346 (eval = FALSE)
###################################################
## plotGraph(SG(ex,M,C), dashed = TRUE)


###################################################
### code chunk number 21: mixed-graphs.Rnw:348-349
###################################################
SG(ex, M, C)


###################################################
### code chunk number 22: mixed-graphs.Rnw:355-356 (eval = FALSE)
###################################################
## AG(exvec,M,C,showmat=FALSE, plot=TRUE)


###################################################
### code chunk number 23: mixed-graphs.Rnw:368-372
###################################################
H <- matrix(c(0  ,100,  1,  0,
              100,0  ,100,  0,
              0  ,100,  0,100,
              0,  1  ,100,  0),4,4)


###################################################
### code chunk number 24: mixed-graphs.Rnw:374-375 (eval = FALSE)
###################################################
## plotGraph(H)


###################################################
### code chunk number 25: mixed-graphs.Rnw:384-385
###################################################
Max(H)


###################################################
### code chunk number 26: mixed-graphs.Rnw:387-388 (eval = FALSE)
###################################################
## plotGraph(Max(H))


###################################################
### code chunk number 27: mixed-graphs.Rnw:396-397
###################################################
MAG(H)


###################################################
### code chunk number 28: mixed-graphs.Rnw:406-407
###################################################
a <- DAG(W ~ Z, Z ~ Y + X) 


###################################################
### code chunk number 29: mixed-graphs.Rnw:409-410 (eval = FALSE)
###################################################
## plotGraph(a)


###################################################
### code chunk number 30: mixed-graphs.Rnw:418-420
###################################################
msep(a,"X","Y","Z")
msep(a,"X","Y")


###################################################
### code chunk number 31: mixed-graphs.Rnw:432-447
###################################################
H1 <- matrix(c(  0,100,  0,  0,  0,
               100,  0,100,  0,  0,
                 0,100,  0,  0,  0,
                 1,  0,  0,  0,100,
                 0,  0,  1,100,  0),5,5)
H2 <- matrix(c(0,0,0,  0,  0,
               1,0,1,  0,  0,
               0,0,0,  0,  0,
               1,0,0,  0,100,
               0,0,1,100,  0),5,5)
H3 <- matrix(c(0,0,0,0,0,
               1,0,1,0,0,
               0,0,0,0,0,
               1,0,0,0,0,
               0,0,1,1,0),5,5)


###################################################
### code chunk number 32: mixed-graphs.Rnw:449-450 (eval = FALSE)
###################################################
## plotGraph(H1); plotGraph(H2); plotGraph(H3)


###################################################
### code chunk number 33: mixed-graphs.Rnw:459-462
###################################################
MarkEqRcg(H1,H2)
MarkEqRcg(H1,H3)
MarkEqRcg(H2,H3)


###################################################
### code chunk number 34: mixed-graphs.Rnw:466-478
###################################################
A1<-matrix(c(  0,100,  0,  0,
             100,  0,100,  0,
               0,100,  0,100,
               0,  1,100,  0),4,4)
A2<-matrix(c(0,  0,  0,  0,
             1,  0,100,  0,
             0,100,  0,100,
             0,  1,100,  0),4,4)
A3<-matrix(c(0,0,  0,  0,
             1,0,  0,  0,
             0,1,  0,100,
             0,1,100,  0),4,4)


###################################################
### code chunk number 35: mixed-graphs.Rnw:480-481 (eval = FALSE)
###################################################
## plotGraph(A1); plotGraph(A2); plotGraph(A3)


###################################################
### code chunk number 36: mixed-graphs.Rnw:489-492
###################################################
MarkEqMag(H1,H2)
MarkEqMag(H1,H3)
MarkEqMag(H2,H3)


###################################################
### code chunk number 37: mixed-graphs.Rnw:498-502
###################################################
H <- matrix(c( 0,10,  0,  0,
              10, 0,  0,  0,
               0, 1,  0,100,
               0, 0,100,  0),4,4)


###################################################
### code chunk number 38: mixed-graphs.Rnw:504-505 (eval = FALSE)
###################################################
## plotGraph(H)


###################################################
### code chunk number 39: mixed-graphs.Rnw:512-513
###################################################
RepMarDAG(H)


###################################################
### code chunk number 40: mixed-graphs.Rnw:515-516 (eval = FALSE)
###################################################
## plotGraph(RepMarDAG(H))


###################################################
### code chunk number 41: mixed-graphs.Rnw:525-527
###################################################
RepMarUG(H)
RepMarBG(H)


