### R code from vignette source 'glpkAPI.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: glpkAPI.Rnw:90-91
###################################################
library(glpkAPI)


###################################################
### code chunk number 2: glpkAPI.Rnw:94-95
###################################################
prob <- initProbGLPK()


###################################################
### code chunk number 3: glpkAPI.Rnw:98-99
###################################################
setProbNameGLPK(prob, "sample")


###################################################
### code chunk number 4: glpkAPI.Rnw:104-105
###################################################
setObjDirGLPK(prob, GLP_MAX)


###################################################
### code chunk number 5: glpkAPI.Rnw:108-110
###################################################
addRowsGLPK(prob, 3)
addColsGLPK(prob, 3)


###################################################
### code chunk number 6: glpkAPI.Rnw:113-119
###################################################
setRowNameGLPK(prob, 1, "p")
setRowNameGLPK(prob, 2, "q")
setRowNameGLPK(prob, 3, "r")
setColNameGLPK(prob, 1, "x1")
setColNameGLPK(prob, 2, "x2")
setColNameGLPK(prob, 3, "x3")


###################################################
### code chunk number 7: glpkAPI.Rnw:122-125
###################################################
setRowBndGLPK(prob, 1, GLP_UP, 0, 100)
setRowBndGLPK(prob, 2, GLP_UP, 0, 600)
setRowBndGLPK(prob, 3, GLP_UP, 0, 300)


###################################################
### code chunk number 8: glpkAPI.Rnw:129-134
###################################################
lb <- c(0, 0, 0)
ub <- c(100, 600, 300)
type <- rep(GLP_UP, 3)

setRowsBndsGLPK(prob, 1:3, lb, ub, type)


###################################################
### code chunk number 9: glpkAPI.Rnw:137-140
###################################################
setColBndGLPK(prob, 1, GLP_LO, 0, 0)
setColBndGLPK(prob, 2, GLP_LO, 0, 0)
setColBndGLPK(prob, 3, GLP_LO, 0, 0)


###################################################
### code chunk number 10: glpkAPI.Rnw:143-146
###################################################
setObjCoefGLPK(prob, 1, 10)
setObjCoefGLPK(prob, 2, 6)
setObjCoefGLPK(prob, 3, 4)


###################################################
### code chunk number 11: glpkAPI.Rnw:150-156
###################################################
lb <- c(0, 0, 0)
ub <- lb
type <- rep(GLP_LO, 3)
obj <- c(10, 6, 4)

setColsBndsObjCoefsGLPK(prob, 1:3, lb, ub, obj, type)


###################################################
### code chunk number 12: glpkAPI.Rnw:159-164
###################################################
ia <- c(1, 1, 1, 2, 3, 2, 3, 2, 3)
ja <- c(1, 2, 3, 1, 1, 2, 2, 3, 3)
ar <- c(1, 1, 1, 10, 2, 4, 2, 5, 6)

loadMatrixGLPK(prob, 9, ia, ja, ar)


###################################################
### code chunk number 13: glpkAPI.Rnw:167-168
###################################################
solveSimplexGLPK(prob)


###################################################
### code chunk number 14: glpkAPI.Rnw:171-172
###################################################
getObjValGLPK(prob)


###################################################
### code chunk number 15: glpkAPI.Rnw:175-178
###################################################
getColPrimGLPK(prob, 1)
getColPrimGLPK(prob, 2)
getColPrimGLPK(prob, 3)


###################################################
### code chunk number 16: glpkAPI.Rnw:182-183
###################################################
getColsPrimGLPK(prob)


###################################################
### code chunk number 17: glpkAPI.Rnw:187-188
###################################################
getColsDualGLPK(prob)


###################################################
### code chunk number 18: glpkAPI.Rnw:191-192
###################################################
printSolGLPK(prob, "sol.txt")


###################################################
### code chunk number 19: glpkAPI.Rnw:195-196
###################################################
writeLPGLPK(prob, "prob.lp")


###################################################
### code chunk number 20: glpkAPI.Rnw:199-201
###################################################
lp <- initProbGLPK()
readLPGLPK(lp, "prob.lp")


###################################################
### code chunk number 21: glpkAPI.Rnw:204-206
###################################################
delProbGLPK(prob)
delProbGLPK(lp)


###################################################
### code chunk number 22: glpkAPI.Rnw:211-212
###################################################
help(glpkConstants)


###################################################
### code chunk number 23: glpkAPI.Rnw:220-221
###################################################
setSimplexParmGLPK(TM_LIM, 1000)


###################################################
### code chunk number 24: glpkAPI.Rnw:232-233
###################################################
?glp_add_cols


###################################################
### code chunk number 25: glpkAPI.Rnw:244-247
###################################################
prob <- initProbGLPK()
addColsGLPK(prob, 1000)
addRowsGLPK(prob, 600)


###################################################
### code chunk number 26: glpkAPI.Rnw:250-254
###################################################
system.time(
   mapply(setColBndGLPK, j = 1:1000,
   MoreArgs = list(lp = prob, type = GLP_DB, lb = 0, ub = 25))
)


###################################################
### code chunk number 27: glpkAPI.Rnw:257-263
###################################################
system.time(
   setColsBndsGLPK(prob, j = 1:1000,
                   type = rep(GLP_DB, 1000),
                   lb = rep(0, 1000),
                   ub = rep(0, 1000))
)


