### R code from vignette source 'graphComp.Rnw'

###################################################
### code chunk number 1: data
###################################################
library(ALL)
data("ALL")
ALL


###################################################
### code chunk number 2: datasub
###################################################
BcellIds <- grep("^B", ALL$BT)
ALL_B <- ALL[, BcellIds]
dim(ALL_B)


###################################################
### code chunk number 3: nspfil
###################################################
library(genefilter)
library(hgu95av2.db)
nALL_B <- nsFilter(ALL_B)
dim(nALL_B$eset)


###################################################
### code chunk number 4: genes
###################################################
library(hgu95av2.db)
xx <- as.list(hgu95av2PATH2PROBE)
ids <- xx$"04115"
mat_B <- exprs(nALL_B$eset)
ids <- ids[ids %in% rownames(mat_B)]
mat_B <- mat_B[ids,]
dim(mat_B)


###################################################
### code chunk number 5: get.genes
###################################################
get.genes <- function(IDs=c('')){
	result <- 1:length(IDs)
	require(hgu95av2.db)
	xx <- as.list(hgu95av2SYMBOL)
	for(i in 1:length(IDs)){
		if(is.na(xx[[IDs[i]]])==TRUE) {
			result[i] <- IDs[i]
		} else {
			result[i] <- xx[[IDs[i]]]
		}
	}
	return(result)
}
genes <- get.genes(rownames(mat_B))
length(rownames(mat_B))
length(genes)


###################################################
### code chunk number 6: rownamesChange
###################################################
rownames(mat_B) <- get.genes(rownames(mat_B))


###################################################
### code chunk number 7: geneNetGraph
###################################################
geneNetGraph <- function(matrix, pval){
   require(GeneNet)
   corr <- ggm.estimate.pcor(t(matrix))
   results <- ggm.test.edges(corr, plot=F)
   sig <- results$prob>pval
   geneNetGr <- ggm.make.graph(results[sig, ], colnames(t(matrix)))
   return(geneNetGr)
}


###################################################
### code chunk number 8: GeneNet
###################################################
geneNetGr <- geneNetGraph(mat_B,pval=0.8)
require(Rgraphviz)
plot(geneNetGr, main="B-cell ALL")



###################################################
### code chunk number 9: GeneNet
###################################################
plot(geneNetGr, main="B-cell ALL")


###################################################
### code chunk number 10: pcalgo
###################################################
pcGraph <- function(mat, alpha){
require(pcalg)
pcGr <- pcAlgo(t(mat), alpha=alpha)
pcGr <- pcGr@graph
nodes(pcGr) <- rownames(mat)
return(pcGr)
}
pcGr <- pcGraph(mat_B, alpha=0.05)
plot(pcGr, main="B-cell ALL")


###################################################
### code chunk number 11: pcalgo
###################################################
plot(pcGr, main="B-cell ALL")


###################################################
### code chunk number 12: lassoGraph
###################################################
lassoGraph <- function(matrix, rho){
library(glasso)
c <- cov(t(matrix))
gl <- glasso(c, rho=rho, zero=NULL, thr=1.0e-4,
      maxit=1e4, approx=F, penalize.diagonal=TRUE)
wi <- gl$wi
for(i in 1:length(wi[1,])){
for(j in 1:length(wi[,1])){
if(wi[j,i]!=0) {
wi[j,i]=1
}

}
}
diag(wi)=0
g_las <- as(wi,"graphNEL")
nodes(g_las) <- rownames(matrix)
return(g_las)
}


###################################################
### code chunk number 13: glasso
###################################################
lassoGr <- lassoGraph(mat_B,0.15)
plot(lassoGr, main="B-cell ALL")


###################################################
### code chunk number 14: glasso
###################################################
plot(lassoGr, main="B-cell ALL")


###################################################
### code chunk number 15: compare2Graphs1
###################################################
library(graphComp)
Ragr <- compare2Graphs(list(geneNetGr, pcGr), cexx=1.5, 
graphTitle="The comparative graph of the GeneNet and PC graphs",
legendGr1="Edges of GeneNet graph", 
legendGr2="Edges of the PC graph")


###################################################
### code chunk number 16: compare2Graphs1
###################################################
compare2Graphs(list(geneNetGr, pcGr), cexx=1.5, 
graphTitle="The comparative graph of the GeneNet and PC graphs",  
legendGr1="Edges of GeneNet graph", 
legendGr2="Edges of PC graph")


###################################################
### code chunk number 17: compare2Graphs2
###################################################
compare2Graphs(list(pcGr, lassoGr), cexx=1.5,
graphTitle="The comparative graph of the PC and glasso graphs",
legendGr1="Edges of PC",legendGr2="Edges of glasso graph",
legendPosition="bottomleft")


###################################################
### code chunk number 18: compare2Graphs2
###################################################
compare2Graphs(list(pcGr, lassoGr), cexx=1.5,  
graphTitle="The comparative graph of the PC and glasso graphs", 
legendGr1="Edges of PC graph",legendGr2="Edges of glasso graph", 
legendPosition="bottomleft")


###################################################
### code chunk number 19: compare2Graphs3
###################################################
compare2Graphs(list(geneNetGr, lassoGr), cexx=1.5,
graphTitle="The comparative graph of the GeneNet and glasso graphs", 
legendGr1="Edges of GeneNet graph",
legendGr2="Edges of glasso graph")


###################################################
### code chunk number 20: compare2Graphs3
###################################################
compare2Graphs(list(geneNetGr, lassoGr), cexx=1.5, 
graphTitle="The comparative graph of the GeneNet and glasso graphs",  
legendGr1="Edges of GeneNet graph",
legendGr2="Edges of glasso graph")       


###################################################
### code chunk number 21: options1
###################################################
options(width=70)


###################################################
### code chunk number 22: get.edges1
###################################################
get.edges(Ragr, EdgColor="blue")


###################################################
### code chunk number 23: get.edges2
###################################################
get.edges(Ragr, EdgColor="green4")


###################################################
### code chunk number 24: get.edges3
###################################################
get.edges(Ragr, EdgColor="red")


###################################################
### code chunk number 25: options2
###################################################
options(width=70)


###################################################
### code chunk number 26: get.hubs1
###################################################
get.hubs(Ragr,color="blue", p=30)


###################################################
### code chunk number 27: get.hubs11
###################################################
get.hubs(Ragr, color="green4", p=30)


###################################################
### code chunk number 28: get.hubs111
###################################################
get.hubs(Ragr, color="green4", p=5)


###################################################
### code chunk number 29: options3
###################################################
options(width=70)


###################################################
### code chunk number 30: get.hubs2
###################################################
get.hubs(Ragr, color="red", p=30)
get.hubs(Ragr, color="red", p=5)


###################################################
### code chunk number 31: getMixed.hubs1
###################################################
getMixed.hubs(Ragr, p=30)                                                                    
getMixed.hubs(Ragr, p=5)


###################################################
### code chunk number 32: options4
###################################################
options(width=70)


###################################################
### code chunk number 33: sessioninfo
###################################################
sessionInfo()


