### R code from vignette source 'st.Rnw'

###################################################
### code chunk number 1: st.Rnw:87-91
###################################################
library(spacetime)
rm(list = ls())
data(air)
ls()


###################################################
### code chunk number 2: st.Rnw:100-104
###################################################
rr = rural[,"2005::2010"]
unsel = which(apply(as(rr, "xts"), 2, function(x) all(is.na(x))))
r5to10 = rr[-unsel,]
summary(r5to10)


###################################################
### code chunk number 3: st.Rnw:108-110
###################################################
rn = row.names(r5to10@sp)[4:7]
rn


###################################################
### code chunk number 4: st.Rnw:115-120 (eval = FALSE)
###################################################
## par(mfrow=c(2,2))
## # select 4, 5, 6, 7
## for(i in rn) 
## 	acf(na.omit(r5to10[i,]), main = i)
## par(mfrow=c(1,1))


###################################################
### code chunk number 5: st.Rnw:125-130
###################################################
par(mfrow=c(2,2))
# select 4, 5, 6, 7
rn = row.names(r5to10@sp)[4:7]
for(i in rn) 
	acf(na.omit(r5to10[i,]), main = i)


###################################################
### code chunk number 6: st.Rnw:139-140 (eval = FALSE)
###################################################
## acf(na.omit(as(r5to10[rn,], "xts")))


###################################################
### code chunk number 7: st.Rnw:145-146
###################################################
acf(na.omit(as(r5to10[rn,], "xts")))


###################################################
### code chunk number 8: st.Rnw:170-171 (eval = FALSE)
###################################################
## acf(na.omit(as(r5to10[4:10,], "xts")))


###################################################
### code chunk number 9: st.Rnw:176-177
###################################################
print(spDists(r5to10[4:10,]@sp), digits=3)


###################################################
### code chunk number 10: st.Rnw:184-185
###################################################
rs = sample(dim(r5to10)[2], 100)


###################################################
### code chunk number 11: st.Rnw:190-192
###################################################
lst = lapply(rs, function(i) { x = r5to10[,i]; x$ti = i; x} )
pts = do.call(rbind, lst)


###################################################
### code chunk number 12: st.Rnw:195-197
###################################################
library(gstat)
v = variogram(PM10~ti, pts[!is.na(pts$PM10),], dX=0)


###################################################
### code chunk number 13: st.Rnw:200-203 (eval = FALSE)
###################################################
## plot(v, fit.variogram(v, vgm(1, "Exp", 200, 1)))
## vmod = fit.variogram(v, vgm(1, "Exp", 200, 1))
## plot(v, vmod)


###################################################
### code chunk number 14: st.Rnw:207-210
###################################################
plot(v, fit.variogram(v, vgm(1, "Exp", 200, 1)))
vmod = fit.variogram(v, vgm(1, "Exp", 200, 1))
print(plot(v, vmod))


###################################################
### code chunk number 15: st.Rnw:218-219
###################################################
vmod


###################################################
### code chunk number 16: st.Rnw:224-225
###################################################
dim(r5to10)


###################################################
### code chunk number 17: st.Rnw:230-231 (eval = FALSE)
###################################################
## vv = variogram(PM10~1, r5to10, width=20, cutoff = 200)


###################################################
### code chunk number 18: st.Rnw:236-237 (eval = FALSE)
###################################################
## vv = variogram(PM10~1, r5to10[,1:200], width=20, cutoff = 200)


###################################################
### code chunk number 19: st.Rnw:243-244
###################################################
data(vv)


###################################################
### code chunk number 20: st.Rnw:248-250 (eval = FALSE)
###################################################
## plot(vv, ylab = "time lag (days)")
## plot(vv, map = FALSE, ylab = "time lag (days)")


###################################################
### code chunk number 21: st.Rnw:254-256
###################################################
print(plot(vv, ylab = "time lag (days)"), split = c(1,1,1,2), more = TRUE)
print(plot(vv, map = FALSE, ylab = "time lag (days)"), split = c(1,2,1,2))


###################################################
### code chunk number 22: st.Rnw:267-282
###################################################
ExpVgmMetric = function(x, s, t, nugget = 0) {
	h = sqrt(s^2 + (x[3] * as.numeric(t))^2)
	ifelse(h == 0, 0, nugget + x[1] * (1 - exp(-h / x[2])))
}
ExpFitFn = function(x, gfn, v, trace = FALSE, ...) {
	mod = gfn(x, v$spacelag, v$timelag, ...)
	resid = v$gamma - mod
	if (trace)
		print(c(x, MSE = mean(resid^2)))
	mean(resid^2)
}

pars.M = optim(c(sill = 50, range = 100, anis = 50), ExpFitFn, 
	gfn = ExpVgmMetric, v = vv, nugget = 10)
pars.M$par


###################################################
### code chunk number 23: st.Rnw:285-287 (eval = FALSE)
###################################################
## vv$model = ExpVgmMetric(pars.M$par, vv$spacelag, vv$timelag, nugget = 10)
## plot(vv)


###################################################
### code chunk number 24: st.Rnw:292-294
###################################################
vv$model = ExpVgmMetric(pars.M$par, vv$spacelag, vv$timelag, nugget = 10)
print(plot(vv))


###################################################
### code chunk number 25: st.Rnw:302-313
###################################################
ExpVgmSeparable = function(x, s, t, nugget = 0) {
	#h = s/x[2] + as.numeric(t)/x[3]
	#ifelse(h == 0, 0, nugget + x[1] * (1 - exp(-h)))
	h = s/x[2] + as.numeric(t)/x[3]
	ifelse(h == 0, 0, nugget + x[1] * (1 - exp(-h)))
}
pars.S = optim(c(sill = 40, srange = 90, trange = 2), ExpFitFn,
	gfn = ExpVgmSeparable, v = vv, nugget = 10)
vv$model = ExpVgmSeparable(pars.S$par, vv$spacelag, vv$timelag, nugget = 10)
pars.S$par
plot(vv)


###################################################
### code chunk number 26: st.Rnw:318-320
###################################################
vv$model = ExpVgmSeparable(pars.S$par, vv$spacelag, vv$timelag, nugget = 10)
print(plot(vv))


###################################################
### code chunk number 27: st.Rnw:327-330 (eval = FALSE)
###################################################
## library(lattice)
## wireframe(gamma~spacelag*timelag, vv, drape=TRUE, 
## 	col.regions=bpy.colors)


###################################################
### code chunk number 28: st.Rnw:335-338
###################################################
library(lattice)
print(wireframe(gamma-model~spacelag*timelag, vv, drape=TRUE, 
	col.regions=bpy.colors()))


###################################################
### code chunk number 29: st.Rnw:359-360 (eval = FALSE)
###################################################
## demo(gstat3D)


