### R code from vignette source 'hwde.Rnw'

###################################################
### code chunk number 1: hwde.Rnw:38-39
###################################################
options(show.signif.stars=FALSE)


###################################################
### code chunk number 2: hwde.Rnw:41-46
###################################################
obs <- c(AA=147, Aa=78, aa=17)
oset <- c(0, log(2), 0)
ma <- c(0,1,2)
hw.glm <- glm(obs ~ ma, family=poisson, offset=oset)
summary(hw.glm)


###################################################
### code chunk number 3: hwde.Rnw:52-53
###################################################
hwdat <- data.frame(Observed=c(147,78,17), locus1=c("AA","Aa","aa"))


###################################################
### code chunk number 4: hwde.Rnw:56-58
###################################################
library(hwde)
hwde(data=hwdat)


###################################################
### code chunk number 5: maa
###################################################
data.df <- hwde(data = hwdat)$data.df
names(data.df)
summary(glm(obs ~ a + aa, offset=oset, family=poisson, data=data.df))$coef


###################################################
### code chunk number 6: hwde.Rnw:122-123 (eval = FALSE)
###################################################
## hwde(data=mendelABC, loci=c("seedshape","cotylcolor","coatcolor"))


###################################################
### code chunk number 7: hwde.Rnw:146-147 (eval = FALSE)
###################################################
## hwdat <- read.table("hw.txt", header=TRUE)


###################################################
### code chunk number 8: hwde.Rnw:188-189 (eval = FALSE)
###################################################
## IndianIrish <- read.table("IndianIrish.txt", header=TRUE)


###################################################
### code chunk number 9: hwde.Rnw:191-192
###################################################
hwde(data=IndianIrish)


###################################################
### code chunk number 10: hwde.Rnw:200-201 (eval = FALSE)
###################################################
## hwde(data=IndianIrish, group.terms=FALSE)


###################################################
### code chunk number 11: all9
###################################################
II.hwde <- hwde(data = mendelABC, loci = c("seedshape", "cotylcolor", 
              "coatcolor"), keep.models=T)
models <- II.hwde$models
maxmodel <- models[[length(models)]]
summary(maxmodel)$coef


###################################################
### code chunk number 12: hwde.Rnw:222-225
###################################################
hwdat.hw <- hwde(data=hwdat)
names(hwdat)
hwdat.hw$data.df


###################################################
### code chunk number 13: hwde.Rnw:230-234
###################################################
data.df <- hwdat.hw$data.df
model1 <- glm(obs ~ a, family=poisson, data=data.df, offset=log(oset))
model2 <- glm(obs ~ a+aa, family=poisson, data=data.df, offset=log(oset))
model1


###################################################
### code chunk number 14: hwde.Rnw:238-241
###################################################
II.hw <- hwde(data=IndianIrish, aovtable.print=FALSE)
dataII.df <- II.hw$data.df
dataII.df


###################################################
### code chunk number 15: hwde.Rnw:250-251
###################################################
hwde(termlist=c("+a","+aa"), refmodel=c(1,2), data=hwdat)


###################################################
### code chunk number 16: hwde.Rnw:257-259
###################################################
hwde(termlist=c("+gp","+a","+b","+a+b","+aa"), refmodel=c(1,2,2,2,5), 
     data=IndianIrish)


###################################################
### code chunk number 17: hwde.Rnw:267-270
###################################################
hwdat.hw <- hwde(data=hwdat, keep.models=TRUE)
hwdat.hw$models[[2]]          # The Hardy-Weinberg model
fitted(hwdat.hw$models[[2]])


