### R code from vignette source 'hydroTSM_Vignette.Rnw'

###################################################
### code chunk number 1: hydroTSM_Vignette.Rnw:23-24 (eval = FALSE)
###################################################
## install.packages("hydroTSM")


###################################################
### code chunk number 2: hydroTSM_Vignette.Rnw:34-35
###################################################
library(hydroTSM)


###################################################
### code chunk number 3: hydroTSM_Vignette.Rnw:40-41
###################################################
data(SanMartinoPPts)


###################################################
### code chunk number 4: hydroTSM_Vignette.Rnw:46-47
###################################################
x <- window(SanMartinoPPts, start=as.Date("1985-01-01"))


###################################################
### code chunk number 5: hydroTSM_Vignette.Rnw:51-52
###################################################
( m <- daily2monthly(x, FUN=sum) )


###################################################
### code chunk number 6: hydroTSM_Vignette.Rnw:56-57
###################################################
dates <- time(x)


###################################################
### code chunk number 7: hydroTSM_Vignette.Rnw:61-62
###################################################
( nyears <- yip(from=start(x), to=end(x), out.type="nmbr" ) )


###################################################
### code chunk number 8: hydroTSM_Vignette.Rnw:74-75
###################################################
smry(x)


###################################################
### code chunk number 9: hydroTSM_Vignette.Rnw:82-83
###################################################
hydroplot(x, var.type="Precipitation", main="at San Martino", pfreq = "dm", from="1987-01-01")


###################################################
### code chunk number 10: hydroTSM_Vignette.Rnw:88-89
###################################################
dwi(x)


###################################################
### code chunk number 11: hydroTSM_Vignette.Rnw:93-94
###################################################
dwi(x, out.unit="mpy")


###################################################
### code chunk number 12: hydroTSM_Vignette.Rnw:100-112
###################################################
# Daily zoo to monthly zoo
m <- daily2monthly(x, FUN=sum, na.rm=TRUE)
     
# Creating a matrix with monthly values per year in each column
M <- matrix(m, ncol=12, byrow=TRUE)
colnames(M) <- month.abb
rownames(M) <- unique(format(time(m), "%Y"))
     
# Plotting the monthly precipitation values
require(lattice)
matrixplot(M, ColorRamp="Precipitation", 
           main="Monthly precipitation at San Martino st., [mm/month]")


###################################################
### code chunk number 13: hydroTSM_Vignette.Rnw:125-126
###################################################
daily2annual(x, FUN=sum, na.rm=TRUE)


###################################################
### code chunk number 14: hydroTSM_Vignette.Rnw:133-134
###################################################
mean( daily2annual(x, FUN=sum, na.rm=TRUE) )


###################################################
### code chunk number 15: hydroTSM_Vignette.Rnw:143-144
###################################################
annualfunction(x, FUN=sum, na.rm=TRUE) / nyears


###################################################
### code chunk number 16: hydroTSM_Vignette.Rnw:158-159
###################################################
monthlyfunction(m, FUN=median, na.rm=TRUE)


###################################################
### code chunk number 17: hydroTSM_Vignette.Rnw:163-164
###################################################
cmonth <- format(time(m), "%b")


###################################################
### code chunk number 18: hydroTSM_Vignette.Rnw:168-169
###################################################
months <- factor(cmonth, levels=unique(cmonth), ordered=TRUE)


###################################################
### code chunk number 19: hydroTSM_Vignette.Rnw:173-175
###################################################
boxplot( coredata(m) ~ months, col="lightblue", main="Monthly Precipitation", 
         ylab="Precipitation, [mm]", xlab="Month")


###################################################
### code chunk number 20: hydroTSM_Vignette.Rnw:190-191
###################################################
seasonalfunction(x, FUN=sum, na.rm=TRUE) / nyears


###################################################
### code chunk number 21: hydroTSM_Vignette.Rnw:195-199
###################################################
( DJF <- dm2seasonal(x, season="DJF", FUN=sum) )
( MAM <- dm2seasonal(m, season="MAM", FUN=sum) )
( JJA <- dm2seasonal(m, season="JJA", FUN=sum) )
( SON <- dm2seasonal(m, season="SON", FUN=sum) )


###################################################
### code chunk number 22: hydroTSM_Vignette.Rnw:204-205
###################################################
hydroplot(x, pfreq="seasonal", FUN=sum, stype="default")


###################################################
### code chunk number 23: hydroTSM_Vignette.Rnw:214-217
###################################################
sessionInfo()$platform
sessionInfo()$R.version$version.string 
paste("hydroTSM", sessionInfo()$otherPkgs$hydroTSM$Version)


