### R code from vignette source 'lpSolveAPI.Rnw'

###################################################
### code chunk number 1: lpSolveAPI.Rnw:53-54 (eval = FALSE)
###################################################
## install.packages("lpSolveAPI")


###################################################
### code chunk number 2: lpSolveAPI.Rnw:59-60
###################################################
library(lpSolveAPI)


###################################################
### code chunk number 3: lpSolveAPI.Rnw:73-74 (eval = FALSE)
###################################################
## help(add.constraint)


###################################################
### code chunk number 4: lpSolveAPI.Rnw:79-80 (eval = FALSE)
###################################################
## ls("package:lpSolveAPI")


###################################################
### code chunk number 5: lpSolveAPI.Rnw:90-91
###################################################
my.lp <- make.lp(3, 2)


###################################################
### code chunk number 6: lpSolveAPI.Rnw:99-100
###################################################
my.lp


###################################################
### code chunk number 7: lpSolveAPI.Rnw:118-124
###################################################
set.column(my.lp, 1, c(1, 1, 2))
set.column(my.lp, 2, c(3, 1, 0))
set.objfn(my.lp, c(-2, -1))
set.constr.type(my.lp, rep("<=", 3))
set.rhs(my.lp, c(4, 2, 3))
my.lp


###################################################
### code chunk number 8: lpSolveAPI.Rnw:137-138
###################################################
x <- make.lp(2, 2)


###################################################
### code chunk number 9: lpSolveAPI.Rnw:143-144
###################################################
y <- x


###################################################
### code chunk number 10: lpSolveAPI.Rnw:149-151
###################################################
set.column(x, 1, c(1, 2))
set.column(x, 2, c(3, 4))


###################################################
### code chunk number 11: lpSolveAPI.Rnw:156-157
###################################################
y


###################################################
### code chunk number 12: lpSolveAPI.Rnw:181-182
###################################################
lprec <- make.lp(3, 4)


###################################################
### code chunk number 13: lpSolveAPI.Rnw:187-188
###################################################
set.column(lprec, 1, c(0.0, 0.24, 12.68))


###################################################
### code chunk number 14: lpSolveAPI.Rnw:193-196
###################################################
set.column(lprec, 2, 78.26, indices = 1)
set.column(lprec, 3, c(11.31, 0.08), indices = 2:3)
set.column(lprec, 4, c(2.9, 0.9), indices = c(1, 3))


###################################################
### code chunk number 15: lpSolveAPI.Rnw:201-204
###################################################
set.objfn(lprec, c(1.0, 3.0, 6.24, 0.1))
set.constr.type(lprec, c(">=", "<=", ">="))
set.rhs(lprec, c(92.3, 14.8, 4))


###################################################
### code chunk number 16: lpSolveAPI.Rnw:209-211
###################################################
set.type(lprec, 2, "integer")
set.type(lprec, 3, "binary")


###################################################
### code chunk number 17: lpSolveAPI.Rnw:216-218
###################################################
set.bounds(lprec, lower = c(28.6, 18), columns = c(1, 4))
set.bounds(lprec, upper = 48.98, columns = 4)


###################################################
### code chunk number 18: lpSolveAPI.Rnw:223-226
###################################################
RowNames <- c("THISROW", "THATROW", "LASTROW")
ColNames <- c("COLONE", "COLTWO", "COLTHREE", "COLFOUR")
dimnames(lprec) <- list(RowNames, ColNames)


###################################################
### code chunk number 19: lpSolveAPI.Rnw:231-232
###################################################
lprec  # or equivalently print(lprec)


###################################################
### code chunk number 20: lpSolveAPI.Rnw:237-238
###################################################
solve(lprec)


###################################################
### code chunk number 21: lpSolveAPI.Rnw:243-244
###################################################
get.objective(lprec)


###################################################
### code chunk number 22: lpSolveAPI.Rnw:247-248
###################################################
get.variables(lprec)


###################################################
### code chunk number 23: lpSolveAPI.Rnw:251-252
###################################################
get.constraints(lprec)


###################################################
### code chunk number 24: lpSolveAPI.Rnw:257-258 (eval = FALSE)
###################################################
## help(solve.lpExtPtr)


###################################################
### code chunk number 25: lpSolveAPI.Rnw:263-265
###################################################
status <- add.constraint(lprec, 1:4, ">=", 5)
status


