### R code from vignette source 'missForest_1.2.Rnw'

###################################################
### code chunk number 1: setRopts
###################################################
library(randomForest)
library(missForest)
options(width=70, prompt="> ", continue="+ ")
options(SweaveHooks=list(fig=function() par(mar=c(4,4,0.4,0.7)))) 


###################################################
### code chunk number 2: missForest_1.2.Rnw:81-82 (eval = FALSE)
###################################################
## install.packages(missForest, dependencies = TRUE)


###################################################
### code chunk number 3: missForest_1.2.Rnw:116-117 (eval = FALSE)
###################################################
## library(missForest)


###################################################
### code chunk number 4: missForest_1.2.Rnw:123-124
###################################################
set.seed(81)


###################################################
### code chunk number 5: iris.mis
###################################################
data(iris)
iris.mis <- prodNA(iris, noNA = 0.1)
summary(iris.mis)


###################################################
### code chunk number 6: missForest_1.2.Rnw:138-139
###################################################
set.seed(81)


###################################################
### code chunk number 7: iris.imp
###################################################
iris.imp <- missForest(iris.mis)


###################################################
### code chunk number 8: irisOOBerr
###################################################
iris.imp$OOBerror


###################################################
### code chunk number 9: irisOOBvarwise
###################################################
iris.imp <- missForest(iris.mis, variablewise = TRUE)
iris.imp$OOBerror


###################################################
### code chunk number 10: iris.imp.verb
###################################################
set.seed(81)
iris.imp <- missForest(iris.mis, verbose = TRUE)


###################################################
### code chunk number 11: missForest_1.2.Rnw:230-231
###################################################
iris.imp$OOBerror


###################################################
### code chunk number 12: missForest_1.2.Rnw:255-256
###################################################
set.seed(84)


###################################################
### code chunk number 13: esophExample
###################################################
data(esoph)
esoph.mis <- prodNA(esoph, 0.05)
set.seed(96)
esoph.imp <- missForest(esoph.mis, verbose = TRUE)


###################################################
### code chunk number 14: maxiterEsoph
###################################################
set.seed(96)
esoph.imp <- missForest(esoph.mis, verbose = TRUE, maxiter = 6)


###################################################
### code chunk number 15: muskData
###################################################
X <- scan('http://stat.ethz.ch/Teaching/Datasets/musk.dat', what = 'character', sep =',')
X <- matrix(X, ncol = 169, byrow=TRUE)
rowlabels <- X[,1]
X <- X[,-c(1,2)] #remove molecule names and conformations
X <- X[,-167] #remove response
musk <- matrix(as.numeric(X), ncol = 166)


###################################################
### code chunk number 16: muskBigNtree (eval = FALSE)
###################################################
## musk.mis <- prodNA(musk, 0.05)
## musk.imp <- missForest(musk.mis, verbose = TRUE, maxiter = 3)


###################################################
### code chunk number 17: muskSmallNtree (eval = FALSE)
###################################################
## musk.imp <- missForest(musk.mis, verbose = TRUE, maxiter = 3, ntree = 20)


###################################################
### code chunk number 18: irisStrategy (eval = FALSE)
###################################################
## iris.mis <- prodNA(iris, noNA = 0.1)
## iris.imp <- missForest(iris.mis)


###################################################
### code chunk number 19: irisStrategy2
###################################################
iris.err <- mixError(iris.imp$ximp, iris.mis, iris)
print(iris.err)


###################################################
### code chunk number 20: irisError (eval = FALSE)
###################################################
## iris.err <- mixError(iris.imp, iris.mis, iris)


###################################################
### code chunk number 21: missForest_1.2.Rnw:435-436
###################################################
set.seed(81)


###################################################
### code chunk number 22: irisPerfom
###################################################
iris.imp <- missForest(iris.mis, xtrue = iris, verbose = TRUE)


###################################################
### code chunk number 23: errorDirect
###################################################
iris.imp$error


