### R code from vignette source 'Trees.Rnw'

###################################################
### code chunk number 1: Trees.Rnw:44-46
###################################################
options(width=70)
foo <- packageDescription("phangorn")


###################################################
### code chunk number 2: Trees.Rnw:62-64
###################################################
library(phangorn)
primates = read.phyDat("primates.dna", format="phylip", type="DNA")


###################################################
### code chunk number 3: Trees.Rnw:71-74
###################################################
dm = dist.dna(as.DNAbin(primates))
treeUPGMA = upgma(dm)
treeNJ = NJ(dm)


###################################################
### code chunk number 4: plotNJ
###################################################
layout(matrix(c(1,2), 2, 1), height=c(1,2))
par(mar = c(.1,.1,.1,.1))
plot(treeUPGMA, main="UPGMA")
plot(treeNJ, "unrooted", main="NJ")


###################################################
### code chunk number 5: figNJ
###################################################
layout(matrix(c(1,2), 2, 1), height=c(1,2))
par(mar = c(.1,.1,.1,.1))
plot(treeUPGMA, main="UPGMA")
plot(treeNJ, "unrooted", main="NJ")


###################################################
### code chunk number 6: Trees.Rnw:96-98
###################################################
parsimony(treeUPGMA, primates)
parsimony(treeNJ, primates)


###################################################
### code chunk number 7: Trees.Rnw:101-104
###################################################
treePars = optim.parsimony(treeUPGMA, primates)
treeRatchet = pratchet(primates, trace = 0)
parsimony(c(treePars, treeRatchet), primates)


###################################################
### code chunk number 8: Trees.Rnw:107-108
###################################################
(trees <- bab(subset(primates,1:10)))


###################################################
### code chunk number 9: Trees.Rnw:114-116
###################################################
fit = pml(treeNJ, data=primates)
fit


###################################################
### code chunk number 10: Trees.Rnw:119-120
###################################################
methods(class="pml")


###################################################
### code chunk number 11: Trees.Rnw:123-125
###################################################
fitJC = optim.pml(fit, TRUE)
logLik(fitJC)


###################################################
### code chunk number 12: Trees.Rnw:128-132
###################################################
fitGTR = update(fit, k=4, inv=0.2) 
fitGTR = optim.pml(fitGTR, TRUE,TRUE, TRUE, TRUE, TRUE, 
    control = pml.control(trace = 0))
fitGTR 


###################################################
### code chunk number 13: Trees.Rnw:135-136
###################################################
anova(fitJC, fitGTR) 


###################################################
### code chunk number 14: Trees.Rnw:139-141
###################################################
AIC(fitGTR) 
AIC(fitJC)


###################################################
### code chunk number 15: Trees.Rnw:144-145
###################################################
SH.test(fitGTR, fitJC) 


###################################################
### code chunk number 16: Trees.Rnw:148-149
###################################################
mt = modelTest(primates)


###################################################
### code chunk number 17: Trees.Rnw:153-155
###################################################
library(xtable)
xtable(mt, caption="Summary table of modelTest", label="tab:modelTest")


###################################################
### code chunk number 18: Trees.Rnw:159-162
###################################################
env <- attr(mt, "env")
ls(envir=env)
(fit <- eval(get("HKY+G+I", env), env))


###################################################
### code chunk number 19: Trees.Rnw:166-168
###################################################
bs = bootstrap.pml(fitJC, bs=100, optNni=TRUE, 
    control = pml.control(trace = 0))


###################################################
### code chunk number 20: plotBS
###################################################
par(mar=c(.1,.1,.1,.1))
plotBS(fitJC$tree, bs)


###################################################
### code chunk number 21: figBS
###################################################
par(mar=c(.1,.1,.1,.1))
plotBS(fitJC$tree, bs)


###################################################
### code chunk number 22: Trees.Rnw:192-194
###################################################
options(prompt=" ")
options(continue="  ")


###################################################
### code chunk number 23: Trees.Rnw:196-216 (eval = FALSE)
###################################################
## library(multicore) # supports parallel computing
## library(phangorn)
## file="myfile"
## dat = read.phyDat(file)
## dm = dist.ml(dat)
## tree = NJ(dm)
## 
## # 1. alternative: estimate an GTR model
## fitStart = pml(tree, dat, k=4, inv=.2)
## fit = optim.pml(fitStart, TRUE, TRUE, TRUE, TRUE, TRUE) 
##  
## # 2. alternative: modelTest  
## (mt <- modelTest(dat, multicore=TRUE)) 
## # choose best model from the table, assume now GTR+G+I
## env = attr(mt, "env")
## fitStart = eval(get("GTR+G+I", env), env) 
##  
## fit = optim.pml(fitStart, optNni=TRUE, optGamma=TRUE, optInv=TRUE, 
##     model="GTR")
## bs = bootstrap.pml(fit, bs=100, optNni=TRUE, multicore=TRUE)


###################################################
### code chunk number 24: Trees.Rnw:220-230 (eval = FALSE)
###################################################
## library(multicore) # supports parallel computing
## library(phangorn)
## file="myfile"
## dat = read.phyDat(file, type = "AA")
## dm = dist.ml(dat, model="JTT")
## tree = NJ(dm)
## fitNJ = pml(tree, dat, model="JTT", k=4, inv=.2)
## fit = optim.pml(fitNJ, optNni=TRUE, optInv=TRUE, optGamma=TRUE)
## fit
## bs = bootstrap.pml(fit, bs=100, optNni=TRUE, multicore=TRUE)


###################################################
### code chunk number 25: Trees.Rnw:238-239
###################################################
toLatex(sessionInfo())


