### R code from vignette source 'phangorn-specials.Rnw'

###################################################
### code chunk number 1: phangorn-specials.Rnw:45-47
###################################################
options(width=80)
foo <- packageDescription("phangorn")


###################################################
### code chunk number 2: phangorn-specials.Rnw:66-72
###################################################
library(phangorn)
data = matrix(c("r","a","y","g","g","a","c","-","c","t","c","g", 
                "a","a","t","g","g","a","t","-","c","t","c","a",                                          
                "a","a","t","-","g","a","c","c","c","t","?","g"), 
                dimnames = list(c("t1", "t2", "t3"),NULL), nrow=3, byrow=TRUE)
data


###################################################
### code chunk number 3: phangorn-specials.Rnw:75-77
###################################################
gapsdata1 = phyDat(data)
gapsdata1


###################################################
### code chunk number 4: phangorn-specials.Rnw:80-82
###################################################
gapsdata2 = phyDat(data, type="USER", levels=c("a", "c", "g", "t", "-"), ambiguity = c("?", "n"))
gapsdata2


###################################################
### code chunk number 5: phangorn-specials.Rnw:90-104
###################################################
contrast = matrix(data = c(1,0,0,0,0,
    0,1,0,0,0,
    0,0,1,0,0,
    0,0,0,1,0,   
    1,0,1,0,0,
    0,1,0,1,0,
    0,0,0,0,1,
    1,1,1,1,0,
    1,1,1,1,1),
    ncol = 5, byrow = TRUE)
dimnames(contrast)  = list(c("a", "c", "g", "t", "r", "y", "-", "n", "?"), c("a", "c", "g", "t", "-"))
contrast
gapsdata3 = phyDat(data, type="USER", contrast=contrast)
gapsdata3 


###################################################
### code chunk number 6: phangorn-specials.Rnw:135-139
###################################################
tree = unroot(rtree(3))
fit = pml(tree, gapsdata3)
fit = optim.pml(fit, optQ=TRUE, subs=c(1,0,1,2,1,0,2,1,2,2), control=pml.control(trace=0))
fit


###################################################
### code chunk number 7: phangorn-specials.Rnw:189-190
###################################################
trees = allTrees(5)


###################################################
### code chunk number 8: plotAll
###################################################
par(mfrow =c(3,5), mar = c(2,2,2,2)-2)
for(i in 1:15)plot(trees[[i]], cex=1, type="u")


###################################################
### code chunk number 9: figAll
###################################################
par(mfrow =c(3,5), mar = c(2,2,2,2)-2)
for(i in 1:15)plot(trees[[i]], cex=1, type="u")


###################################################
### code chunk number 10: phangorn-specials.Rnw:218-219
###################################################
toLatex(sessionInfo())


