### R code from vignette source 'phylobase.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: randtree1
###################################################
library(ape)
set.seed(1)  ## set random-number seed
rand_tree <- rcoal(10) ## Make a random tree with 10 tips
plot(rand_tree)


###################################################
### code chunk number 2: convtree
###################################################
library(phylobase)
# convert rand_tree to a phylo4 object
rand_p4_tree <- as(rand_tree, "phylo4")
plot(rand_p4_tree)


###################################################
### code chunk number 3: doc0 (eval = FALSE)
###################################################
## ?plot(rand_p4_tree)


###################################################
### code chunk number 4: doc1 (eval = FALSE)
###################################################
## method?plot("phylo4")


###################################################
### code chunk number 5: doc2 (eval = FALSE)
###################################################
## help('Documentation', package="methods")


###################################################
### code chunk number 6: geodata
###################################################
library(phylobase)
data(geospiza_raw)
## what does it contain?
names(geospiza_raw)


###################################################
### code chunk number 7: convgeodata
###################################################
(g1 <- as(geospiza_raw$tree, "phylo4"))


###################################################
### code chunk number 8: nodelabelgeodata
###################################################
nodeLabels(g1)


###################################################
### code chunk number 9: phylobase.Rnw:134-136
###################################################
nodeLabels(g1) <- paste("N", nodeId(g1, "internal"), sep="")
head(g1, 5)


###################################################
### code chunk number 10: sumgeodata
###################################################
summary(g1)


###################################################
### code chunk number 11: tiplabelgeodata
###################################################
tipLabels(g1)


###################################################
### code chunk number 12: nodenumbergeodata
###################################################
nodeId(g1, type='all')


###################################################
### code chunk number 13: edgelabelgeodata
###################################################
edgeLabels(g1)


###################################################
### code chunk number 14: rootedgeodata
###################################################
isRooted(g1)


###################################################
### code chunk number 15: rootnodegeodata
###################################################
rootNode(g1)


###################################################
### code chunk number 16: polygeodata
###################################################
hasPoly(g1)


###################################################
### code chunk number 17: hasbrlengeodata
###################################################
hasEdgeLength(g1)


###################################################
### code chunk number 18: modlabelsgeodata
###################################################
tipLabels(g1) <- tolower(tipLabels(g1))


###################################################
### code chunk number 19: phylobase.Rnw:191-192 (eval = FALSE)
###################################################
## tipLabels(g1)[c(11, 13)] <- c("platyspiza", "pinaroloxias")


###################################################
### code chunk number 20: geomergedata (eval = FALSE)
###################################################
## g2 <- phylo4d(g1, geospiza_raw$data)


###################################################
### code chunk number 21: geomergeerr1
###################################################
g2 <- try(phylo4d(g1, geospiza_raw$data),silent=TRUE)
cat(as.character(g2))


###################################################
### code chunk number 22: geomergenames
###################################################
gdata <- geospiza_raw$data
row.names(gdata) <- tolower(row.names(gdata))


###################################################
### code chunk number 23: geomerge2
###################################################
g2 <- phylo4d(g1, gdata, missing.data="warn")


###################################################
### code chunk number 24: geomerge3
###################################################
g1B <- prune(g1, "olivacea")
phylo4d(g1B, gdata)


###################################################
### code chunk number 25: geomergesum
###################################################
summary(g2)


###################################################
### code chunk number 26: geoextract
###################################################
subset(g2, tips.include=c("fuliginosa", "fortis", "magnirostris",
            "conirostris", "scandens"))
subset(g2, node.subtree=21)
subset(g2, mrca=c("scandens", "fortis"))


###################################################
### code chunk number 27: geodrop
###################################################
try(
subset(g2, tips.exclude=c("fuliginosa", "fortis", "magnirostris",
            "conirostris", "scandens"))
    , silent=TRUE)
try(
subset(g2, tips.exclude=names(descendants(g2 ,MRCA(g2, c("difficilis", "fortis")))))
    , silent=TRUE)


###################################################
### code chunk number 28: rtree2
###################################################
set.seed(1001)
tree <- as(rcoal(12), "phylo4")


###################################################
### code chunk number 29: vcvphylo
###################################################
vmat <- as(tree, "phylo4vcov")
vmat <- cov2cor(vmat)
library(MASS)
trvec <- mvrnorm(1, mu=rep(0, 12), Sigma=vmat)


###################################################
### code chunk number 30: plotvcvphylo
###################################################
treed <- phylo4d(tree, tip.data=as.data.frame(trvec))
plot(treed)


###################################################
### code chunk number 31: phylobase.Rnw:327-348
###################################################
## add node labels so we can match to data
nodeLabels(tree) <- as.character(nodeId(tree, "internal"))
## ordering will make sure that we have ancestor value
## defined before descendant
tree <- reorder(tree, "preorder")
edgemat <- edges(tree)
## set aside space for values
nodevals <- numeric(nrow(edgemat))
## label data in edge matrix order
names(nodevals) <- labels(tree, "all")[nodeId(tree, "all")]
## variance is proportional to edge length; drop first
## element of edge length, which is NA
dvals <- rnorm(nrow(edgemat) - 1, sd=edgeLength(tree)[-1]^2)
## indexing: ind[node number] gives position in edge matrix
ind <- order(nodeId(tree, "all"))
for (i in 2:nrow(edgemat)) {
  ## value of ancestor node plus change
  nodevals[i] <- nodevals[ind[edgemat[i, 1]]] + dvals[i - 1]
  }
nodevals <- data.frame(nodevals)
treed2 <- phylo4d(tree, all.data=nodevals)


