### R code from vignette source 'PhyloSim.Rnw'

###################################################
### code chunk number 1: PhyloSim.Rnw:57-58
###################################################
options(width=90)


###################################################
### code chunk number 2: PhyloSim.Rnw:60-61
###################################################
library(phylosim)


###################################################
### code chunk number 3: PhyloSim.Rnw:65-67
###################################################
cat("((t1:0.3,t2:0.3):0.2,t3:0.1);",file="3taxa.nwk")
cat("((t1:0.3,t2:0.3):0.2,(t3:0.1,t4:0.1):0.4);",file="4taxa.nwk")


###################################################
### code chunk number 4: PhyloSim.Rnw:78-82
###################################################
Simulate(PhyloSim(
	root.seq=sampleStates( NucleotideSequence(len=50,proc=list(list(JC69())) )),
	phylo=read.tree("3taxa.nwk")
))$alignment


###################################################
### code chunk number 5: PhyloSim.Rnw:88-89
###################################################
root.seq<-NucleotideSequence(length=50)


###################################################
### code chunk number 6: PhyloSim.Rnw:93-94
###################################################
print(root.seq)


###################################################
### code chunk number 7: PhyloSim.Rnw:99-100
###################################################
p<-JC69()


###################################################
### code chunk number 8: PhyloSim.Rnw:104-105
###################################################
attachProcess(root.seq,p)


###################################################
### code chunk number 9: PhyloSim.Rnw:110-111
###################################################
sampleStates(root.seq)


###################################################
### code chunk number 10: PhyloSim.Rnw:115-116
###################################################
print(root.seq)


###################################################
### code chunk number 11: PhyloSim.Rnw:120-121
###################################################
tree<-read.tree("3taxa.nwk")


###################################################
### code chunk number 12: PhyloSim.Rnw:126-127
###################################################
plot(tree)


###################################################
### code chunk number 13: PhyloSim.Rnw:131-132
###################################################
sim<-PhyloSim()


###################################################
### code chunk number 14: PhyloSim.Rnw:136-137
###################################################
sim$phylo<-tree


###################################################
### code chunk number 15: PhyloSim.Rnw:141-142
###################################################
sim$rootSeq<-root.seq


###################################################
### code chunk number 16: PhyloSim.Rnw:146-147
###################################################
Simulate(sim)


###################################################
### code chunk number 17: PhyloSim.Rnw:151-152
###################################################
sim$alignment


###################################################
### code chunk number 18: PhyloSim.Rnw:158-161
###################################################
p<-HKY(rate.params=list( "Alpha"=10,"Beta"=2),
                     base.freqs=c(4,3,2,1)/10
   )


###################################################
### code chunk number 19: PhyloSim.Rnw:165-166
###################################################
plot(p,scale=0.5)


###################################################
### code chunk number 20: PhyloSim.Rnw:171-173
###################################################
root.len50.seq<-NucleotideSequence(length=50,processes=list(list(p)))
sampleStates(root.len50.seq)


###################################################
### code chunk number 21: PhyloSim.Rnw:177-178
###################################################
print(root.len50.seq)


###################################################
### code chunk number 22: PhyloSim.Rnw:182-186
###################################################
sim<-PhyloSim(
	root.seq=root.len50.seq,
	phylo=read.tree("3taxa.nwk")
);


###################################################
### code chunk number 23: PhyloSim.Rnw:190-191
###################################################
Simulate(sim)


###################################################
### code chunk number 24: PhyloSim.Rnw:195-196
###################################################
saveAlignment(sim,file="HKY_sim.fas")


###################################################
### code chunk number 25: PhyloSim.Rnw:198-199
###################################################
unlink("HKY_sim.fas")


###################################################
### code chunk number 26: PhyloSim.Rnw:203-204
###################################################
plot(sim,num.pages=1)


###################################################
### code chunk number 27: PhyloSim.Rnw:213-220
###################################################
         p<-GTR(
                     rate.params=list(
                             "a"=1, "b"=2, "c"=3,
                             "d"=1, "e"=2, "f"=3
                     ),
                     base.freqs=c(2,2,1,1)/6
             )


###################################################
### code chunk number 28: PhyloSim.Rnw:224-225
###################################################
summary(p)


###################################################
### code chunk number 29: PhyloSim.Rnw:230-231
###################################################
root.seq<-NucleotideSequence(length=50,processes=list( list(p) ))


###################################################
### code chunk number 30: PhyloSim.Rnw:237-238
###################################################
plusGamma(root.seq,p,0.5)


###################################################
### code chunk number 31: PhyloSim.Rnw:242-243
###################################################
getRateMultipliers(root.seq,p);


###################################################
### code chunk number 32: PhyloSim.Rnw:247-251
###################################################
sim<-PhyloSim(
	root.seq=sampleStates(root.seq),
	phylo=read.tree("3taxa.nwk")
)


###################################################
### code chunk number 33: PhyloSim.Rnw:255-256
###################################################
Simulate(sim)


###################################################
### code chunk number 34: PhyloSim.Rnw:260-261
###################################################
plot(sim,num.pages=1,plot.ancestors=FALSE)


###################################################
### code chunk number 35: PhyloSim.Rnw:265-266
###################################################
saveAlignment(sim,file="Gamma_sim.fas",skip.internal=TRUE)


###################################################
### code chunk number 36: PhyloSim.Rnw:268-269
###################################################
file.remove("Gamma_sim.fas")


###################################################
### code chunk number 37: PhyloSim.Rnw:278-280
###################################################
clearStates(root.seq)
sampleStates(root.seq)


###################################################
### code chunk number 38: PhyloSim.Rnw:284-285
###################################################
plusInvGamma(root.seq,p,pinv=0.8,shape=0.5)


###################################################
### code chunk number 39: PhyloSim.Rnw:289-296
###################################################
sim<-Simulate(
	PhyloSim(
		root.seq=root.seq,
		phylo=rcoal(3)
	)
)
plot(sim,num.pages=1,plot.ancestors=FALSE)


###################################################
### code chunk number 40: PhyloSim.Rnw:300-301
###################################################
saveAlignment(sim,file="InvGamma_sim.fas",skip.internal=TRUE)


###################################################
### code chunk number 41: PhyloSim.Rnw:303-304
###################################################
file.remove("InvGamma_sim.fas")


###################################################
### code chunk number 42: PhyloSim.Rnw:312-315
###################################################
p<-JC69()
root.seq<-NucleotideSequence(len=50,processes=list(list(p)))
sampleStates(root.seq)


###################################################
### code chunk number 43: PhyloSim.Rnw:320-325
###################################################
 d<-DiscreteDeletor(
                     rate=0.25,
                     sizes=c(1,2),
                     probs=c(1/2,1/2)
   )


###################################################
### code chunk number 44: PhyloSim.Rnw:330-335
###################################################
 i<-DiscreteInsertor(
                     rate=0.25,
                     sizes=c(1,2),
                     probs=c(1/2,1/2)
   )


###################################################
### code chunk number 45: PhyloSim.Rnw:339-340
###################################################
i$templateSeq<-NucleotideSequence(length=2,processes=list( list(p) ))


###################################################
### code chunk number 46: PhyloSim.Rnw:348-350
###################################################
attachProcess(root.seq,d)
attachProcess(root.seq,i)


###################################################
### code chunk number 47: PhyloSim.Rnw:354-358
###################################################
sim<-Simulate(PhyloSim(
	root.seq=root.seq,
	phylo=rcoal(3)
))


###################################################
### code chunk number 48: PhyloSim.Rnw:362-363
###################################################
plot(sim,num.pages=1,plot.ancestors=FALSE)


###################################################
### code chunk number 49: PhyloSim.Rnw:367-368
###################################################
saveAlignment(sim,file="indel1_sim.fas",skip.internal=TRUE)


###################################################
### code chunk number 50: PhyloSim.Rnw:370-371
###################################################
file.remove("indel1_sim.fas")


###################################################
### code chunk number 51: PhyloSim.Rnw:381-387
###################################################
 i2<-DiscreteInsertor(
                     rate=0.25,
                     sizes=c(1,2,3,4),
                     probs=c(1,2,3,4)/10,
		     template.seq=NucleotideSequence(string="C")	
   )


###################################################
### code chunk number 52: PhyloSim.Rnw:391-392
###################################################
clearStates(root.seq)


###################################################
### code chunk number 53: PhyloSim.Rnw:397-398
###################################################
root.seq$processes<-list(list(i2, d, p))


###################################################
### code chunk number 54: PhyloSim.Rnw:402-406
###################################################
sim<-Simulate(PhyloSim(
	root.seq=sampleStates(root.seq),
	phylo=read.tree("3taxa.nwk")
))


###################################################
### code chunk number 55: PhyloSim.Rnw:410-411
###################################################
plot(sim,num.pages=1,plot.ancestors=FALSE)


###################################################
### code chunk number 56: PhyloSim.Rnw:415-416
###################################################
saveAlignment(sim,file="indel2_sim.fas",skip.internal=TRUE)


###################################################
### code chunk number 57: PhyloSim.Rnw:418-419
###################################################
file.remove("indel2_sim.fas")


###################################################
### code chunk number 58: PhyloSim.Rnw:425-428
###################################################
p<-JC69()
root.seq<-NucleotideSequence(len=100,processes=list(list(p)))
sampleStates(root.seq)


###################################################
### code chunk number 59: PhyloSim.Rnw:433-438
###################################################
d<-DiscreteDeletor(
                     rate=1,
                     sizes=c(1,2,3),
                     probs=c(3/6,2/6,1/6)
)


###################################################
### code chunk number 60: PhyloSim.Rnw:443-448
###################################################
i<-DiscreteInsertor(
                     rate=1,
                     sizes=c(1,2,3),
                     probs=c(3/6,2/6,1/6)
)


###################################################
### code chunk number 61: PhyloSim.Rnw:452-453
###################################################
i$templateSeq<-NucleotideSequence(length=2,processes=list( list(p) ))


###################################################
### code chunk number 62: PhyloSim.Rnw:457-459
###################################################
attachProcess(root.seq,d)
attachProcess(root.seq,i)


###################################################
### code chunk number 63: PhyloSim.Rnw:463-464
###################################################
setDeletionTolerance(root.seq,d,0.08 + c(1/2:51,1/51:2))


###################################################
### code chunk number 64: PhyloSim.Rnw:468-469
###################################################
plotParametersAtSites(root.seq,d,"deletion.tolerance")


###################################################
### code chunk number 65: PhyloSim.Rnw:473-474
###################################################
setInsertionTolerance(root.seq,i,0.08 + c(1/2:51,1/51:2))


###################################################
### code chunk number 66: PhyloSim.Rnw:478-482
###################################################
sim<-Simulate(PhyloSim(
        root.seq=root.seq,
        phylo=read.tree("4taxa.nwk")
))


###################################################
### code chunk number 67: PhyloSim.Rnw:486-487
###################################################
plot(sim,plot.ancestors=FALSE)


###################################################
### code chunk number 68: PhyloSim.Rnw:491-492
###################################################
saveAlignment(sim,file="indel3_sim.fas",skip.internal=TRUE)


###################################################
### code chunk number 69: PhyloSim.Rnw:494-495
###################################################
file.remove("indel3_sim.fas")


###################################################
### code chunk number 70: PhyloSim.Rnw:515-519
###################################################
jc69<-JC69()
hky<-HKY(rate.params=list( "Alpha"=5,"Beta"=2),
                     base.freqs=c(4,3,2,1)/10
      )


###################################################
### code chunk number 71: PhyloSim.Rnw:523-524
###################################################
root.seq<-NucleotideSequence(length=100)


###################################################
### code chunk number 72: PhyloSim.Rnw:528-529
###################################################
attachProcess(root.seq,jc69,1:50)


###################################################
### code chunk number 73: PhyloSim.Rnw:533-534
###################################################
attachProcess(root.seq,hky,51:100)


###################################################
### code chunk number 74: PhyloSim.Rnw:538-543
###################################################
plusGamma(root.seq,jc69,1,1:25)
plusGamma(root.seq,jc69,0.5,26:50)

plusGamma(root.seq,hky,1,51:75)
plusGamma(root.seq,hky,0.5,76:100)


###################################################
### code chunk number 75: PhyloSim.Rnw:547-551
###################################################
sim<-Simulate(PhyloSim(
	root.seq=sampleStates(root.seq),
	phylo=rcoal(3)
))


###################################################
### code chunk number 76: PhyloSim.Rnw:555-556
###################################################
plot(sim,num.pages=1,plot.ancestors=FALSE)


###################################################
### code chunk number 77: PhyloSim.Rnw:562-564
###################################################
p<-F84(base.freqs=c(1,2,3,4));
p$kappa<-1;


###################################################
### code chunk number 78: PhyloSim.Rnw:568-569
###################################################
root.seq<-NucleotideSequence(length=50,processes=list(list(p)));


###################################################
### code chunk number 79: PhyloSim.Rnw:573-574
###################################################
plusGamma(root.seq,p,1)


###################################################
### code chunk number 80: PhyloSim.Rnw:578-579
###################################################
tree<-read.tree("4taxa.nwk")


###################################################
### code chunk number 81: PhyloSim.Rnw:584-588
###################################################
sim<-PhyloSim(
	root.seq=sampleStates(root.seq),
	phylo=tree
)


###################################################
### code chunk number 82: PhyloSim.Rnw:599-609
###################################################
node.hook <- function(seq) {

	if(!isAttached(seq$sites[[1]],p)){
		return(seq);
	}

	cat("Resampling rate multipliers!\n");
	plusGamma(seq,p,1)
	return(seq)
}


###################################################
### code chunk number 83: PhyloSim.Rnw:613-614
###################################################
plot(sim)


###################################################
### code chunk number 84: PhyloSim.Rnw:620-621
###################################################
attachHookToNode(sim, node = 6, fun = node.hook)


###################################################
### code chunk number 85: PhyloSim.Rnw:625-626
###################################################
Simulate(sim)


###################################################
### code chunk number 86: PhyloSim.Rnw:630-631
###################################################
plot(sim,num.pages=1,plot.ancestors=FALSE)


###################################################
### code chunk number 87: PhyloSim.Rnw:643-646
###################################################
p<-JC69();
root.seq<-NucleotideSequence(length=10)
attachProcess(root.seq,p)


###################################################
### code chunk number 88: PhyloSim.Rnw:650-651
###################################################
tree<-read.tree("3taxa.nwk");


###################################################
### code chunk number 89: PhyloSim.Rnw:655-669
###################################################
for(i in 1:3){
	cat(paste("\n\nSimulating replication ",i,"\n\n",sep=""))	

	clearStates(root.seq)
	plusGamma(root.seq,p,0.25)
	sampleStates(root.seq)

	sim<-Simulate(PhyloSim(
		root.seq=root.seq,
		phylo=tree	
	))	
	
	saveAlignment(sim,file=paste("aln_",i,".fas",sep=""))
}


###################################################
### code chunk number 90: PhyloSim.Rnw:672-675
###################################################
unlink("aln_1.fas");
unlink("aln_2.fas");
unlink("aln_3.fas");


###################################################
### code chunk number 91: PhyloSim.Rnw:690-693
###################################################
p<-JC69();
root.seq<-NucleotideSequence(length=50)
attachProcess(root.seq,p)


###################################################
### code chunk number 92: PhyloSim.Rnw:697-698
###################################################
tree<-read.tree("3taxa.nwk");


###################################################
### code chunk number 93: PhyloSim.Rnw:702-720
###################################################
sim.replicate<-function(i){
        name<-paste("replication_",i,sep="")
        clearStates(root.seq)
        plusGamma(root.seq,p,0.25)
        sampleStates(root.seq)

        sim<-Simulate(PhyloSim(
                name=name,
                root.seq=root.seq,
                phylo=tree,
        ),
            quiet=TRUE
        )

        saveAlignment(sim,file=paste("aln_",i,".fas",sep=""))
        return(sim)
        # return(TRUE)
}


###################################################
### code chunk number 94: PhyloSim.Rnw:731-736
###################################################
have.mcore <-  is.element("multicore", installed.packages()[,1])

if(have.mcore){
    library(multicore)
}


###################################################
### code chunk number 95: PhyloSim.Rnw:740-745
###################################################
if(have.mcore){
    nr.replicates<-3
    res.objects<-mclapply(1:nr.replicates, sim.replicate)
    print(res.objects)
}


###################################################
### code chunk number 96: PhyloSim.Rnw:749-752
###################################################
if(have.mcore){
    plot(res.objects[[1]])
}


###################################################
### code chunk number 97: PhyloSim.Rnw:755-761
###################################################
unlink("aln_1.fas");
unlink("aln_2.fas");
unlink("aln_3.fas");

unlink("3taxa.nwk");
unlink("4taxa.nwk");


###################################################
### code chunk number 98: PhyloSim.Rnw:767-768
###################################################
cat("(((t2:0.1231,t4:0.1231):0.2131,(t3:0.0284,t5:0.0284):0.3078):0.1698,t1:0.5060);",file="smalldemotree.nwk")


###################################################
### code chunk number 99: PhyloSim.Rnw:776-777
###################################################
ll(Site())


###################################################
### code chunk number 100: PhyloSim.Rnw:781-782
###################################################
PSIM_FAST <- TRUE


###################################################
### code chunk number 101: PhyloSim.Rnw:785-789
###################################################
wag <- WAG()
jtt <- JTT()
lg <- LG()
pam <- PAM()


###################################################
### code chunk number 102: PhyloSim.Rnw:792-793
###################################################
summary(wag)


###################################################
### code chunk number 103: PhyloSim.Rnw:796-797
###################################################
plot(wag, scale = 0.8)


###################################################
### code chunk number 104: PhyloSim.Rnw:801-803
###################################################
cont.del <- ContinuousDeletor(rate = 0.6, max.length = 10, 
    dist = expression(rnorm(1, mean = 5, sd = 3)))


###################################################
### code chunk number 105: PhyloSim.Rnw:806-807
###################################################
templ.seq.wag <- AminoAcidSequence(length = 10)


###################################################
### code chunk number 106: PhyloSim.Rnw:811-812
###################################################
templ.seq.lg <- clone(templ.seq.wag)


###################################################
### code chunk number 107: PhyloSim.Rnw:816-818
###################################################
cont.ins.wag <- ContinuousInsertor(rate = 0.6, max.length = 10, 
    dist = expression(rnorm(1, mean = 5, sd = 3)))


###################################################
### code chunk number 108: PhyloSim.Rnw:822-824
###################################################
cont.ins.lg <- ContinuousInsertor(rate = 0.6, max.length = 10, 
    dist = expression(rnorm(1, mean = 5, sd = 3)))


###################################################
### code chunk number 109: PhyloSim.Rnw:828-833
###################################################
processes.site.wag<-list(wag, cont.ins.wag, cont.del)
processes.site.lg<-list(lg, cont.ins.lg, cont.del)

templ.seq.wag$processes <- list(processes.site.wag)
templ.seq.lg$processes <- list(processes.site.lg)


###################################################
### code chunk number 110: PhyloSim.Rnw:839-841
###################################################
cont.ins.wag$writeProtected <- FALSE
cont.ins.lg$writeProtected <- FALSE


###################################################
### code chunk number 111: PhyloSim.Rnw:845-847
###################################################
cont.ins.wag$templateSeq <- templ.seq.wag
cont.ins.lg$templateSeq <- templ.seq.lg


###################################################
### code chunk number 112: PhyloSim.Rnw:857-867
###################################################
cont.ins.wag$insertHook <- function(seq, target.seq, event.pos, 
    insert.pos) {
    plusInvGamma(seq, process = wag, pinv = 0.1, shape = 1)
    return(seq)
}
cont.ins.lg$insertHook <- function(seq, target.seq, event.pos, 
    insert.pos) {
    plusInvGamma(seq, process = lg, pinv = 0.1, shape = 1)
    return(seq)
}


###################################################
### code chunk number 113: PhyloSim.Rnw:872-873
###################################################
aa.seq <- AminoAcidSequence(length = 60)


###################################################
### code chunk number 114: PhyloSim.Rnw:880-883
###################################################
process.pattern <- c(rep(list(list(wag, cont.del, cont.ins.wag)), 
    times = 20), rep(list(list(jtt)), times = 20), rep(list(list(lg, 
    cont.del, cont.ins.lg)), times = 20))


###################################################
### code chunk number 115: PhyloSim.Rnw:887-888
###################################################
aa.seq$processes <- process.pattern


###################################################
### code chunk number 116: PhyloSim.Rnw:893-906
###################################################
for (i in 1:aa.seq$length) {
    if (isAttached(aa.seq$sites[[i]], jtt)) {
        setRateMultipliers(aa.seq, jtt, qnorm(runif(1,min=0.5,max=1),mean=0.001,sd=0.01), index = i)
    }
    else if (isAttached(aa.seq$sites[[i]], wag)) {
        plusInvGamma(aa.seq, process = wag, pinv = 0.1, shape = 1, 
            index = i)
    }
    else if (isAttached(aa.seq$sites[[i]], lg)) {
        plusInvGamma(aa.seq, process = lg, pinv = 0.1, shape = 1, 
            index = i)
    }
}


###################################################
### code chunk number 117: PhyloSim.Rnw:910-912
###################################################
sampleStates(aa.seq)
print(aa.seq)


###################################################
### code chunk number 118: PhyloSim.Rnw:916-917
###################################################
plot(aa.seq)


###################################################
### code chunk number 119: PhyloSim.Rnw:921-922
###################################################
tree <- read.tree(file = "smalldemotree.nwk")


###################################################
### code chunk number 120: PhyloSim.Rnw:926-928
###################################################
sim <- PhyloSim(phylo = tree, root.seq = aa.seq)
summary(sim)


###################################################
### code chunk number 121: PhyloSim.Rnw:932-933
###################################################
plot(sim)


###################################################
### code chunk number 122: PhyloSim.Rnw:943-951
###################################################
node.hook <- function(seq) {
    for (site in seq$sites) {
        if (isAttached(site, jtt)) {
            attachProcess(site, pam)
        }
    }
    return(seq)
}


###################################################
### code chunk number 123: PhyloSim.Rnw:955-956
###################################################
attachHookToNode(sim, node = 8, fun = node.hook)


###################################################
### code chunk number 124: PhyloSim.Rnw:964-965
###################################################
Simulate(sim)


###################################################
### code chunk number 125: PhyloSim.Rnw:969-970
###################################################
saveAlignment(sim, file = "example_V3.1_aln.fas", skip.internal = TRUE)


###################################################
### code chunk number 126: PhyloSim.Rnw:973-974
###################################################
plot(sim,num.pages=1)


###################################################
### code chunk number 127: PhyloSim.Rnw:976-977
###################################################
file.remove("example_V3.1_aln.fas")


###################################################
### code chunk number 128: PhyloSim.Rnw:981-982
###################################################
rm(PSIM_FAST)


###################################################
### code chunk number 129: PhyloSim.Rnw:988-989
###################################################
PSIM_FAST <- TRUE


###################################################
### code chunk number 130: PhyloSim.Rnw:992-993
###################################################
p <- GY94()


###################################################
### code chunk number 131: PhyloSim.Rnw:996-997
###################################################
p$kappa = 2


###################################################
### code chunk number 132: PhyloSim.Rnw:1000-1003
###################################################
codon.freqs <- abs(rnorm(61, mean = 10, sd = 3))
codon.freqs <- codon.freqs/sum(codon.freqs)
p$equDist <- codon.freqs


###################################################
### code chunk number 133: PhyloSim.Rnw:1006-1007
###################################################
summary(p)


###################################################
### code chunk number 134: PhyloSim.Rnw:1011-1012
###################################################
plot(p,scale=0.5)


###################################################
### code chunk number 135: PhyloSim.Rnw:1016-1021
###################################################
d<-DiscreteDeletor(
        rate=1,
        sizes=1:4,
        probs=c(4,3,2,1)/10
);


###################################################
### code chunk number 136: PhyloSim.Rnw:1025-1031
###################################################
i<-DiscreteInsertor(
        rate=1.5,
        sizes=1:4,
        probs=c(4,3,2,1)/10,
        template.seq=CodonSequence(length=4,processes=list(list(p)))
);


###################################################
### code chunk number 137: PhyloSim.Rnw:1035-1036
###################################################
s<-CodonSequence(length=30,processes=list(list(p)))


###################################################
### code chunk number 138: PhyloSim.Rnw:1040-1041
###################################################
omegaVarM3(s,p,omegas=c(0,0.5,1),probs=c(2/4,1/4,1/4))


###################################################
### code chunk number 139: PhyloSim.Rnw:1045-1046
###################################################
plotParametersAtSites(s,p,"omega");


###################################################
### code chunk number 140: PhyloSim.Rnw:1050-1051
###################################################
sampleStates(s)


###################################################
### code chunk number 141: PhyloSim.Rnw:1054-1055
###################################################
sim <- PhyloSim(root.seq = s, phylo = read.tree("smalldemotree.nwk"))


###################################################
### code chunk number 142: PhyloSim.Rnw:1059-1066
###################################################
node.hook <- function(seq) {
	setOmegas(seq, p, 1)
	attachProcess(seq, d)
	attachProcess(seq, i)
	return(seq)
}
attachHookToNode(sim, node = 8, fun = node.hook)


###################################################
### code chunk number 143: PhyloSim.Rnw:1073-1074
###################################################
rm(PSIM_FAST)


###################################################
### code chunk number 144: PhyloSim.Rnw:1078-1079
###################################################
Simulate(sim)


###################################################
### code chunk number 145: PhyloSim.Rnw:1083-1084
###################################################
plot(sim,num.pages=1)


###################################################
### code chunk number 146: PhyloSim.Rnw:1088-1089
###################################################
nsyn.subst<-exportStatTree(sim,"nr.nsyn.subst")


###################################################
### code chunk number 147: PhyloSim.Rnw:1093-1095
###################################################
plot(nsyn.subst)
nodelabels()


###################################################
### code chunk number 148: PhyloSim.Rnw:1099-1100
###################################################
saveAlignment(sim, file = "example_V3.2_aln.fas", )


###################################################
### code chunk number 149: PhyloSim.Rnw:1102-1103
###################################################
file.remove("example_V3.2_aln.fas")


###################################################
### code chunk number 150: PhyloSim.Rnw:1113-1114
###################################################
PSIM_FAST<-TRUE;


###################################################
### code chunk number 151: PhyloSim.Rnw:1118-1119
###################################################
ivd<-DiscreteInsertor(rate=0.06,sizes=c(4,6),probs=c(2/3,1/3));


###################################################
### code chunk number 152: PhyloSim.Rnw:1123-1124
###################################################
ivd$templateSeq<-NucleotideSequence(length=1);


###################################################
### code chunk number 153: PhyloSim.Rnw:1130-1147
###################################################
ivd$generateBy<-function(process=NA,length=NA,target.seq=NA,event.pos=NA,insert.pos=NA){
	# get the target sequence length
	target.length<-target.seq$length;
	# construct a vector with the positions to copy:
	positions<-(insert.pos+1):(insert.pos + length)
	# discard illegal positions:
	positions<-positions[ positions > 0 & positions <= target.length];
	# copy subsequence
	insert<-copySubSequence(target.seq,positions,process);
	# reverse complement sequence,
	# take care, the class of this objects is "Sequence":
	revComp.NucleotideSequence(insert);
	# do not allow nested insertions:
	setRateMultipliers(insert,ivd,0);
	# return insert	
	return(insert);
}


###################################################
### code chunk number 154: PhyloSim.Rnw:1152-1153
###################################################
p<-JC69();


###################################################
### code chunk number 155: PhyloSim.Rnw:1157-1158
###################################################
s<-NucleotideSequence(length=50)


###################################################
### code chunk number 156: PhyloSim.Rnw:1161-1162
###################################################
s$processes<-list(list(p,ivd))


###################################################
### code chunk number 157: PhyloSim.Rnw:1167-1168
###################################################
sampleStates(s)


###################################################
### code chunk number 158: PhyloSim.Rnw:1171-1172
###################################################
detachProcess(s,p)


###################################################
### code chunk number 159: PhyloSim.Rnw:1176-1177
###################################################
plusInvGamma(s,ivd,pinv=0.7,shape=0.5)


###################################################
### code chunk number 160: PhyloSim.Rnw:1180-1181
###################################################
sim<-PhyloSim(root.seq=s, phylo=read.tree("smalldemotree.nwk"));


###################################################
### code chunk number 161: PhyloSim.Rnw:1183-1184
###################################################
file.remove("smalldemotree.nwk");


###################################################
### code chunk number 162: PhyloSim.Rnw:1187-1188
###################################################
Simulate(sim)


###################################################
### code chunk number 163: PhyloSim.Rnw:1191-1192
###################################################
plot(sim,num.pages=1)


###################################################
### code chunk number 164: PhyloSim.Rnw:1196-1197
###################################################
saveAlignment(sim,file="example_V3.3.fas");


###################################################
### code chunk number 165: PhyloSim.Rnw:1199-1200
###################################################
file.remove("example_V3.3.fas");


###################################################
### code chunk number 166: PhyloSim.Rnw:1203-1204
###################################################
rm(PSIM_FAST);


###################################################
### code chunk number 167: PhyloSim.Rnw:1238-1239
###################################################
PSIM_FAST<-TRUE;


###################################################
### code chunk number 168: PhyloSim.Rnw:1245-1246
###################################################
part<-list();


###################################################
### code chunk number 169: PhyloSim.Rnw:1250-1278
###################################################
part$nc1<-list(
		"type"="noncoding",
		"len"=1000,
		"subst"=NA,
		"ins"=NA,
		"del"=NA,
		"gamma.shape"=0.5
	);

part$nc1$subst<-GTR(
        rate.params=list(
                "a"=1, "b"=2, "c"=3,
                "d"=1, "e"=2, "f"=3
        ),
        base.freqs=c(1.5,1,1.5,1)/5
)

part$nc1$ins<-DiscreteInsertor(
	rate=0.025,sizes=1:6,
	probs=6:1/21,
	template.seq=NucleotideSequence(string="CCCCCC")
);

part$nc1$del<-DiscreteDeletor(
        rate=0.025,
        sizes=1:6,
        probs=6:1/21
);


###################################################
### code chunk number 170: PhyloSim.Rnw:1283-1292
###################################################
part$e1<-list(
		"type"="first.exon",
		"len"=400,
		"subst"=NA,
		"ins"=NA,
		"del"=NA,
		"omegas"=c(0,1,1.1),
		"omega.probs"=c(4,2,1)/5
	);


###################################################
### code chunk number 171: PhyloSim.Rnw:1296-1318
###################################################
part$e1$subst<-GY94(kappa=2,scale.nuc=TRUE);

part$e1$ins<-DiscreteInsertor(
        rate=0.025,
        sizes=1:2,
        probs=c(2/3,1/3),
        template.seq=CodonSequence(length=2,processes=list(list(part$e1$subst)))
);


part$e1$del<-DiscreteDeletor(
        rate=0.025,
        sizes=1:2,
        probs=c(2/3,1/3)
);


f84<-F84();
f84$kappa<-1.8;

gy94.e2_5<-clone(part$e1$subst);
gy94.e2_5$kappa<-1.5


###################################################
### code chunk number 172: PhyloSim.Rnw:1322-1355
###################################################
del.introns<-DiscreteDeletor(
        rate=0.025,
	sizes=1:8,
        probs=8:1/36
);

ins.introns<-DiscreteInsertor(
        rate=0.025,
        sizes=1:8,
        probs=8:1/36,
        template.seq=NucleotideSequence(length=8,processes=list(list(f84)))
);

for(i in 1:4){
	part[[paste("i",i,sep="")]]<-list(
		"type"="intron",
		"len"=200,
		"subst"=f84,
		"ins"=ins.introns,
		"del"=del.introns,
		"gamma.shape"=abs(rnorm(1,mean=1,sd=0.2))
	)
	part[[paste("e",i+1,sep="")]]<-list(
		"type"="exon",
		"len"=200,
		"subst"=gy94.e2_5,
		"ins"=NA,
		"del"=NA,
		"omegas"=c(0,0.5),
		"omega.probs"=c(3/4,1/4)
	)

}


###################################################
### code chunk number 173: PhyloSim.Rnw:1359-1368
###################################################
part$i5<-list(
		"type"="intron",
                "len"=200,
                "subst"=f84,
                "ins"=ins.introns,
                "del"=del.introns,
                "gamma.shape"=abs(rnorm(1,mean=1,sd=0.1))
)
rm(f84,gy94.e2_5,del.introns,ins.introns);


###################################################
### code chunk number 174: PhyloSim.Rnw:1372-1398
###################################################
part$e6<-list(
		"type"="last.exon",
		"len"=400,
		"subst"=NA,
		"ins"=NA,
		"del"=NA,
		"omegas"=c(0,1,1.1),
		"omega.probs"=c(4,2,1)/5
);

tmp<-clone(part$e1$subst);
tmp$kappa<-0.5;
part$e6$subst<-tmp;

part$e6$del<-DiscreteDeletor(
        rate=0.025,
        sizes=1:4,
        probs=c(4,3,2,1)/10
);

part$e6$ins<-DiscreteInsertor(
        rate=0.025,
        sizes=1:2,
        probs=c(1/3,2/3),
        template.seq=CodonSequence(length=2,processes=list(list(part$e6$subst)))
);


###################################################
### code chunk number 175: PhyloSim.Rnw:1402-1410
###################################################
part$nc2<-list(
		"type"="noncoding",
		"len"=1400,
		"subst"=K80(rate.params=list(Alpha = 2, Beta = 1)),
		"ins"=NA,
		"del"=NA,
		"gamma.shape"=0.5
	);


###################################################
### code chunk number 176: PhyloSim.Rnw:1415-1416
###################################################
s<-Sequence(length=5000);


###################################################
### code chunk number 177: PhyloSim.Rnw:1420-1422
###################################################
nuc<-NucleotideAlphabet();
cod<-CodonAlphabet();


###################################################
### code chunk number 178: PhyloSim.Rnw:1426-1427
###################################################
stop.alphabet<-Alphabet(symbols=c("TAG","TAA","TGA"));


###################################################
### code chunk number 179: PhyloSim.Rnw:1431-1442
###################################################
stop.subst<-GeneralSubstitution(
		alphabet=stop.alphabet,
		rate.list=list(
				"TAG->TAA"=1,
				"TAG->TGA"=2,
				"TAA->TAG"=3,
				"TAA->TGA"=1,
				"TGA->TAG"=2,
				"TGA->TAA"=3
			)
		);


###################################################
### code chunk number 180: PhyloSim.Rnw:1446-1447
###################################################
plot(stop.subst,scale=0.5);


###################################################
### code chunk number 181: PhyloSim.Rnw:1453-1516
###################################################
pos<-0;
for(i in part){
	beg<-pos+1;	
	end<-pos+i$len;	
	range<-beg:end;


	if( (i$type=="noncoding") | (i$type=="intron") ){
		setAlphabets(s,list(nuc),range);
	}
	else {
		setAlphabets(s,list(cod),range);
	}
	
	if(!is.na(i$del)){
		attachProcess(s,i$del,range);
	}
	if(!is.na(i$ins)){
		attachProcess(s,i$ins,range);
	}

	if( (i$type=="noncoding") | (i$type=="intron")){
		attachProcess(s,i$subst,range);

		plusInvGamma(this=s,process=i$subst,pinv=0.6,shape=i$gamma.shape,range);
		if(i$type=="intron"){
			# fix splicing sites
			setStates(s,c("G","T","A","G"),c(beg,beg+1,end-1,end));
			setRateMultipliers(s,i$subst,0,c(beg,beg+1,end-1,end));
			setInsertionTolerance(s,i$ins,0,c(beg,beg+1,end-1,end));
			setDeletionTolerance(s,i$del,0,c(beg,beg+1,end-1,end));
		}
	} 
	else if(i$type=="exon"){
		attachProcess(s,i$subst,range);

		omegaVarM3.CodonSequence(s,i$subst,i$omegas,i$omega.probs,range);
	}
	if(i$type=="first.exon"){
		attachProcess(s,i$subst,range);
		# Fix start codon:
		setStates(s,"ATG",beg);
		setRateMultipliers(s,i$subst,0,beg)
		setInsertionTolerance(s,i$ins,0,beg);
		setDeletionTolerance(s,i$del,0,beg);
	}
	if(i$type=="last.exon"){
		attachProcess(s,i$subst,range);
		# Detach GY94 from last site:
		detachProcess(s,i$subst,end);
		# Replace alphabet:
		setAlphabets(s,list(stop.alphabet),end);
		# Attach stop codon process:
		attachProcess(s,stop.subst,end);
		# Sample stop codon:
		sampleStates(s,end);
		# Protect against indels:
		setInsertionTolerance(s,i$ins,0,end);
		setDeletionTolerance(s,i$del,0,end);
	}
	
	pos<-end;
}


###################################################
### code chunk number 182: PhyloSim.Rnw:1521-1522
###################################################
sampleStates(s);


###################################################
### code chunk number 183: PhyloSim.Rnw:1526-1527
###################################################
sim<-PhyloSim(root.seq=s, phylo=rcoal(3));


###################################################
### code chunk number 184: PhyloSim.Rnw:1531-1532
###################################################
scaleTree(sim,0.15/sim$treeLength);


###################################################
### code chunk number 185: PhyloSim.Rnw:1536-1537
###################################################
Simulate(sim)


###################################################
### code chunk number 186: PhyloSim.Rnw:1541-1542
###################################################
plot(sim,num.pages="auto",plot.ancestors=FALSE)


###################################################
### code chunk number 187: PhyloSim.Rnw:1546-1547
###################################################
saveAlignment(sim,file="example_V3.4.fas");


###################################################
### code chunk number 188: PhyloSim.Rnw:1549-1550
###################################################
file.remove("example_V3.4.fas");


###################################################
### code chunk number 189: PhyloSim.Rnw:1554-1555
###################################################
rm(PSIM_FAST)


